# zip

> Упаковывает и сжимает (архивирует) файлы в файл zip.
> Смотрите также: `unzip`.
> Больше информации: <https://manned.org/zip>.

- Добавить файлы/папки в указанный архив ([r]ecursively):

`zip {{[-r|--recurse-paths]}} {{путь/до/архива.zip}} {{путь/до/файла_или_папки1 путь/до/файла_или_папки2 ...}}`

- Удалить файлы/папки из указанного архива ([d]elete):

`zip {{[-d|--delete]}} {{путь/до/архива.zip}} {{путь/до/файла_или_папки1 путь/до/файла_или_папки2 ...}}`

- Заархивировать файлы/папки, исключая некоторые (e[x]clude):

`zip {{[-r|--recurse-paths]}} {{путь/до/архива.zip}} {{путь/до/файла_или_папки1 путь/до/файла_или_папки2 ...}} {{[-x|--exclude]}} {{путь/до/исключаемых_файлов_или_папок}}`

- Заархивировать файлы/папки с заданной степенью сжатия (`0` — без сжатия, `9` — максимальная):

`zip {{[-r|--recurse-paths]}} -{{0-9}} {{путь/до/архива.zip}} {{путь/до/файла_или_папки1 путь/до/файла_или_папки2 ...}}`

- Создать зашифрованный паролем архив ([e]ncrypted):

`zip {{[-re|--recurse-paths --encrypt]}} {{путь/до/архива.zip}} {{путь/до/файла_или_папки1 путь/до/файла_или_папки2 ...}}`

- Заархивировать файлы/папки в многотомный архив ([s]plit), например, частями по 3 Гб:

`zip {{[-rs|--recurse-paths --split-size]}} {{3g}} {{путь/до/архива.zip}} {{путь/до/файла_или_папки1 путь/до/файла_или_папки2 ...}}`

- Вывести содержимое указанного архива ([s]how [f]iles):

`zip {{[-sf|--split-size --freshen]}} {{путь/до/архива.zip}}`
