# gzip

> 使用 `gzip` (LZ77) 压缩/解压文件。
> 更多信息：<https://www.gnu.org/software/gzip/manual/gzip.html>.

- 压缩文件，将其替换为 `gzip` 存档文件：

`gzip {{路径/到/文件}}`

- 解压缩文件，将其替换为原始未压缩版本：

`gzip {{[-d|--decompress]}} {{路径/到/文件.gz}}`

- 压缩文件，保留原始文件：

`gzip {{[-k|--keep]}} {{路径/到/文件}}`

- 压缩文件，指定输出文件名：

`gzip {{[-c|--stdout]}} {{路径/到/文件}} > {{路径/到/压缩文件.gz}}`

- 解压缩 `gzip` 存档，指定输出文件名：

`gzip {{[-c|--stdout]}} {{[-d|--decompress]}} {{路径/到/文件.gz}} > {{路径/到/解压缩的文件名}}`

- 指定压缩级别。 1 为最快（低压缩率），9 为最慢（高压缩率），默认值是 6：

`gzip -{{1..9}} {{[-c|--stdout]}} {{路径/到/文件}} > {{路径/到/压缩文件.gz}}`

- 显示压缩或解压后的每个文件的名称和压缩百分比：

`gzip {{[-v|--verbose]}} {{[-d|--decompress]}} {{路径/到/文件.gz}}`
