//============================================================================
//  The contents of this file are covered by the Viskores license. See
//  LICENSE.txt for details.
//
//  By contributing to this file, all contributors agree to the Developer
//  Certificate of Origin Version 1.1 (DCO 1.1) as stated in DCO.txt.
//============================================================================

//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
// Copyright (c) 2018, The Regents of the University of California, through
// Lawrence Berkeley National Laboratory (subject to receipt of any required approvals
// from the U.S. Dept. of Energy).  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
// (1) Redistributions of source code must retain the above copyright notice, this
//     list of conditions and the following disclaimer.
//
// (2) Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
// (3) Neither the name of the University of California, Lawrence Berkeley National
//     Laboratory, U.S. Dept. of Energy nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
// BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
//
//=============================================================================
//
//  This code is an extension of the algorithm presented in the paper:
//  Parallel Peak Pruning for Scalable SMP Contour Tree Computation.
//  Hamish Carr, Gunther Weber, Christopher Sewell, and James Ahrens.
//  Proceedings of the IEEE Symposium on Large Data Analysis and Visualization
//  (LDAV), October 2016, Baltimore, Maryland.
//
//  The PPP2 algorithm and software were jointly developed by
//  Hamish Carr (University of Leeds), Gunther H. Weber (LBNL), and
//  Oliver Ruebel (LBNL)
//==============================================================================

#ifndef viskores_worklet_contourtree_distributed_boundary_tree_maker_compress_regularised_nodes_fill_bract_superarcs_worklet_h
#define viskores_worklet_contourtree_distributed_boundary_tree_maker_compress_regularised_nodes_fill_bract_superarcs_worklet_h

#include <viskores/filter/scalar_topology/worklet/contourtree_augmented/Types.h>
#include <viskores/worklet/WorkletMapField.h>

namespace viskores
{
namespace worklet
{
namespace contourtree_distributed
{
namespace bract_maker
{

/// Step 1 of IdentifyRegularisedSupernodes
class CompressRegularisedNodesFillBoundaryTreeSuperarcsWorklet
  : public viskores::worklet::WorkletMapField
{
public:
  using ControlSignature = void(WholeArrayIn newSuperarc,
                                WholeArrayIn reverseSorter,
                                FieldIn vertexSorter,
                                FieldOut bractSuperarcs);
  using ExecutionSignature = _4(_1, _2, _3);
  using InputDomain = _1;

  // Default Constructor
  VISKORES_EXEC_CONT
  CompressRegularisedNodesFillBoundaryTreeSuperarcsWorklet() {}

  template <typename InFieldPortalType>
  VISKORES_EXEC viskores::Id operator()(const InFieldPortalType newSuperarcPortal,
                                        const InFieldPortalType reverseSorterPortal,
                                        const viskores::Id& vertexSorterIndex) const
  {
    viskores::Id newSuperarcIndex = newSuperarcPortal.Get(vertexSorterIndex);
    if (viskores::worklet::contourtree_augmented::NoSuchElement(newSuperarcIndex))
    {
      return viskores::worklet::contourtree_augmented::NO_SUCH_ELEMENT;
    }
    else
    {
      return reverseSorterPortal.Get(newSuperarcIndex);
    }

    // In serial this worklet implements the following operation
    /*
    for (indexType bractID = 0; bractID < newSuperarc.size(); bractID++)
      { // per bract node
      // do the same for the superarc, testing for NO_SUCH_ELEMENT
      if (noSuchElement(newSuperarc[vertexSorter[bractID]]))
        bract->superarcs[bractID] = NO_SUCH_ELEMENT;
      else
        bract->superarcs[bractID] = reverseSorter[newSuperarc[vertexSorter[bractID]]];
      } // per bract node

    */
  }
}; // CompressRegularisedNodesFillBoundaryTreeSuperarcsWorklet


} // namespace bract_maker
} // namespace contourtree_distributed
} // namespace worklet
} // namespace viskores

#endif
