# This file was automatically generated by bifcl from /opt/local/var/macports/build/zeek-devel-c10ab06c/work/zeek-8.1.0/src/packet_analysis/protocol/icmp/events.bif (plugin mode).

export {
## Generated for all ICMP messages that are not handled separately with
## dedicated ICMP events. Zeek's ICMP analyzer handles a number of ICMP messages
## directly with dedicated events. This event acts as a fallback for those it
## doesn't.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## info: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## .. zeek:see:: icmp_error_message icmp_sent_payload
global icmp_sent: event(c: connection , info: icmp_info );


## The same as :zeek:see:`icmp_sent` except containing the ICMP payload.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## info: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## payload: The payload of the ICMP message.
##
## .. zeek:see:: icmp_error_message icmp_sent_payload
global icmp_sent_payload: event(c: connection , info: icmp_info , payload: string );


## Generated for ICMP *echo request* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## info: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## id: The *echo request* identifier.
##
## seq: The *echo request* sequence number.
##
## payload: The message-specific data of the packet payload, i.e., everything
##          after the first 8 bytes of the ICMP header.
##
## .. zeek:see:: icmp_echo_reply
global icmp_echo_request: event(c: connection , info: icmp_info , id: count , seq: count , payload: string );


## Generated for ICMP *echo reply* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## id: The *echo reply* identifier.
##
## seq: The *echo reply* sequence number.
##
## payload: The message-specific data of the packet payload, i.e., everything
##          after the first 8 bytes of the ICMP header.
##
## .. zeek:see:: icmp_echo_request
global icmp_echo_reply: event(c: connection , info: icmp_info , id: count , seq: count , payload: string );


## Generated for all ICMPv6 error messages that are not handled
## separately with dedicated events. Zeek's ICMP analyzer handles a number
## of ICMP error messages directly with dedicated events. This event acts
## as a fallback for those it doesn't.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/ICMPv6>`__ for more
## information about the ICMPv6 protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## info: Additional ICMP-specific information augmenting the standard
##       connection record *c*.
##
## code: The ICMP code of the error message.
##
## context: A record with specifics of the original packet that the message
##          refers to.
##
## .. zeek:see:: icmp_unreachable icmp_packet_too_big
##    icmp_time_exceeded icmp_parameter_problem
global icmp_error_message: event(c: connection , info: icmp_info , code: count , context: icmp_context );


## Generated for ICMP *destination unreachable* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## code: The ICMP code of the *unreachable* message.
##
## context: A record with specifics of the original packet that the message
##          refers to. *Unreachable* messages should include the original IP
##          header from the packet that triggered them, and Zeek parses that
##          into the *context* structure. Note that if the *unreachable*
##          includes only a partial IP header for some reason, no
##          fields of *context* will be filled out.
##
## .. zeek:see:: icmp_error_message icmp_packet_too_big
##    icmp_time_exceeded icmp_parameter_problem
global icmp_unreachable: event(c: connection , info: icmp_info , code: count , context: icmp_context );


## Generated for ICMPv6 *packet too big* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/ICMPv6>`__ for more
## information about the ICMPv6 protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## code: The ICMP code of the *too big* message.
##
## context: A record with specifics of the original packet that the message
##          refers to. *Too big* messages should include the original IP header
##          from the packet that triggered them, and Zeek parses that into
##          the *context* structure. Note that if the *too big* includes only
##          a partial IP header for some reason, no fields of *context* will
##          be filled out.
##
## .. zeek:see:: icmp_error_message icmp_unreachable
##    icmp_time_exceeded icmp_parameter_problem
global icmp_packet_too_big: event(c: connection , info: icmp_info , code: count , context: icmp_context );


## Generated for ICMP *time exceeded* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## code: The ICMP code of the *exceeded* message.
##
## context: A record with specifics of the original packet that the message
##          refers to. *Unreachable* messages should include the original IP
##          header from the packet that triggered them, and Zeek parses that
##          into the *context* structure. Note that if the *exceeded* includes
##          only a partial IP header for some reason, no fields of *context*
##          will be filled out.
##
## .. zeek:see:: icmp_error_message icmp_unreachable icmp_packet_too_big
##    icmp_parameter_problem
global icmp_time_exceeded: event(c: connection , info: icmp_info , code: count , context: icmp_context );


## Generated for ICMPv6 *parameter problem* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/ICMPv6>`__ for more
## information about the ICMPv6 protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## code: The ICMP code of the *parameter problem* message.
##
## context: A record with specifics of the original packet that the message
##          refers to. *Parameter problem* messages should include the original
##          IP header from the packet that triggered them, and Zeek parses that
##          into the *context* structure. Note that if the *parameter problem*
##          includes only a partial IP header for some reason, no fields
##          of *context* will be filled out.
##
## .. zeek:see:: icmp_error_message icmp_unreachable icmp_packet_too_big
##    icmp_time_exceeded
global icmp_parameter_problem: event(c: connection , info: icmp_info , code: count , context: icmp_context );


## Generated for ICMP *router solicitation* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## options: Any Neighbor Discovery options included with message (:rfc:`4861`).
##
## .. zeek:see:: icmp_router_advertisement
##    icmp_neighbor_solicitation icmp_neighbor_advertisement icmp_redirect
global icmp_router_solicitation: event(c: connection , info: icmp_info , options: icmp6_nd_options );


## Generated for ICMP *router advertisement* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## cur_hop_limit: The default value that should be placed in Hop Count field
##                for outgoing IP packets.
##
## managed: Managed address configuration flag, :rfc:`4861`.
##
## other: Other stateful configuration flag, :rfc:`4861`.
##
## home_agent: Mobile IPv6 home agent flag, :rfc:`3775`.
##
## pref: Router selection preferences, :rfc:`4191`.
##
## proxy: Neighbor discovery proxy flag, :rfc:`4389`.
##
## rsv: Remaining two reserved bits of router advertisement flags.
##
## router_lifetime: How long this router should be used as a default router.
##
## reachable_time: How long a neighbor should be considered reachable.
##
## retrans_timer: How long a host should wait before retransmitting.
##
## options: Any Neighbor Discovery options included with message (:rfc:`4861`).
##
## .. zeek:see:: icmp_router_solicitation
##    icmp_neighbor_solicitation icmp_neighbor_advertisement icmp_redirect
global icmp_router_advertisement: event(c: connection , info: icmp_info , cur_hop_limit: count , managed: bool , other: bool , home_agent: bool , pref: count , proxy: bool , rsv: count , router_lifetime: interval , reachable_time: interval , retrans_timer: interval , options: icmp6_nd_options );


## Generated for ICMP *neighbor solicitation* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## tgt: The IP address of the target of the solicitation.
##
## options: Any Neighbor Discovery options included with message (:rfc:`4861`).
##
## .. zeek:see:: icmp_router_solicitation icmp_router_advertisement
##    icmp_neighbor_advertisement icmp_redirect
global icmp_neighbor_solicitation: event(c: connection , info: icmp_info , tgt: addr , options: icmp6_nd_options );


## Generated for ICMP *neighbor advertisement* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## router: Flag indicating the sender is a router.
##
## solicited: Flag indicating advertisement is in response to a solicitation.
##
## override: Flag indicating advertisement should override existing caches.
##
## tgt: the Target Address in the soliciting message or the address whose
##      link-layer address has changed for unsolicited adverts.
##
## options: Any Neighbor Discovery options included with message (:rfc:`4861`).
##
## .. zeek:see:: icmp_router_solicitation icmp_router_advertisement
##    icmp_neighbor_solicitation icmp_redirect
global icmp_neighbor_advertisement: event(c: connection , info: icmp_info , router: bool , solicited: bool , override: bool , tgt: addr , options: icmp6_nd_options );


## Generated for ICMP *redirect* messages.
##
## See `Wikipedia
## <https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol>`__ for more
## information about the ICMP protocol.
##
## c: The connection record for the corresponding ICMP flow.
##
## icmp: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## info: Additional ICMP-specific information augmenting the standard connection
##       record *c*.
##
## tgt: The address that is supposed to be a better first hop to use for
##      ICMP Destination Address.
##
## dest: The address of the destination which is redirected to the target.
##
## options: Any Neighbor Discovery options included with message (:rfc:`4861`).
##
## .. zeek:see:: icmp_router_solicitation icmp_router_advertisement
##    icmp_neighbor_solicitation icmp_neighbor_advertisement
global icmp_redirect: event(c: connection , info: icmp_info , tgt: addr , dest: addr , options: icmp6_nd_options );

} # end of export section
module GLOBAL;
