/*
 * Copyright 2006-2008 The FLWOR Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ZORBA_DEBUGGER_EXCEPTION_H
#define ZORBA_DEBUGGER_EXCEPTION_H

#include <zorba/config.h>
#include <exception>
#include <string>

namespace zorba{

/**
 *   Signals a problem with the execution of a socket call.
 */
class ZORBA_DLL_PUBLIC DebuggerSocketException : public std::exception {
public:
  /**
   *   Construct a SocketException with a explanatory message.
   *   @param message explanatory message
   *   @param inclSysMsg true if system message (from strerror(errno))
   *   should be postfixed to the user provided message
   */
  DebuggerSocketException(const std::string &message, bool inclSysMsg = false) throw();

  /**
   *   Provided just to guarantee that no exceptions are thrown.
   */
  ~DebuggerSocketException() throw();

  /**
   *   Get the exception message
   *   @return exception message
   */
  const char *what() const throw();

private:
  std::string userMessage;  // Exception message
};
}//end of namespace
#endif
/* vim:set et sw=2 ts=2: */
