/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.geneanet;

import ancestris.modules.exports.geneanet.entity.GeneanetParserResult;
import ancestris.modules.exports.geneanet.entity.GeneanetStatusEnum;
import ancestris.modules.exports.geneanet.entity.GeneanetToken;
import ancestris.modules.exports.geneanet.entity.GeneanetUpdateStatus;
import ancestris.modules.exports.geneanet.utils.GeneanetException;
import ancestris.modules.exports.geneanet.utils.GeneanetLogWorker;
import ancestris.modules.exports.geneanet.utils.GeneanetMediaProducer;
import ancestris.modules.exports.geneanet.utils.GeneanetMediaWorker;
import ancestris.modules.exports.geneanet.utils.GeneanetQueueManager;
import ancestris.modules.exports.geneanet.utils.GeneanetUtil;
import ancestris.usage.UsageManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class GeneanetSynchronizePanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private final File geneanetFile;
    private String clientId;
    private String secretId;
    private GeneanetToken token;
    private final Context currentContext;
    private Set<String> mediaAlreadySentList = ConcurrentHashMap.newKeySet();
    private Preferences prefs;
    private final int nbWorker = 5;
    private JLabel encoursFile;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel idLabel;
    private JTextField idTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel nbEncoursFile;
    private JLabel nbMediaLabel;
    private JLabel nbMediaValue;
    private JTextArea progressArea;
    private JLabel pwdLabel;
    private JPasswordField pwdTextField;
    private JCheckBox sendAgainCb;
    private JCheckBox sendMediaCb;
    private JButton syncButton;

    public GeneanetSynchronizePanel(File file, Context context) {
        this.initComponents();
        this.geneanetFile = file;
        this.fileTextField.setText(file.getAbsolutePath());
        this.currentContext = context;
        this.getIds();
        this.loadSettings();
        this.checkMedias();
        this.encoursFile.setText("");
        this.nbEncoursFile.setText("");
    }

    private void getIds() {
        String retour = UsageManager.getKey((String)"K0000001");
        if (retour == null || "".equals(retour)) {
            LOG.log(Level.SEVERE, NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"ids.not.found"));
            this.progressArea.setText("");
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"ids.not.found"));
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"ids.solution"));
            this.syncButton.setEnabled(false);
            return;
        }
        String[] ids = retour.split(" ");
        this.clientId = ids[0];
        this.secretId = ids[1];
    }

    private void loadSettings() {
        Registry registry = this.currentContext.getGedcom().getRegistry();
        String oldUsername = registry.get("Geneanet.username", "");
        String oldPwd = registry.get("Geneanet.pwd", "");
        String oldMediaList = registry.get("Geneanet.medialist", "");
        registry.remove("Geneanet.username");
        registry.remove("Geneanet.pwd");
        registry.remove("Geneanet.medialist");
        if (this.prefs == null) {
            this.prefs = NbPreferences.forModule(GeneanetSynchronizePanel.class).node(this.currentContext.getGedcom().getName());
        }
        this.idTextField.setText(this.prefs.get("Geneanet.username", oldUsername));
        this.pwdTextField.setText(this.prefs.get("Geneanet.pwd", oldPwd));
        String mediaList = this.prefs.get("Geneanet.medialist", oldMediaList);
        this.mediaAlreadySentList = Arrays.stream(mediaList.split(",")).collect(Collectors.toCollection(HashSet::new));
    }

    private void saveSettings() {
        if (this.prefs == null) {
            return;
        }
        this.prefs.put("Geneanet.username", this.idTextField.getText());
        this.prefs.put("Geneanet.pwd", String.valueOf(this.pwdTextField.getPassword()));
        this.prefs.put("Geneanet.medialist", this.mediaAlreadySentList.stream().collect(Collectors.joining(",")));
    }

    private void checkMedias() {
        Gedcom gedcom = this.currentContext.getGedcom();
        this.nbMediaValue.setText(String.valueOf(gedcom.getPropertyCount("FILE") - 1));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.syncButton = new JButton();
        this.idLabel = new JLabel();
        this.idTextField = new JTextField();
        this.pwdTextField = new JPasswordField();
        this.pwdLabel = new JLabel();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.nbMediaLabel = new JLabel();
        this.nbMediaValue = new JLabel();
        this.sendMediaCb = new JCheckBox();
        this.nbEncoursFile = new JLabel();
        this.encoursFile = new JLabel();
        this.sendAgainCb = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.progressArea = new JTextArea();
        Mnemonics.setLocalizedText((AbstractButton)this.syncButton, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.syncButton.text"));
        this.syncButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneanetSynchronizePanel.this.syncButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.idLabel, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.idLabel.text"));
        this.idLabel.setMaximumSize(new Dimension(119, 25));
        this.idLabel.setMinimumSize(new Dimension(119, 25));
        this.idLabel.setPreferredSize(new Dimension(119, 25));
        this.idTextField.setText(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.idTextField.text"));
        this.idTextField.setToolTipText(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.idTextField.toolTipText"));
        this.idTextField.setMaximumSize(new Dimension(500, 25));
        this.idTextField.setMinimumSize(new Dimension(6, 25));
        this.idTextField.setPreferredSize(new Dimension(69, 25));
        this.pwdTextField.setText(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.pwdTextField.text"));
        this.pwdTextField.setMaximumSize(new Dimension(500, 25));
        this.pwdTextField.setMinimumSize(new Dimension(6, 25));
        this.pwdTextField.setPreferredSize(new Dimension(69, 25));
        Mnemonics.setLocalizedText((JLabel)this.pwdLabel, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.pwdLabel.text"));
        this.pwdLabel.setMaximumSize(new Dimension(113, 25));
        this.pwdLabel.setMinimumSize(new Dimension(113, 25));
        this.pwdLabel.setPreferredSize(new Dimension(113, 25));
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.fileLabel.text"));
        this.fileLabel.setMaximumSize(new Dimension(92, 25));
        this.fileLabel.setMinimumSize(new Dimension(92, 25));
        this.fileLabel.setPreferredSize(new Dimension(92, 25));
        this.fileTextField.setText(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.fileTextField.text"));
        this.fileTextField.setToolTipText(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.fileTextField.toolTipText"));
        this.fileTextField.setEnabled(false);
        this.fileTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.fileTextField.setMinimumSize(new Dimension(6, 25));
        this.fileTextField.setPreferredSize(new Dimension(69, 25));
        Mnemonics.setLocalizedText((JLabel)this.nbMediaLabel, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.nbMediaLabel.text"));
        this.nbMediaLabel.setMaximumSize(new Dimension(173, 25));
        this.nbMediaLabel.setMinimumSize(new Dimension(92, 25));
        this.nbMediaLabel.setPreferredSize(new Dimension(92, 25));
        Mnemonics.setLocalizedText((JLabel)this.nbMediaValue, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.nbMediaValue.text"));
        this.sendMediaCb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.sendMediaCb, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.sendMediaCb.text"));
        this.sendMediaCb.setToolTipText(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.sendMediaCb.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.nbEncoursFile, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.nbEncoursFile.text"));
        this.nbEncoursFile.setMaximumSize(new Dimension(15, 25));
        this.nbEncoursFile.setMinimumSize(new Dimension(15, 25));
        Mnemonics.setLocalizedText((JLabel)this.encoursFile, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.encoursFile.text"));
        this.encoursFile.setMaximumSize(new Dimension(300, 25));
        this.encoursFile.setMinimumSize(new Dimension(300, 25));
        Mnemonics.setLocalizedText((AbstractButton)this.sendAgainCb, (String)NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.sendAgainCb.text"));
        this.sendAgainCb.setToolTipText(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"GeneanetSynchronizePanel.sendAgainCb.toolTipText"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.fileLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pwdLabel, -1, -1, Short.MAX_VALUE).addComponent(this.idLabel, -1, 173, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.nbMediaLabel, -2, 109, -2).addGap(18, 18, 18).addComponent(this.nbMediaValue))).addComponent(this.nbEncoursFile, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.encoursFile, -2, 443, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 99, Short.MAX_VALUE).addComponent(this.syncButton)).addComponent(this.pwdTextField, -1, -1, Short.MAX_VALUE).addComponent(this.idTextField, -1, -1, Short.MAX_VALUE).addComponent(this.fileTextField, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.sendMediaCb, -2, 273, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sendAgainCb, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idLabel, -2, 25, -2).addComponent(this.idTextField, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pwdTextField, -2, 25, -2).addComponent(this.pwdLabel, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel, -2, 25, -2).addComponent(this.fileTextField, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nbMediaLabel, -2, -1, -2).addComponent(this.nbMediaValue).addComponent(this.sendMediaCb).addComponent(this.sendAgainCb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 22, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.syncButton).addComponent(this.nbEncoursFile, -2, -1, -2).addComponent(this.encoursFile, -2, -1, -2)).addContainerGap()));
        this.progressArea.setColumns(20);
        this.progressArea.setRows(5);
        this.jScrollPane1.setViewportView(this.progressArea);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 390, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void syncButtonActionPerformed(ActionEvent evt) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                GeneanetSynchronizePanel.this.synchronize();
                return "done";
            }
        };
        worker.execute();
    }

    private void synchronize() {
        this.progressArea.setText("");
        if (this.sendAgainCb.isSelected()) {
            this.mediaAlreadySentList.clear();
        }
        try {
            if (this.token == null) {
                this.token = GeneanetUtil.getToken(this.idTextField.getText(), String.valueOf(this.pwdTextField.getPassword()), this.clientId, this.secretId);
            }
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"token.ok.message"));
            if (!GeneanetUtil.getUserInfo(this.token)) {
                this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"userinfo.tree.error"));
                return;
            }
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"userinfo.ok.message"));
            GeneanetUtil.sendFile(this.token, this.geneanetFile);
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"tree.ok.message"));
            GeneanetUpdateStatus status = GeneanetUtil.getStatus(this.token);
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)status.getStatus().getStatus()) + " " + status.getStep().getStep() + "/5 " + NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)status.getStep().getStepName()));
            while (GeneanetStatusEnum.RUNNING == status.getStatus()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.FINE, "Error during sleep", e);
                }
                status = GeneanetUtil.getStatus(this.token);
                this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)status.getStatus().getStatus()) + " " + status.getStep().getStep() + "/5 " + NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)status.getStep().getStepName()));
            }
            if (status.getStatus() == GeneanetStatusEnum.ERROR) {
                throw new GeneanetException("status.done.error", null, null);
            }
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"status.ok.message"));
            if (this.sendMediaCb.isSelected()) {
                this.sendMedia();
            }
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"done.ok"));
        }
        catch (GeneanetException e) {
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)e.getLocalCode()));
        }
        this.saveSettings();
    }

    private void sendMedia() throws GeneanetException {
        GeneanetParserResult pResult = GeneanetUtil.getMediaStatus(this.token);
        this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.number.ok") + pResult.getNbMedia());
        this.nbMediaValue.setText(String.valueOf(pResult.getNbMedia()));
        if (!pResult.getKoMedia().isEmpty()) {
            this.updateTextArea(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.ko"));
            for (String koMedia : pResult.getKoMedia()) {
                this.updateTextArea(koMedia);
            }
        }
        GeneanetQueueManager gqm = new GeneanetQueueManager();
        new Thread(new GeneanetMediaProducer(gqm, this.mediaAlreadySentList, pResult.getOkMedia(), this.currentContext.getGedcom(), 5)).start();
        for (int i = 0; i < 5; ++i) {
            new Thread(new GeneanetMediaWorker(gqm, this.token, this.mediaAlreadySentList, this.nbEncoursFile, this.encoursFile)).start();
        }
        new Thread(new GeneanetLogWorker(gqm, this.progressArea, 5)).start();
        try {
            Thread.sleep(5000L);
            while (gqm.countMedia() != 0) {
                LOG.log(Level.INFO, "sleep media");
                Thread.sleep(1000L);
            }
            while (gqm.countUpdate() != 0) {
                LOG.log(Level.INFO, "sleep message");
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            LOG.log(Level.INFO, "interrupted during rest ", e);
        }
    }

    private void updateTextArea(String value) {
        this.progressArea.append(value);
        this.progressArea.append("\n");
    }
}

