/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graphstream.algorithm.generator.BaseGenerator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;

public class URLGenerator
extends BaseGenerator {
    private static String REGEX = "href=\"([^\"]*)\"";
    protected HashSet<String> urls = new HashSet();
    protected LinkedList<String> stepUrls = new LinkedList();
    protected HashSet<String> newUrls = new HashSet();
    protected Pattern hrefPattern = Pattern.compile(REGEX);
    protected Mode mode = Mode.HOST;
    protected int threads = 2;
    protected String nodeWeight = "weight";
    protected String edgeWeight = "weight";
    protected LinkedList<URLFilter> filters = new LinkedList();
    protected double step;
    protected boolean printProgress;
    protected int depthLimit;
    protected final ReentrantLock lock;

    public URLGenerator(String ... startFrom) {
        this.directed = false;
        this.step = 0.0;
        this.printProgress = false;
        this.depthLimit = 0;
        this.lock = new ReentrantLock();
        this.declineMatchingURL("^(javascript:|mailto:|#).*");
        this.declineMatchingURL(".*[.](avi|tar|gz|zip|mp3|mpg|jpg|jpeg|png|ogg|flv|ico|svg)$");
        this.setUseInternalGraph(true);
        if (startFrom != null) {
            for (int i = 0; i < startFrom.length; ++i) {
                this.stepUrls.add(startFrom[i]);
            }
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public boolean nextEvents() {
        this.sendStepBegins(this.sourceId, this.step);
        this.sendGraphAttributeChanged(this.sourceId, "urls.parsed", null, this.urls.size());
        this.sendGraphAttributeChanged(this.sourceId, "urls.remaining", null, this.stepUrls.size());
        if (this.printProgress) {
            this.progress();
        }
        this.stepUrls.forEach(url -> {
            try {
                this.addNodeURL((String)url);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        });
        this.urls.addAll(this.stepUrls);
        this.newUrls.clear();
        if (this.threads > 1) {
            this.nextEventsThreaded();
        } else {
            this.stepUrls.forEach(url -> {
                try {
                    this.parseUrl((String)url);
                }
                catch (IOException e) {
                    System.err.printf("Failed to parse \"%s\" : %s\n", url, e.getMessage());
                }
            });
        }
        this.stepUrls.clear();
        this.stepUrls.addAll(this.newUrls);
        this.step += 1.0;
        return this.newUrls.size() > 0;
    }

    public void addURL(String url) {
        this.stepUrls.add(url);
    }

    public void setDirected(boolean on) {
        this.setDirectedEdges(on, false);
    }

    public void setNodeWeightAttribute(String attribute) {
        this.nodeWeight = attribute;
    }

    public void setEdgeWeightAttribute(String attribute) {
        this.edgeWeight = attribute;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setThreadCount(int count) {
        this.threads = count;
    }

    public void setDepthLimit(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    public void enableProgression(boolean on) {
        this.printProgress = on;
    }

    public void acceptOnlyMatchingURL(final String regex) {
        URLFilter f = new URLFilter(){

            @Override
            public boolean accept(String url) {
                return url.matches(regex);
            }
        };
        this.filters.add(f);
    }

    public void declineMatchingURL(final String regex) {
        URLFilter f = new URLFilter(){

            @Override
            public boolean accept(String url) {
                return !url.matches(regex);
            }
        };
        this.filters.add(f);
    }

    public void addHostFilter(String ... hosts) {
        if (hosts != null) {
            StringBuilder b = new StringBuilder("^(\\w+:)?(//)?([\\w-\\d]+[.])?(");
            b.append(hosts[0]);
            for (int i = 1; i < hosts.length; ++i) {
                b.append("|").append(hosts[i]);
            }
            b.append(").*");
            this.acceptOnlyMatchingURL(b.toString());
        }
    }

    protected void nextEventsThreaded() {
        int i;
        int t = Math.min(this.threads, this.stepUrls.size());
        int byThreads = this.stepUrls.size() / t;
        LinkedList<Worker> workers = new LinkedList<Worker>();
        LinkedList<Thread> workersThreads = new LinkedList<Thread>();
        for (i = 0; i < t; ++i) {
            int start = i * byThreads;
            int stop = (i + 1) * byThreads;
            if (i == t - 1) {
                stop += this.stepUrls.size() % t;
            }
            Worker w = new Worker(start, stop, this.stepUrls);
            Thread u = new Thread(w);
            u.start();
            workers.add(w);
            workersThreads.add(u);
        }
        for (i = 0; i < t; ++i) {
            try {
                ((Thread)workersThreads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isValid(String url) {
        for (int i = 0; i < this.filters.size(); ++i) {
            if (this.filters.get(i).accept(url)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseUrl(String url) throws IOException {
        URI uri;
        HashSet<String> localUrls = new HashSet<String>();
        if (!this.isValid(url)) {
            return;
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e1) {
            throw new IOException(e1);
        }
        if (uri.getHost() == null) {
            System.err.printf("skip invalid uri : '%s'\n", url);
            return;
        }
        if (!uri.isAbsolute()) {
            System.err.printf("skip non-absolute uri : '%s'\n", url);
            return;
        }
        URLConnection conn = uri.toURL().openConnection();
        conn.setConnectTimeout(1000);
        conn.setReadTimeout(1000);
        conn.connect();
        if (conn.getContentType() == null || !conn.getContentType().startsWith("text/html")) {
            return;
        }
        InputStream stream = conn.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while (reader.ready()) {
            String line = reader.readLine();
            if (line == null) continue;
            Matcher m = this.hrefPattern.matcher(line);
            while (m.find()) {
                String href = m.group(1);
                if (href == null || href.length() == 0) continue;
                if ((href = href.trim()).charAt(0) == '/') {
                    href = String.format("%s://%s%s", uri.getScheme(), uri.getHost(), href);
                }
                if (href.charAt(0) == '.') {
                    href = String.format("%s%s", url, href);
                }
                if (!this.isValid(href)) continue;
                try {
                    if (this.depthLimit == 0 || this.step < (double)this.depthLimit) {
                        this.synchronizedOperation(href, null);
                        this.synchronizedOperation(url, href);
                    } else if (this.urls.contains(href)) {
                        this.synchronizedOperation(url, href);
                    }
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                if (this.urls.contains(href) || this.depthLimit != 0 && !(this.step < (double)this.depthLimit)) continue;
                localUrls.add(href);
            }
        }
        this.lock.lock();
        try {
            this.newUrls.addAll(localUrls);
        }
        finally {
            this.lock.unlock();
        }
        localUrls.clear();
        localUrls = null;
        try {
            if (conn.getDoOutput()) {
                conn.getOutputStream().close();
            }
            reader.close();
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    protected String getNodeId(String url) throws URISyntaxException {
        String nodeId = url;
        URI uri = new URI(url);
        switch (this.mode) {
            case HOST: {
                nodeId = String.format("%s://%s", uri.getScheme(), uri.getHost());
                break;
            }
            case PATH: {
                nodeId = String.format("%s://%s%s", uri.getScheme(), uri.getHost(), uri.getPath());
                break;
            }
            case FULL: {
                nodeId = String.format("%s://%s%s%s", uri.getScheme(), uri.getHost(), uri.getPath(), uri.getQuery() == null ? "" : uri.getQuery());
            }
        }
        return nodeId;
    }

    protected String getNodeLabel(String url) throws URISyntaxException {
        return url;
    }

    protected String getEdgeId(String nodeId1, String nodeId2) {
        if (this.directed || nodeId1.compareTo(nodeId2) < 0) {
            return String.format("%s > %s", nodeId1, nodeId2);
        }
        return String.format("%s > %s", nodeId2, nodeId1);
    }

    protected synchronized void synchronizedOperation(String url1, String url2) throws URISyntaxException {
        if (url2 == null) {
            this.addNodeURL(url1);
        } else {
            this.connect(url1, url2);
        }
    }

    protected void addNodeURL(String url) throws URISyntaxException {
        Node n;
        String nodeId = this.getNodeId(url);
        if (this.internalGraph.getNode(nodeId) == null) {
            this.addNode(nodeId);
            this.sendNodeAttributeAdded(this.sourceId, nodeId, "label", this.getNodeLabel(url));
        }
        double w = (n = this.internalGraph.getNode(nodeId)).hasNumber(this.nodeWeight) ? n.getNumber(this.nodeWeight) : 0.0;
        n.setAttribute(this.nodeWeight, new Object[]{w + 1.0});
        this.sendNodeAttributeChanged(this.sourceId, nodeId, this.nodeWeight, null, w + 1.0);
    }

    protected void connect(String url1, String url2) throws URISyntaxException {
        String src = this.getNodeId(url1);
        String trg = this.getNodeId(url2);
        if (this.internalGraph.getNode(src) == null) {
            this.addNode(src);
        }
        if (this.internalGraph.getNode(trg) == null) {
            this.addNode(trg);
        }
        if (!src.equals(trg)) {
            Edge e;
            String eid = this.getEdgeId(src, trg);
            if (this.internalGraph.getEdge(eid) == null) {
                this.addEdge(eid, src, trg);
            }
            double w = (e = this.internalGraph.getEdge(eid)).hasNumber(this.edgeWeight) ? e.getNumber(this.edgeWeight) : 0.0;
            e.setAttribute(this.edgeWeight, new Object[]{w + 1.0});
            this.sendEdgeAttributeChanged(this.sourceId, eid, this.edgeWeight, null, w + 1.0);
        }
    }

    protected void progress() {
        System.out.printf("\u001b[s\u001b[K%d urls parsed, %d remaining\u001b[u", this.urls.size(), this.stepUrls.size());
    }

    public static enum Mode {
        HOST,
        PATH,
        FULL;

    }

    private class Worker
    implements Runnable {
        int start;
        int stop;
        LinkedList<String> urls;

        public Worker(int start, int stop, LinkedList<String> urls) {
            this.start = start;
            this.stop = stop;
            this.urls = urls;
        }

        @Override
        public void run() {
            for (int i = this.start; i < this.stop; ++i) {
                try {
                    URLGenerator.this.parseUrl(this.urls.get(i));
                    continue;
                }
                catch (IOException e) {
                    System.err.printf("Failed to parse \"%s\" : %s\n", this.urls.get(i), e.getMessage());
                }
            }
        }
    }

    public static interface URLFilter {
        public boolean accept(String var1);
    }
}

