/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jdesktop.http.SecurityHandler;

class MediumSecurityX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Logger LOG = Logger.getLogger(MediumSecurityX509TrustManager.class.getName());
    private SecurityHandler handler;
    private String host;

    public MediumSecurityX509TrustManager(String host, SecurityHandler handler, KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        this.host = host;
        this.handler = handler;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && certificates.length == 1 && this.handler != null) {
            certificates[0].checkValidity();
            if (!this.handler.isServerTrusted(this.host, certificates[0])) {
                throw new CertificateException("Self signed certificate from " + certificates[0].getIssuerX500Principal().toString() + " is not trusted");
            }
        } else {
            this.standardTrustManager.checkServerTrusted(certificates, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

