/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.graphstream.graph.Graph;
import org.graphstream.stream.file.FileSinkBase;

public class FileSinkGraphML
extends FileSinkBase {
    @Override
    protected void outputEndOfFile() throws IOException {
        this.print("</graphml>\n", new Object[0]);
    }

    @Override
    protected void outputHeader() throws IOException {
        this.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", new Object[0]);
        this.print("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n", new Object[0]);
        this.print("\t xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n", new Object[0]);
        this.print("\t xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n", new Object[0]);
        this.print("\t   http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n", new Object[0]);
    }

    private void print(String format, Object ... args) throws IOException {
        this.output.write(String.format(format, args));
    }

    @Override
    protected void exportGraph(Graph g) {
        Consumer<Exception> onException = Throwable::printStackTrace;
        AtomicInteger attribute = new AtomicInteger(0);
        HashMap nodeAttributes = new HashMap();
        HashMap edgeAttributes = new HashMap();
        g.nodes().forEach(n -> n.attributeKeys().forEach(k -> {
            if (!nodeAttributes.containsKey(k)) {
                Object value = n.getAttribute((String)k);
                if (value == null) {
                    return;
                }
                String id = String.format("attr%04X", attribute.getAndIncrement());
                String type = value instanceof Boolean ? "boolean" : (value instanceof Long ? "long" : (value instanceof Integer ? "int" : (value instanceof Double ? "double" : (value instanceof Float ? "float" : "string"))));
                nodeAttributes.put(k, id);
                try {
                    this.print("\t<key id=\"%s\" for=\"node\" attr.name=\"%s\" attr.type=\"%s\"/>\n", id, FileSinkGraphML.escapeXmlString(k), type);
                }
                catch (Exception ex) {
                    onException.accept(ex);
                }
            }
        }));
        g.edges().forEach(n -> n.attributeKeys().forEach(k -> {
            if (!edgeAttributes.containsKey(k)) {
                Object value = n.getAttribute((String)k);
                if (value == null) {
                    return;
                }
                String id = String.format("attr%04X", attribute.getAndIncrement());
                String type = value instanceof Boolean ? "boolean" : (value instanceof Long ? "long" : (value instanceof Integer ? "int" : (value instanceof Double ? "double" : (value instanceof Float ? "float" : "string"))));
                edgeAttributes.put(k, id);
                try {
                    this.print("\t<key id=\"%s\" for=\"edge\" attr.name=\"%s\" attr.type=\"%s\"/>\n", id, FileSinkGraphML.escapeXmlString(k), type);
                }
                catch (Exception ex) {
                    onException.accept(ex);
                }
            }
        }));
        try {
            this.print("\t<graph id=\"%s\" edgedefault=\"undirected\">\n", FileSinkGraphML.escapeXmlString(g.getId()));
        }
        catch (Exception e2) {
            onException.accept(e2);
        }
        g.nodes().forEach(n -> {
            try {
                this.print("\t\t<node id=\"%s\">\n", n.getId());
                n.attributeKeys().forEach(k -> {
                    try {
                        this.print("\t\t\t<data key=\"%s\">%s</data>\n", nodeAttributes.get(k), FileSinkGraphML.escapeXmlString(n.getAttribute((String)k).toString()));
                    }
                    catch (IOException e) {
                        onException.accept(e);
                    }
                });
                this.print("\t\t</node>\n", new Object[0]);
            }
            catch (Exception ex) {
                onException.accept(ex);
            }
        });
        g.edges().forEach(e -> {
            try {
                this.print("\t\t<edge id=\"%s\" source=\"%s\" target=\"%s\" directed=\"%s\">\n", e.getId(), e.getSourceNode().getId(), e.getTargetNode().getId(), e.isDirected());
                e.attributeKeys().forEach(k -> {
                    try {
                        this.print("\t\t\t<data key=\"%s\">%s</data>\n", edgeAttributes.get(k), FileSinkGraphML.escapeXmlString(e.getAttribute((String)k).toString()));
                    }
                    catch (IOException e1) {
                        onException.accept(e1);
                    }
                });
                this.print("\t\t</edge>\n", new Object[0]);
            }
            catch (Exception ex) {
                onException.accept(ex);
            }
        });
        try {
            this.print("\t</graph>\n", new Object[0]);
        }
        catch (Exception e3) {
            onException.accept(e3);
        }
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        throw new UnsupportedOperationException();
    }

    private static String escapeXmlString(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }
}

