/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.searchdupes.DuplicatesFinder;
import ancestris.modules.gedcom.searchdupes.DuplicatesResults;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.PotentialMatch;
import genj.common.SelectEntityWidget;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;

public class MergeAction
extends AbstractAncestrisContextAction {
    private Entity entity;
    private SelectEntityWidget selectEntityWidget = null;

    public MergeAction() {
        this.setIconBase("ancestris/modules/gedcom/searchdupes/mergeAction.png");
        this.setText(NbBundle.getMessage(MergeAction.class, (String)"CTL_MergeAction"));
        this.setTip(NbBundle.getMessage(MergeAction.class, (String)"CTL_MergeAction.tip"));
    }

    protected final void contextChanged() {
        this.setEnabled(this.entity != null);
    }

    public void resultChanged(LookupEvent ev) {
        this.entity = null;
        Collection props = this.lkpInfo.allInstances();
        if (!props.isEmpty()) {
            Property prop = (Property)props.iterator().next();
            this.entity = prop.getEntity();
        }
        super.resultChanged(ev);
    }

    protected void actionPerformedImpl(ActionEvent event) {
        if (this.entity == null || this.entity.getGedcom() == null) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        this.selectEntityWidget = new SelectEntityWidget(this.entity.getGedcom(), this.entity.getTag(), null, true);
        panel.add((Component)this.selectEntityWidget, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Object choice = DialogManager.create((String)NbBundle.getMessage(MergeAction.class, (String)"MergeAction.askOtherEntity"), (JComponent)panel).setMessageType(-1).setOptionType(2).setDialogId("MergeActionPanel").show();
        if (choice == DialogManager.OK_OPTION) {
            Entity otherEntity = this.selectEntityWidget.getSelection();
            if (this.entity == otherEntity) {
                return;
            }
            DuplicatesFinder finder = new DuplicatesFinder(this.entity);
            List<PotentialMatch<? extends Entity>> matchesLinkedList = finder.findMatches(50);
            EntityMatcher entityMatcher = finder.getMatcher(this.entity);
            int rank = -1;
            if (!matchesLinkedList.isEmpty()) {
                rank = finder.sortMatches(this.entity, otherEntity);
            }
            if (rank == -1) {
                int diff = entityMatcher.compare(this.entity, otherEntity);
                matchesLinkedList.add((PotentialMatch<? extends Entity>)new PotentialMatch((Object)this.entity, (Object)otherEntity, diff));
                rank = finder.sortMatches(this.entity, otherEntity);
            }
            DuplicatesResults results = new DuplicatesResults(this.entity.getGedcom(), matchesLinkedList, this.entity, false, rank);
            results.setParams(this.entity, finder.getMatcher(this.entity));
            results.show();
        }
    }
}

