/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.util.swing.FileChooserBuilder;
import genj.io.InputSource;
import genj.util.EnvironmentChecker;
import genj.util.swing.ButtonHelper;
import genj.util.swing.TextFieldWidget;
import genj.util.swing.ThumbnailWidget;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class FileChooserWidget
extends JPanel {
    private TextFieldWidget text = new TextFieldWidget("", 12);
    private Choose choose = new Choose();
    private String extensions;
    public static final String EXECUTABLES = "exe, bin, sh, cmd, bat";
    private String directory = EnvironmentChecker.getProperty("user.home", ".", "file chooser directory");
    private JComponent accessory;
    private List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private ActionListener actionProxy = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserWidget.this.fireActionEvent();
        }
    };
    private boolean open;

    public FileChooserWidget() {
        this((String)null);
        this.open = true;
    }

    public FileChooserWidget(boolean open) {
        this((String)null);
        this.open = open;
    }

    @Override
    public void setEnabled(boolean set) {
        super.setEnabled(set);
        this.choose.setEnabled(set);
        this.text.setEnabled(set);
    }

    public FileChooserWidget(String extensions) {
        super(new BorderLayout());
        this.add("Center", this.text);
        this.add("East", new ButtonHelper().setInsets(0).create(this.choose));
        this.extensions = extensions;
    }

    private void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 0, "");
        ActionListener[] ls = this.listeners.toArray(new ActionListener[this.listeners.size()]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].actionPerformed(e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.text.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.text.removeChangeListener(l);
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners.isEmpty()) {
            this.text.addActionListener(this.actionProxy);
        }
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.text.removeActionListener(this.actionProxy);
        }
    }

    public void setDirectory(String set) {
        this.directory = set;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public void setTemplate(boolean set) {
        this.text.setTemplate(set);
    }

    public void setFile(String file) {
        this.text.setText(file != null ? file : "");
    }

    public void setFile(File file) {
        this.text.setText(file != null ? file.getPath() : "");
        if (file != null && file.getParentFile() != null && file.getParentFile().isDirectory()) {
            this.setDirectory(file.getParentFile().toString());
        }
    }

    public String getFile() {
        File file = new File(this.text.getText().trim());
        String name = file.getName();
        if (file.exists()) {
            if (this.extensions != null && name.indexOf(".") < 0 && this.extensions.indexOf(44) < 0) {
                String ext = this.extensions.trim();
                if (name.length() > 0 && !name.endsWith("." + ext)) {
                    file = new File(file.getParentFile(), name + "." + ext);
                }
            }
            return file.getAbsolutePath();
        }
        return this.text.getText().trim();
    }

    public void setAccessory(JComponent set) {
        this.accessory = set;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.text.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        this.text.requestFocus();
    }

    private class Choose
    extends AbstractAncestrisAction
    implements PropertyChangeListener {
        private Choose() {
            this.setText("...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File file = null;
            FileChooserBuilder fcb = new FileChooserBuilder(FileChooserWidget.class).setDirectoriesOnly(false).setDefaultBadgeProvider().setAccessory(FileChooserWidget.this.accessory).setDefaultTitle().setApproveText(AbstractAncestrisAction.TXT_OK).setParent(FileChooserWidget.this).setDefaultWorkingDirectory(new File(FileChooserWidget.this.directory)).setDefaultPreviewer().setSelectedFile(new File(FileChooserWidget.this.getFile()));
            file = FileChooserWidget.this.open ? fcb.showOpenDialog() : fcb.showSaveDialog();
            if (file != null) {
                FileChooserWidget.this.setFile(file);
                FileChooserWidget.this.directory = file.getParent();
                FileChooserWidget.this.fireActionEvent();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
                File file = (File)evt.getNewValue();
                if (FileChooserWidget.this.accessory instanceof ThumbnailWidget) {
                    ((ThumbnailWidget)FileChooserWidget.this.accessory).setSource(file != null ? InputSource.get(file).get() : null);
                }
            }
        }
    }
}

