/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.exec;

import genj.gedcom.Gedcom;
import genj.report.Report;
import genj.util.EnvironmentChecker;
import java.io.BufferedReader;
import java.io.IOException;
import org.openide.util.NbBundle;

public class ReportExec
extends Report {
    private static final String SEP = " => ";
    private static final String[] ENVS = new String[]{"?", "Windows", "macOS", "Linux"};
    private static final int ENVIRONMENT = ReportExec.getEnv();
    private static final String INSTRUCTIONS = NbBundle.getMessage(ReportExec.class, (String)"instructions", (Object)ENVS[ENVIRONMENT]);
    private String linecommand = "";
    private int example = 0;
    private static final String[][] COMMAND_TABLE = new String[][]{{"", "browse", "opentxteditor", "opentextdoc", "opencalcldoc", "opencalculator", "openemailclient", "scandoc", "openpdf", "openimage", "openvideo", "openterminal", "openyed", "other"}, {"", "start 'https://www.ancestris.org'", "C:\\Windows\\System32\\notepad.exe", "start letter.docx", "start estimation.xlsx", "calc", "C:\\Program Files\\Microsoft Office\\root\\Office16\\OUTLOOK.EXE", "C:\\Program Files\\Windows Defender", "xpdf file.pdf", "start C:\\ImageFolder\\Image.jgp", "start Video.mov", "cmd", "yEd", "..."}, {"", "open https://www.ancestris.org", "nano ~/Documents/file.txt", "touch newDocument.doc ; open newDocument.docx", "open newSheet.xlsx", "open -n /System/Applications/Calculator.app", "open -n /System/Applications/Mail.app", "open -n '/System/Applications/Image Capture.app", "open ~/tmp/birth-certificate.pdf", "open ~/tmp/media.png", "open ~/tmp/movie.mp4", "open -n /System/Applications/Utilities/Terminal.app", "open -n /Applications/YEd.app", "..."}, {"", "xdg-open https://www.ancestris.org", "gedit file.txt", "libreoffice --writer", "libreoffice --calc", "gnome-calculator", "xdg-email", "simple-scan", "xdg-open ~/tmp/birth-certificate.pdf", "xdg-open ~/tmp/media.png", "xdg-open ~/tmp/movie.mp4", "gnome-terminal", "yEd", "..."}};

    public String getLinecommand() {
        return this.linecommand;
    }

    public void setLinecommand(String set) {
        this.linecommand = set;
    }

    public String[] getExamples() {
        int l = COMMAND_TABLE[ENVIRONMENT].length;
        String[] cmds = new String[l];
        cmds[0] = INSTRUCTIONS;
        for (int i = 1; i < l; ++i) {
            cmds[i] = NbBundle.getMessage(ReportExec.class, (String)COMMAND_TABLE[0][i]) + SEP + COMMAND_TABLE[ENVIRONMENT][i];
        }
        return cmds;
    }

    public int getExample() {
        return this.example;
    }

    public void setExample(int set) {
        this.example = set;
        String tmpStr = this.getExamples()[this.example];
        int index = tmpStr.indexOf(SEP);
        index = index == -1 ? 0 : (index += SEP.length());
        this.linecommand = tmpStr.substring(index);
    }

    private static int getEnv() {
        int env = 0;
        if (EnvironmentChecker.isWindows()) {
            env = 1;
        } else if (EnvironmentChecker.isMac()) {
            env = 2;
        } else if (EnvironmentChecker.isLinux()) {
            env = 3;
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Gedcom gedcom) {
        if (this.linecommand == null || this.linecommand.length() == 0) {
            return;
        }
        BufferedReader in = null;
        try {
            String[] cmdarg = new String[]{this.linecommand};
            this.println(this.translate("Launched", new Object[]{this.linecommand}));
            Process process = Runtime.getRuntime().exec(cmdarg);
        }
        catch (IOException ioe) {
            this.println(this.translate("Error", new Object[]{ioe.getMessage()}));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

