/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.linesascent;

import ancestris.reports.FormatIDOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.SimpleColorsOptions;
import genj.fo.Document;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class ReportLinesAscent
extends Report {
    public FormattingOptions formattingOptions = new FormattingOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public boolean reportSibling = true;
    public FormatIDOptions dataFormatOptions = new FormatIDOptions();
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private Document doc;
    private Map<Integer, Record> genMap;
    private static final int PATRIMONIAL_TYPE = 0;
    private static final int MATRIMONIAL_TYPE = 1;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public Document start(Indi person) {
        this.genMap = new TreeMap(Comparator.reverseOrder());
        Indi indi = person;
        int iGen = 0;
        this.genMap.put(iGen, new Record(iGen, indi, 0));
        iGen = 1;
        while ((indi = indi.getBiologicalFather()) != null) {
            this.genMap.put(iGen, new Record(iGen, indi, 0));
            ++iGen;
        }
        indi = person;
        iGen = 1;
        while ((indi = indi.getBiologicalMother()) != null) {
            Record record = this.genMap.get(iGen);
            if (record == null) {
                record = new Record(iGen, indi, 1);
                this.genMap.put(iGen, record);
            } else {
                record.set(indi, 1);
            }
            ++iGen;
        }
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String backColor = this.colors.getBackgroundColor();
        int cellHeight = this.formattingOptions.getTextSize() * 2;
        String cellAttr = "text-align=center, height=" + cellHeight + "px, display-align=center";
        int nbColumns = this.reportSibling ? 6 : 4;
        String title = this.translate("title", new Object[]{this.genMap.size() - 1});
        this.doc = this.formattingOptions.createDocument(this.translate("name"), textColor, backColor);
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        this.doc.startTable("genj:csv=true, width=100%, border=0, space-before=1cm");
        this.doc.addTableColumn("column-width=3%");
        this.doc.addTableColumn("column-width=37%");
        if (this.reportSibling) {
            this.doc.addTableColumn("column-width=10%");
        }
        this.doc.addTableColumn("column-width=3%");
        this.doc.addTableColumn("column-width=37%");
        if (this.reportSibling) {
            this.doc.addTableColumn("column-width=10%");
        }
        this.doc.nextTableRow("font-size=" + (this.formattingOptions.getTextSize() + 2) + ", text-align=center, font-weight=bold, background-color=" + header_row);
        this.doc.nextTableCell();
        this.doc.addText("#");
        this.doc.nextTableCell();
        this.doc.addText(this.translate("paternalline"));
        if (this.reportSibling) {
            this.doc.nextTableCell();
            this.doc.addText(this.translate("sibling"));
        }
        this.doc.nextTableCell();
        this.doc.addText("#");
        this.doc.nextTableCell();
        this.doc.addText(this.translate("maternalline"));
        if (this.reportSibling) {
            this.doc.nextTableCell();
            this.doc.addText(this.translate("sibling"));
        }
        this.doc.nextTableRow();
        this.doc.nextTableCell("number-columns-spanned=" + nbColumns + ", " + cellAttr);
        this.doc.addText("\u00a0");
        for (Integer gen : this.genMap.keySet()) {
            Indi tmpIndi;
            String bgColor;
            Record record = this.genMap.get(gen);
            String string = bgColor = gen % 2 == 0 ? odd_row : even_row;
            if (gen > 0) {
                this.doc.nextTableRow("background-color=" + bgColor);
                tmpIndi = record.indi[0];
                if (tmpIndi != null) {
                    this.doc.nextTableCell(cellAttr);
                    this.doc.addText("" + record.generation);
                    this.displayIndi(tmpIndi, record.siblingRank[0], cellAttr);
                } else {
                    this.doc.nextTableCell(cellAttr);
                    this.doc.addText("\u00a0");
                    this.doc.nextTableCell(cellAttr);
                    this.doc.addText("\u00a0");
                    if (this.reportSibling) {
                        this.doc.nextTableCell(cellAttr);
                        this.doc.addText("\u00a0");
                    }
                }
                tmpIndi = record.indi[1];
                if (tmpIndi != null) {
                    this.doc.nextTableCell(cellAttr);
                    this.doc.addText("" + record.generation);
                    this.displayIndi(tmpIndi, record.siblingRank[1], cellAttr);
                    continue;
                }
                this.doc.nextTableCell(cellAttr);
                this.doc.addText("\u00a0");
                this.doc.nextTableCell(cellAttr);
                this.doc.addText("\u00a0");
                if (!this.reportSibling) continue;
                this.doc.nextTableCell(cellAttr);
                this.doc.addText("\u00a0");
                continue;
            }
            this.doc.nextTableRow("background-color=" + bgColor + ", text-align=center");
            tmpIndi = record.indi[0];
            if (tmpIndi == null) continue;
            this.doc.nextTableCell("font-weight=bold, number-columns-spanned=" + nbColumns + ", " + cellAttr);
            this.doc.addText(" " + tmpIndi.getDisplayTitle(false) + " ");
            String id = this.dataFormatOptions.getId(tmpIndi);
            if (!id.isBlank()) {
                this.doc.addLink(id, tmpIndi.getLinkAnchor());
            }
            if (!this.reportSibling) continue;
            this.doc.addText(" " + record.siblingRank[0]);
        }
        this.doc.endTable();
        return this.doc;
    }

    private void displayIndi(Indi tmpIndi, String rank, String attr) {
        this.doc.nextTableCell(attr);
        this.doc.addText(" " + tmpIndi.getDisplayTitle(false) + " ");
        String id = this.dataFormatOptions.getId(tmpIndi);
        if (!id.isBlank()) {
            this.doc.addLink(id, tmpIndi.getLinkAnchor());
        }
        if (this.reportSibling) {
            this.doc.nextTableCell(attr + ", text-align=center");
            this.doc.addText(rank);
        }
    }

    private String getSiblinkRank(Indi indi) {
        return indi.getOlderSiblings().length + 1 + "/" + Math.max(1, indi.getSiblings(true).length);
    }

    private class Record {
        int generation;
        private Indi[] indi = new Indi[2];
        String[] siblingRank = new String[2];

        public Record(int generation, Indi indi, int type) {
            this.generation = generation;
            this.indi[type] = indi;
            this.siblingRank[type] = ReportLinesAscent.this.getSiblinkRank(indi);
        }

        public void set(Indi indi, int type) {
            this.indi[type] = indi;
            this.siblingRank[type] = ReportLinesAscent.this.getSiblinkRank(indi);
        }
    }
}

