/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.viewer.bmng;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactoryInfo;

public class CylindricalProjectionTileFactory
extends DefaultTileFactory {
    public CylindricalProjectionTileFactory(TileFactoryInfo info) {
        super(info);
    }

    @Override
    public Point2D geoToPixel(GeoPosition c, int zoom) {
        Dimension mapSizeInTiles = this.getMapSize(zoom);
        double size_in_pixels = mapSizeInTiles.getWidth() * (double)this.getInfo().getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = (double)this.getTileSize(zoom) * mapSizeInTiles.getWidth() / 2.0;
        double centerY = (double)this.getTileSize(zoom) * mapSizeInTiles.getHeight() / 2.0;
        double x = c.getLongitude() * ppd + centerX;
        double y = -c.getLatitude() * ppd + centerY;
        return new Point2D.Double(x, y);
    }

    @Override
    public GeoPosition pixelToGeo(Point2D pix, int zoom) {
        Dimension mapSizeInTiles = this.getMapSize(zoom);
        double size_in_pixels = mapSizeInTiles.getWidth() * (double)this.getInfo().getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = (double)this.getTileSize(zoom) * mapSizeInTiles.getWidth() / 2.0;
        double centerY = (double)this.getTileSize(zoom) * mapSizeInTiles.getHeight() / 2.0;
        double lon = (pix.getX() - centerX) / ppd;
        double lat = -(pix.getY() - centerY) / ppd;
        return new GeoPosition(lat, lon);
    }
}

