/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;
import org.oxbow.swingbits.table.filter.IFilterChangeListener;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.table.filter.TableFilterState;
import org.oxbow.swingbits.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableFilter<T extends JTable>
implements ITableFilter<T> {
    private final Set<IFilterChangeListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Map<Integer, Collection<DistinctColumnItem>> distinctItemCache = Collections.synchronizedMap(new HashMap());
    private final T table;
    private final TableFilterState filterState = new TableFilterState();

    public AbstractTableFilter(T t) {
        this.table = t;
        this.setupDistinctItemCacheRefresh();
    }

    private void setupDistinctItemCacheRefresh() {
        this.clearDistinctItemCache();
        ((Container)this.table).addPropertyChangeListener("model", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractTableFilter.this.clearDistinctItemCache();
                TableModel tableModel = (TableModel)propertyChangeEvent.getNewValue();
                if (tableModel != null) {
                    tableModel.addTableModelListener(new TableModelListener(){

                        public void tableChanged(TableModelEvent tableModelEvent) {
                            AbstractTableFilter.this.clearDistinctItemCache();
                        }
                    });
                }
            }
        });
    }

    private void clearDistinctItemCache() {
        this.distinctItemCache.clear();
    }

    @Override
    public T getTable() {
        return this.table;
    }

    protected abstract boolean execute(int var1, Collection<DistinctColumnItem> var2);

    @Override
    public boolean apply(int n, Collection<DistinctColumnItem> collection) {
        this.setFilterState(n, collection);
        boolean bl = false;
        bl = this.execute(n, collection);
        if (bl) {
            this.fireFilterChange();
        }
        return bl;
    }

    @Override
    public final void addChangeListener(IFilterChangeListener iFilterChangeListener) {
        if (iFilterChangeListener != null) {
            this.listeners.add(iFilterChangeListener);
        }
    }

    @Override
    public final void removeChnageListener(IFilterChangeListener iFilterChangeListener) {
        if (iFilterChangeListener != null) {
            this.listeners.remove(iFilterChangeListener);
        }
    }

    public final void fireFilterChange() {
        for (IFilterChangeListener iFilterChangeListener : this.listeners) {
            iFilterChangeListener.filterChanged(this);
        }
    }

    @Override
    public Collection<DistinctColumnItem> getDistinctColumnItems(int n) {
        Collection<DistinctColumnItem> collection = this.distinctItemCache.get(n);
        if (collection == null) {
            collection = this.collectDistinctColumnItems(n);
            this.distinctItemCache.put(n, collection);
        }
        return collection;
    }

    private Collection<DistinctColumnItem> collectDistinctColumnItems(int n) {
        HashSet<DistinctColumnItem> hashSet = new HashSet<DistinctColumnItem>();
        int n2 = -1;
        for (int i = 0; i < ((JTable)this.table).getModel().getRowCount(); ++i) {
            Object object = ((JTable)this.table).getModel().getValueAt(i, n);
            if (object == null) {
                n2 = i;
                continue;
            }
            hashSet.add(new DistinctColumnItem(object, i));
        }
        ArrayList<DistinctColumnItem> arrayList = new ArrayList<DistinctColumnItem>(hashSet);
        if (n2 >= 0) {
            arrayList.add(0, new DistinctColumnItem(null, n2));
        }
        return CollectionUtils.trySort(arrayList);
    }

    @Override
    public Collection<DistinctColumnItem> getFilterState(int n) {
        return this.filterState.getValues(n);
    }

    @Override
    public boolean isFiltered(int n) {
        Collection<DistinctColumnItem> collection = this.getFilterState(n);
        return !CollectionUtils.isEmpty(collection) && this.getDistinctColumnItems(n).size() != collection.size();
    }

    @Override
    public boolean includeRow(ITableFilter.Row row) {
        return this.filterState.include(row);
    }

    public void setFilterState(int n, Collection<DistinctColumnItem> collection) {
        this.filterState.setValues(n, collection);
    }

    @Override
    public void clear() {
        this.filterState.clear();
        List<DistinctColumnItem> list = Collections.emptyList();
        for (int i = 0; i < ((JTable)this.table).getModel().getColumnCount(); ++i) {
            this.execute(i, list);
        }
        this.fireFilterChange();
    }
}

