/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util.copy;

import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    protected byte[] buf = null;
    protected int count = 0;
    protected int pos = 0;

    public FastByteArrayInputStream(byte[] byArray, int n) {
        this.buf = byArray;
        this.count = n;
    }

    public final int available() {
        return this.count - this.pos;
    }

    public final int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public final int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public final long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }
}

