/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.panels;

import ancestris.modules.beans.ADateBean;
import ancestris.modules.editors.aries.panels.AssociationsTablePanel;
import ancestris.modules.editors.aries.utilities.PropertyTag2Name;
import ancestris.modules.editors.geoplace.PlaceEditorPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceSourceEvent;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.util.swing.ChoiceWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RecordedEventEditorPanel
extends JPanel {
    private Property mEvent = null;
    private PropertyPlace mPlace = null;
    private PropertyDate mDate = null;
    private final ArrayList<String> mEvents = new ArrayList<String>(){
        {
            this.add(PropertyTag2Name.getTagName("BIRT"));
            this.add(PropertyTag2Name.getTagName("CHR"));
            this.add(PropertyTag2Name.getTagName("DEAT"));
            this.add(PropertyTag2Name.getTagName("BURI"));
            this.add(PropertyTag2Name.getTagName("CREM"));
            this.add(PropertyTag2Name.getTagName("ADOP"));
            this.add(PropertyTag2Name.getTagName("BAPM"));
            this.add(PropertyTag2Name.getTagName("BARM"));
            this.add(PropertyTag2Name.getTagName("BASM"));
            this.add(PropertyTag2Name.getTagName("BLES"));
            this.add(PropertyTag2Name.getTagName("CHRA"));
            this.add(PropertyTag2Name.getTagName("CONF"));
            this.add(PropertyTag2Name.getTagName("FCOM"));
            this.add(PropertyTag2Name.getTagName("ORDN"));
            this.add(PropertyTag2Name.getTagName("NATU"));
            this.add(PropertyTag2Name.getTagName("EMIG"));
            this.add(PropertyTag2Name.getTagName("IMMI"));
            this.add(PropertyTag2Name.getTagName("CENS"));
            this.add(PropertyTag2Name.getTagName("PROB"));
            this.add(PropertyTag2Name.getTagName("WILL"));
            this.add(PropertyTag2Name.getTagName("GRAD"));
            this.add(PropertyTag2Name.getTagName("RETI"));
            this.add(PropertyTag2Name.getTagName("ANUL"));
            this.add(PropertyTag2Name.getTagName("DIV"));
            this.add(PropertyTag2Name.getTagName("DIVF"));
            this.add(PropertyTag2Name.getTagName("MARR"));
            this.add(PropertyTag2Name.getTagName("ENGA"));
            this.add(PropertyTag2Name.getTagName("MARB"));
            this.add(PropertyTag2Name.getTagName("MARC"));
            this.add(PropertyTag2Name.getTagName("MARL"));
            this.add(PropertyTag2Name.getTagName("MARS"));
        }
    };
    private final DefaultListModel<CheckableItem> mEventsModel = new DefaultListModel();
    private final ChangeSupport changeSupport = new ChangeSupport(AssociationsTablePanel.class);
    private ADateBean aDateBean;
    private JLabel dateLabel;
    private JButton editPlaceButton;
    private ChoiceWidget placeChoiceWidget;
    private JLabel placeLabel;
    private JLabel recordedEventsLabel;
    private JList<CheckableItem> recordedEventsList;
    private JScrollPane recordedEventsScrollPane;

    public RecordedEventEditorPanel() {
        this.initComponents();
        this.aDateBean.setPreferHorizontal(true);
        Collections.sort(this.mEvents);
        for (String event : this.mEvents) {
            this.mEventsModel.addElement(new CheckableItem(event));
        }
        this.recordedEventsList.setVisibleRowCount(-1);
        this.recordedEventsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckableItem item;
                int index = RecordedEventEditorPanel.this.recordedEventsList.getSelectedIndex();
                item.setSelected(!(item = RecordedEventEditorPanel.this.recordedEventsList.getModel().getElementAt(index)).isSelected());
            }
        });
    }

    private void initComponents() {
        this.recordedEventsLabel = new JLabel();
        this.dateLabel = new JLabel();
        this.aDateBean = new ADateBean();
        this.placeLabel = new JLabel();
        this.placeChoiceWidget = new ChoiceWidget();
        this.editPlaceButton = new JButton();
        this.recordedEventsScrollPane = new JScrollPane();
        this.recordedEventsList = new JList();
        this.recordedEventsLabel.setHorizontalAlignment(0);
        this.recordedEventsLabel.setText(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.recordedEventsLabel.text"));
        this.dateLabel.setHorizontalAlignment(4);
        this.dateLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/panels/Bundle").getString("RecordedEventEditorPanel.dateLabel.text"), new Object[0]));
        this.placeLabel.setHorizontalAlignment(4);
        this.placeLabel.setText(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.placeLabel.text"));
        this.placeChoiceWidget.setMaximumRowCount(19);
        this.placeChoiceWidget.setMinimumSize(new Dimension(7, 20));
        this.placeChoiceWidget.setPrototypeDisplayValue((Object)"MMMMMMMMMMMMMMMMMMMMMM");
        this.placeChoiceWidget.setIgnoreCase(true);
        this.editPlaceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/place.png")));
        this.editPlaceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/panels/Bundle").getString("RecordedEventEditorPanel.editPlaceButton.toolTipText"), new Object[0]));
        this.editPlaceButton.setHorizontalTextPosition(0);
        this.editPlaceButton.setMaximumSize(new Dimension(26, 26));
        this.editPlaceButton.setMinimumSize(new Dimension(26, 26));
        this.editPlaceButton.setPreferredSize(new Dimension(26, 26));
        this.editPlaceButton.setVerticalTextPosition(3);
        this.editPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RecordedEventEditorPanel.this.editPlaceButtonActionPerformed(evt);
            }
        });
        this.recordedEventsScrollPane.setMinimumSize(new Dimension(526, 104));
        this.recordedEventsScrollPane.setPreferredSize(new Dimension(526, 104));
        this.recordedEventsList.setModel(this.mEventsModel);
        this.recordedEventsList.setCellRenderer(new CheckListRenderer());
        this.recordedEventsList.setSelectionMode(0);
        this.recordedEventsList.setLayoutOrientation(2);
        this.recordedEventsScrollPane.setViewportView(this.recordedEventsList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.recordedEventsScrollPane, -1, 656, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.placeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.dateLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.aDateBean, -1, 483, Short.MAX_VALUE).addGap(143, 143, 143)).addGroup(layout.createSequentialGroup().addComponent((Component)this.placeChoiceWidget, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editPlaceButton, -2, -1, -2)))).addComponent(this.recordedEventsLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.recordedEventsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recordedEventsScrollPane, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.aDateBean, -2, -1, -2).addComponent(this.dateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.editPlaceButton, -2, -1, -2).addComponent(this.placeLabel, -2, 15, -2).addComponent((Component)this.placeChoiceWidget, -2, -1, -2)).addContainerGap()));
    }

    private void editPlaceButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mEvent.getGedcom();
        int undoNb = gedcom.getUndoNb();
        PlaceEditorPanel placeEditorPanel = new PlaceEditorPanel();
        JButton OKButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Ok"));
        JButton cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Cancel"));
        Object[] options = new Object[]{OKButton, cancelButton};
        placeEditorPanel.setOKButton(OKButton);
        placeEditorPanel.set(gedcom, this.mPlace, false);
        DialogManager.ADialog eventEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(this.getClass(), (String)"PlaceEditorPanel.edit.title"), (JComponent)placeEditorPanel);
        eventEditorDialog.setDialogId(PlaceEditorPanel.class.getName());
        eventEditorDialog.setOptions(options);
        Object o = eventEditorDialog.show();
        placeEditorPanel.close();
        if (o == OKButton) {
            try {
                gedcom.doUnitOfWork(gedcom1 -> placeEditorPanel.commit(this.mEvent, this.mPlace));
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.mPlace = (PropertyPlace)this.mEvent.getProperty("PLAC", false);
            this.placeChoiceWidget.setText(this.mPlace != null ? this.mPlace.getDisplayValue() : "");
        } else {
            while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
        }
    }

    public void set(Property event) {
        String[] tags;
        Property property;
        this.mEvent = event;
        if (event.isGrammar7() && (property = this.mEvent) instanceof PropertyChoiceSourceEvent) {
            String[] pEvents = (String[])property;
            tags = pEvents.getPhraseDisplayValue().replaceAll(" ", "").split(",");
        } else {
            tags = this.mEvent.getValue().replaceAll(" ", "").split(",");
        }
        for (String eventTag : tags) {
            for (int index = 0; index < this.mEventsModel.size(); ++index) {
                if (!this.mEventsModel.get(index).toString().equals(PropertyTag2Name.getTagName(eventTag))) continue;
                this.mEventsModel.get(index).setSelected(true);
            }
        }
        Property p = this.mEvent.getProperty("DATE", false);
        this.mDate = (PropertyDate)(p instanceof PropertyDate ? p : null);
        if (this.mDate == null) {
            this.aDateBean.setContext(this.mEvent, null);
        } else {
            this.aDateBean.setContext((Property)this.mDate);
        }
        this.mPlace = (PropertyPlace)this.mEvent.getProperty("PLAC", false);
        if (this.mPlace == null) {
            try {
                this.mEvent.getGedcom().doUnitOfWork(gedcom -> {
                    this.mPlace = (PropertyPlace)this.mEvent.addProperty("PLAC", "");
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.placeChoiceWidget.setValues(this.mEvent.getGedcom().getReferenceSet("PLAC").getKeys((Comparator)this.mEvent.getGedcom().getCollator()));
        this.placeChoiceWidget.setText(this.mPlace.getDisplayValue());
    }

    public void commit() {
        Object tmp = "";
        for (int index = 0; index < this.mEventsModel.size(); ++index) {
            if (!this.mEventsModel.get((int)index).isSelected) continue;
            tmp = (String)tmp + (((String)tmp).isEmpty() ? "" : ", ") + PropertyTag2Name.getPropertyTag(this.mEventsModel.get(index).toString());
        }
        this.mEvent.setValue((String)tmp);
        try {
            this.aDateBean.commit();
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        PropertyPlace place = (PropertyPlace)this.mEvent.getProperty("PLAC", false);
        if (place != null) {
            place.setValue(this.placeChoiceWidget.getText());
        } else {
            place = (PropertyPlace)this.mEvent.addProperty("PLAC", this.placeChoiceWidget.getText());
        }
        place.setCoordinates();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class CheckableItem {
        private final String str;
        private boolean isSelected;

        public CheckableItem(String str) {
            this.str = str;
            this.isSelected = false;
        }

        public void setSelected(boolean b) {
            this.isSelected = b;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }
    }

    private class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer<CheckableItem> {
        @Override
        public Component getListCellRendererComponent(JList<? extends CheckableItem> list, CheckableItem checkableItem, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(checkableItem.isSelected());
            this.setText(checkableItem.toString());
            return this;
        }
    }
}

