/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.file;

import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.file.FileManager;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.model.RecordMisc;
import ancestris.modules.releve.model.RecordModelAbstract;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReleveFileEgmt {
    static final char fieldSeparator = ';';
    private static final String FILE_SIGNATURE = "EGMT";
    private static final String MARRIAGE_CONTRAC_EVENT_TYPE = "contrat de mariage";
    private static final String WILL_EVENT_TYPE = "testament";
    private static final String JURIDICTION_SEPARATOR = ",";
    static Pattern agePattern = Pattern.compile("([0-9]*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidFile(File inputFile, StringBuilder sb) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(inputFile));
            String[] fields = ReleveFileEgmt.splitLine(br);
            if (fields == null) {
                sb.append("EGMT ").append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.EmptyFile"), inputFile.getName()));
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception ex) {
            sb.append("EGMT ").append(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static String[] splitLine(BufferedReader br) throws Exception {
        List<String> fieldList = FileManager.Line.splitCSV(br, ';');
        if (fieldList != null) {
            String[] fields = fieldList.toArray(new String[0]);
            if (fields.length == 44) {
                return fields;
            }
            throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.FieldNb"), fields.length, 44));
        }
        return null;
    }

    public static FileBuffer loadFile(File inputFile) throws Exception {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            String[] fields;
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            String strLine = "";
            int lineNumber = 0;
            while ((fields = ReleveFileEgmt.splitLine(br)) != null) {
                ++lineNumber;
                try {
                    if (fields != null) {
                        AbstractRecord record;
                        if (fields[EgmtField.typeActe.ordinal()].toLowerCase().equals("naissance")) {
                            record = new RecordBirth();
                            record.setPlace(fields[EgmtField.nomCommune.ordinal()], "", fields[EgmtField.codeDepartement.ordinal()], "", "");
                            record.setFieldValue(AbstractRecord.FieldType.cote, fields[EgmtField.cote.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.parish, fields[EgmtField.paroisse.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[EgmtField.folio.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.eventDate, ReleveFileEgmt.formatDate(fields[EgmtField.day.ordinal()], fields[EgmtField.month.ordinal()], fields[EgmtField.year.ordinal()]));
                            record.setIndi(fields[EgmtField.indiFirstName.ordinal()], fields[EgmtField.indiLastName.ordinal()], fields[EgmtField.indiSex.ordinal()], "", "", fields[EgmtField.indiPlace.ordinal()], "", "", "", "", "", "", "", fields[EgmtField.indiComment.ordinal()]);
                            record.setIndiFather(fields[EgmtField.indiFatherFirstName.ordinal()], ReleveFileEgmt.getFatherLastName(fields), "", "", "", fields[EgmtField.indiFatherComment.ordinal()], fields[EgmtField.indiFatherDead.ordinal()], "");
                            record.setIndiMother(fields[EgmtField.indiMotherFirstName.ordinal()], fields[EgmtField.indiMotherLastName.ordinal()], "", "", "", fields[EgmtField.indiMotherComment.ordinal()], fields[EgmtField.indiMotherDead.ordinal()], "");
                            record.setWitness1(fields[EgmtField.witness1FirstName.ordinal()], fields[EgmtField.witness1LastName.ordinal()], "", fields[EgmtField.witness1Comment.ordinal()]);
                            record.setWitness2(fields[EgmtField.witness2FirstName.ordinal()], fields[EgmtField.witness2LastName.ordinal()], "", fields[EgmtField.witness2Comment.ordinal()]);
                            if (!fields[EgmtField.generalComment.ordinal()].isEmpty()) {
                                record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()] + " " + fields[EgmtField.heirComment.ordinal()]);
                            } else {
                                record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()]);
                            }
                            fileBuffer.addRecord(record);
                            continue;
                        }
                        if (fields[EgmtField.typeActe.ordinal()].toLowerCase().equals("mariage")) {
                            record = new RecordMarriage();
                            record.setPlace(fields[EgmtField.nomCommune.ordinal()], "", fields[EgmtField.codeDepartement.ordinal()], "", "");
                            record.setFieldValue(AbstractRecord.FieldType.cote, fields[EgmtField.cote.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.parish, fields[EgmtField.paroisse.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[EgmtField.folio.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.eventDate, ReleveFileEgmt.formatDate(fields[EgmtField.day.ordinal()], fields[EgmtField.month.ordinal()], fields[EgmtField.year.ordinal()]));
                            record.setIndi(fields[EgmtField.indiFirstName.ordinal()], fields[EgmtField.indiLastName.ordinal()], fields[EgmtField.indiSex.ordinal()], ReleveFileEgmt.formatAgeToField(fields[EgmtField.indiAge.ordinal()]), "", "", "", "", fields[EgmtField.indiPlace.ordinal()], "", "", "", "", fields[EgmtField.indiComment.ordinal()]);
                            record.setIndiFather(fields[EgmtField.indiFatherFirstName.ordinal()], ReleveFileEgmt.getFatherLastName(fields), "", "", "", fields[EgmtField.indiFatherComment.ordinal()], fields[EgmtField.indiFatherDead.ordinal()], "");
                            record.setIndiMother(fields[EgmtField.indiMotherFirstName.ordinal()], fields[EgmtField.indiMotherLastName.ordinal()], "", "", "", fields[EgmtField.indiMotherComment.ordinal()], fields[EgmtField.indiMotherDead.ordinal()], "");
                            record.setWife(fields[EgmtField.wifeFirstName.ordinal()], fields[EgmtField.wifeLastName.ordinal()], fields[EgmtField.indiSex.ordinal()].equals("M") ? "F" : "M", ReleveFileEgmt.formatAgeToField(fields[EgmtField.wifeAge.ordinal()]), "", "", "", "", fields[EgmtField.wifePlace.ordinal()], "", fields[EgmtField.wifeComment.ordinal()]);
                            record.setWifeFather(fields[EgmtField.wifeFatherFirstName.ordinal()], fields[EgmtField.wifeLastName.ordinal()], "", "", "", fields[EgmtField.wifeFatherComment.ordinal()], fields[EgmtField.wifeFatherDead.ordinal()], "");
                            record.setWifeMother(fields[EgmtField.wifeMotherFirstName.ordinal()], fields[EgmtField.wifeMotherLastName.ordinal()], "", "", "", fields[EgmtField.wifeMotherComment.ordinal()], fields[EgmtField.wifeMotherDead.ordinal()], "");
                            record.setWitness1(fields[EgmtField.witness1FirstName.ordinal()], fields[EgmtField.witness1LastName.ordinal()], "", fields[EgmtField.witness1Comment.ordinal()]);
                            record.setWitness2(fields[EgmtField.witness2FirstName.ordinal()], fields[EgmtField.witness2LastName.ordinal()], "", fields[EgmtField.witness2Comment.ordinal()]);
                            if (!fields[EgmtField.generalComment.ordinal()].isEmpty()) {
                                record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()] + " " + fields[EgmtField.heirComment.ordinal()]);
                            } else {
                                record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()]);
                            }
                            fileBuffer.addRecord(record);
                            continue;
                        }
                        if (fields[EgmtField.typeActe.ordinal()].toLowerCase().equals("d\u00e9c\u00e8s")) {
                            record = new RecordDeath();
                            record.setPlace(fields[EgmtField.nomCommune.ordinal()], "", fields[EgmtField.codeDepartement.ordinal()], "", "");
                            record.setFieldValue(AbstractRecord.FieldType.cote, fields[EgmtField.cote.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.parish, fields[EgmtField.paroisse.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[EgmtField.folio.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.eventDate, ReleveFileEgmt.formatDate(fields[EgmtField.day.ordinal()], fields[EgmtField.month.ordinal()], fields[EgmtField.year.ordinal()]));
                            record.setIndi(fields[EgmtField.indiFirstName.ordinal()], fields[EgmtField.indiLastName.ordinal()], fields[EgmtField.indiSex.ordinal()], ReleveFileEgmt.formatAgeToField(fields[EgmtField.indiAge.ordinal()]), "", "", "", "", fields[EgmtField.indiPlace.ordinal()], "", "", "", "", fields[EgmtField.indiComment.ordinal()]);
                            record.setIndiFather(fields[EgmtField.indiFatherFirstName.ordinal()], ReleveFileEgmt.getFatherLastName(fields), "", "", "", fields[EgmtField.indiFatherComment.ordinal()], fields[EgmtField.indiFatherDead.ordinal()], "");
                            record.setIndiMother(fields[EgmtField.indiMotherFirstName.ordinal()], fields[EgmtField.indiMotherLastName.ordinal()], "", "", "", fields[EgmtField.indiMotherComment.ordinal()], fields[EgmtField.indiMotherDead.ordinal()], "");
                            record.setIndiMarried(fields[EgmtField.wifeFirstName.ordinal()], fields[EgmtField.wifeLastName.ordinal()], "", "", "", fields[EgmtField.wifeComment.ordinal()], fields[EgmtField.wifeDead.ordinal()]);
                            record.setWitness1(fields[EgmtField.witness1FirstName.ordinal()], fields[EgmtField.witness1LastName.ordinal()], "", fields[EgmtField.witness1Comment.ordinal()]);
                            record.setWitness2(fields[EgmtField.witness2FirstName.ordinal()], fields[EgmtField.witness2LastName.ordinal()], "", fields[EgmtField.witness2Comment.ordinal()]);
                            if (!fields[EgmtField.generalComment.ordinal()].isEmpty()) {
                                record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()] + " " + fields[EgmtField.heirComment.ordinal()]);
                            } else {
                                record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()]);
                            }
                            fileBuffer.addRecord(record);
                            continue;
                        }
                        record = new RecordMisc();
                        record.setPlace(fields[EgmtField.nomCommune.ordinal()], "", fields[EgmtField.codeDepartement.ordinal()], "", "");
                        if (fields[EgmtField.typeActe.ordinal()].toLowerCase().equals(MARRIAGE_CONTRAC_EVENT_TYPE)) {
                            record.setFieldValue(AbstractRecord.FieldType.eventType, "MARC");
                        } else if (fields[EgmtField.typeActe.ordinal()].toLowerCase().equals(WILL_EVENT_TYPE)) {
                            record.setFieldValue(AbstractRecord.FieldType.eventType, "WILL");
                        } else {
                            if (fields[EgmtField.typeActe.ordinal()].toLowerCase().equals("evenement") || fields[EgmtField.typeActe.ordinal()].toLowerCase().equals("type d'acte") || fields[EgmtField.typeActe.ordinal()].isEmpty()) continue;
                            record.setFieldValue(AbstractRecord.FieldType.eventType, fields[EgmtField.typeActe.ordinal()]);
                        }
                        record.setFieldValue(AbstractRecord.FieldType.parish, fields[EgmtField.paroisse.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.notary, fields[EgmtField.notaire.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[EgmtField.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[EgmtField.folio.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, ReleveFileEgmt.formatDate(fields[EgmtField.day.ordinal()], fields[EgmtField.month.ordinal()], fields[EgmtField.year.ordinal()]));
                        record.setIndi(fields[EgmtField.indiFirstName.ordinal()], fields[EgmtField.indiLastName.ordinal()], fields[EgmtField.indiSex.ordinal()], ReleveFileEgmt.formatAgeToField(fields[EgmtField.indiAge.ordinal()]), "", "", "", "", fields[EgmtField.indiPlace.ordinal()], "", "", "", "", fields[EgmtField.indiComment.ordinal()]);
                        record.setIndiFather(fields[EgmtField.indiFatherFirstName.ordinal()], ReleveFileEgmt.getFatherLastName(fields), "", "", "", fields[EgmtField.indiFatherComment.ordinal()], fields[EgmtField.indiFatherDead.ordinal()], "");
                        record.setIndiMother(fields[EgmtField.indiMotherFirstName.ordinal()], fields[EgmtField.indiMotherLastName.ordinal()], "", "", "", fields[EgmtField.indiMotherComment.ordinal()], fields[EgmtField.indiMotherDead.ordinal()], "");
                        if (record.getFieldValue(AbstractRecord.FieldType.eventType).equals("MARC")) {
                            record.setWife(fields[EgmtField.wifeFirstName.ordinal()], fields[EgmtField.wifeLastName.ordinal()], fields[EgmtField.indiSex.ordinal()].equals("M") ? "F" : "M", ReleveFileEgmt.formatAgeToField(fields[EgmtField.wifeAge.ordinal()]), "", "", "", "", fields[EgmtField.wifePlace.ordinal()], "", fields[EgmtField.wifeComment.ordinal()]);
                            record.setWifeFather(fields[EgmtField.wifeFatherFirstName.ordinal()], fields[EgmtField.wifeLastName.ordinal()], "", "", "", fields[EgmtField.wifeFatherComment.ordinal()], fields[EgmtField.wifeFatherDead.ordinal()], "");
                            record.setWifeMother(fields[EgmtField.wifeMotherFirstName.ordinal()], fields[EgmtField.wifeMotherLastName.ordinal()], "", "", "", fields[EgmtField.wifeMotherComment.ordinal()], fields[EgmtField.wifeMotherDead.ordinal()], "");
                        } else {
                            record.setIndiMarried(fields[EgmtField.wifeFirstName.ordinal()], fields[EgmtField.wifeLastName.ordinal()], "", fields[EgmtField.wifePlace.ordinal()], "", fields[EgmtField.wifeComment.ordinal()], fields[EgmtField.wifeDead.ordinal()]);
                        }
                        record.setWitness1(fields[EgmtField.witness1FirstName.ordinal()], fields[EgmtField.witness1LastName.ordinal()], "", fields[EgmtField.witness1Comment.ordinal()]);
                        record.setWitness2(fields[EgmtField.witness2FirstName.ordinal()], fields[EgmtField.witness2LastName.ordinal()], "", fields[EgmtField.witness2Comment.ordinal()]);
                        if (!fields[EgmtField.heirComment.ordinal()].isEmpty()) {
                            record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()] + ", H\u00e9ritier: " + fields[EgmtField.heirComment.ordinal()]);
                        } else {
                            record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[EgmtField.generalComment.ordinal()]);
                        }
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(strLine).append("\n   ");
                    fileBuffer.append(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.InvalidLine"));
                }
                catch (NumberFormatException e) {
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(strLine).append("\n   ");
                    fileBuffer.append(e.getMessage()).append("\n");
                }
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("Exception while reading file: " + e);
            throw e;
        }
        return fileBuffer;
    }

    public static StringBuilder saveFile(RecordModelAbstract recordModel, AbstractRecord.RecordType recordType, File fileName, boolean append) {
        StringBuilder sb = new StringBuilder();
        try {
            FileWriter writer = new FileWriter(fileName, append);
            if (!append) {
                writer.write(ReleveFileEgmt.getHeader().toString());
            }
            for (int index = 0; index < recordModel.getRowCount(); ++index) {
                AbstractRecord record = recordModel.getRecord(index);
                if (recordType != null && recordType != record.getType()) continue;
                FileManager.Line line = new FileManager.Line(';');
                try {
                    if (record instanceof RecordBirth) {
                        line.appendCsvFn("naissance", new String[0]);
                    } else if (record instanceof RecordMarriage) {
                        line.appendCsvFn("mariage", new String[0]);
                    } else if (record instanceof RecordDeath) {
                        line.appendCsvFn("d\u00e9c\u00e8s", new String[0]);
                    } else {
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventType).toLowerCase(), new String[0]);
                    }
                    line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                    line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                    if (record instanceof RecordMisc) {
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.notary), new String[0]);
                    } else {
                        line.appendCsvFn("", new String[0]);
                    }
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                    String[] eventDate = record.getFieldValue(AbstractRecord.FieldType.eventDate).split("/");
                    switch (eventDate.length) {
                        case 3: {
                            line.appendCsvFn(eventDate[0], new String[0]);
                            line.appendCsvFn(eventDate[1], new String[0]);
                            line.appendCsvFn(eventDate[2], new String[0]);
                            break;
                        }
                        case 2: {
                            line.appendCsvFn("", new String[0]);
                            line.appendCsvFn(eventDate[0], new String[0]);
                            line.appendCsvFn(eventDate[1], new String[0]);
                            break;
                        }
                        case 1: {
                            line.appendCsvFn("", new String[0]);
                            line.appendCsvFn("", new String[0]);
                            line.appendCsvFn(eventDate[0], new String[0]);
                            break;
                        }
                        default: {
                            line.appendCsvFn("", new String[0]);
                            line.appendCsvFn("", new String[0]);
                            line.appendCsvFn("", new String[0]);
                        }
                    }
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                    line.appendCsvFn(ReleveFileEgmt.formatAgeToAge(record.getFieldValue(AbstractRecord.FieldType.indiAge)), new String[0]);
                    if (record instanceof RecordBirth) {
                        line.appendCsvFn(ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace)), new String[0]);
                    } else {
                        line.appendCsvFn(ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiResidence)), new String[0]);
                    }
                    if (record instanceof RecordBirth) {
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                    } else {
                        Object birthDate = "";
                        if (!record.getFieldValue(AbstractRecord.FieldType.indiBirthDate).isEmpty()) {
                            birthDate = "n\u00e9 le " + record.getFieldValue(AbstractRecord.FieldType.indiBirthDate);
                        }
                        if (record instanceof RecordMarriage || record instanceof RecordMisc && record.getFieldValue(AbstractRecord.FieldType.eventType).toLowerCase().equals(MARRIAGE_CONTRAC_EVENT_TYPE)) {
                            line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[]{birthDate, ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace)), record.getFieldValue(AbstractRecord.FieldType.indiOccupation), ReleveFileEgmt.appendLabelValue("Ex conjoint:", record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence)), record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment))});
                        } else {
                            line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[]{birthDate, ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace)), record.getFieldValue(AbstractRecord.FieldType.indiOccupation)});
                        }
                    }
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldString(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence)), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge)));
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldString(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence)), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge)));
                    String otherParticipant = "";
                    if (record instanceof RecordMarriage || record instanceof RecordMisc && record.getFieldValue(AbstractRecord.FieldType.eventType).toLowerCase().equals(MARRIAGE_CONTRAC_EVENT_TYPE)) {
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(ReleveFileEgmt.formatAgeToAge(record.getFieldValue(AbstractRecord.FieldType.wifeAge)), new String[0]);
                        line.appendCsvFn(ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeResidence)), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeComment), ReleveFileEgmt.appendLabelValue("n\u00e9 le", record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate)), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace)), record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), ReleveFileEgmt.appendLabelValue("Ex conjoint:", record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), record.getFieldString(AbstractRecord.FieldType.wifeMarriedDead), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence)), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment)));
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldString(AbstractRecord.FieldType.wifeFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment), record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence)), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge)));
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldString(AbstractRecord.FieldType.wifeMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment), record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence)), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge)));
                        line.appendCsvFn("", new String[0]);
                    } else if (record instanceof RecordMisc && record.getFieldValue(AbstractRecord.FieldType.eventType).toLowerCase().equals(WILL_EVENT_TYPE)) {
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence)), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment));
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        String heirName = ReleveFileEgmt.appendLabelValue("", record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeLastName));
                        String heirAge = ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeAge));
                        String heirBirth = ReleveFileEgmt.appendLabelValue("n\u00e9 le ", record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace)));
                        String heirFather = ReleveFileEgmt.appendLabelValue("P\u00e8re de l'h\u00e9ritier:", record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge)), record.getFieldString(AbstractRecord.FieldType.wifeFatherDead), record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence)), record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment));
                        String heirMother = ReleveFileEgmt.appendLabelValue("M\u00e8re de l'h\u00e9ritier:", record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge)), record.getFieldString(AbstractRecord.FieldType.wifeMotherDead), record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence)), record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment));
                        String heirMarried = ReleveFileEgmt.appendLabelValue("Conjoint de l'h\u00e9ritier:", record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), record.getFieldString(AbstractRecord.FieldType.wifeMarriedDead), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence)), record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment));
                        line.appendCsvFn(heirName, heirAge, heirBirth, record.getFieldValue(AbstractRecord.FieldType.wifeComment), record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeResidence)), heirFather, heirMother, heirMarried);
                    } else if (record instanceof RecordMisc) {
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence)), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment));
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        String participantName = ReleveFileEgmt.appendLabelValue("Autre intervenant:", record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeLastName));
                        String participantAge = ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeAge));
                        String participantBirth = ReleveFileEgmt.appendLabelValue("n\u00e9 le", record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace));
                        String participantFather = ReleveFileEgmt.appendLabelValue("P\u00e8re de l'intervenant:", record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge)), record.getFieldString(AbstractRecord.FieldType.wifeFatherDead), record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence)), record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment));
                        String participantMother = ReleveFileEgmt.appendLabelValue("M\u00e8re de l'intervenant:", record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), ReleveFileEgmt.formatAgeToComment(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge)), record.getFieldString(AbstractRecord.FieldType.wifeMotherDead), record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence)), record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment));
                        String participantMarried = ReleveFileEgmt.appendLabelValue("Conjoint de l'intervenant:", record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), record.getFieldString(AbstractRecord.FieldType.wifeMarriedDead), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence)), record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment));
                        otherParticipant = ReleveFileEgmt.appendValue(participantName, participantAge, participantBirth, record.getFieldValue(AbstractRecord.FieldType.wifeComment), record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), ReleveFileEgmt.formatPlace(record.getFieldValue(AbstractRecord.FieldType.wifeResidence)), participantFather, participantMother, participantMarried);
                        line.appendCsvFn("", new String[0]);
                    } else if (record instanceof RecordDeath) {
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                    } else {
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                    }
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), record.getFieldValue(AbstractRecord.FieldType.witness1Comment));
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), record.getFieldValue(AbstractRecord.FieldType.witness2Comment));
                    Object insinuation = "";
                    if (!record.isEmptyField(AbstractRecord.FieldType.secondDate)) {
                        insinuation = "insinu\u00e9 le " + record.getFieldValue(AbstractRecord.FieldType.secondDate);
                    }
                    line.appendCsv(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[]{otherParticipant, ReleveFileEgmt.appendLabelValue("t\u00e9moin(s):", record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), record.getFieldValue(AbstractRecord.FieldType.witness3LastName), record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), record.getFieldValue(AbstractRecord.FieldType.witness3Comment)), ReleveFileEgmt.appendLabelValue("", record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), record.getFieldValue(AbstractRecord.FieldType.witness4LastName), record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), record.getFieldValue(AbstractRecord.FieldType.witness4Comment)), insinuation});
                    line.appendCsv("\r\n", new String[0]);
                    writer.write(line.toString());
                    continue;
                }
                catch (IOException e) {
                    sb.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), index));
                    sb.append("\n");
                    sb.append(line).append("\n   ");
                    sb.append(e.getMessage()).append("\n");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Exception while reading file: " + e);
        }
        return sb;
    }

    private static String formatAgeToComment(String value) {
        Object ageString = value.isEmpty() || value.equals("0d") ? "" : "Age:" + value.replace('y', 'a').replace('d', 'j');
        return ageString;
    }

    private static String formatAgeToAge(String value) {
        String ageString = value != null ? (value.equals("0d") ? "" : value.replace('y', 'a').replace('d', 'j')) : "";
        return ageString;
    }

    private static String formatPlace(String place) {
        String[] splitPlace = place.split(JURIDICTION_SEPARATOR, -1);
        if (splitPlace.length > 0) {
            return splitPlace[0];
        }
        return "";
    }

    private static String getFatherLastName(String[] fields) {
        String fatherLastName = fields[EgmtField.indiFatherFirstName.ordinal()].isEmpty() ? "" : fields[EgmtField.indiLastName.ordinal()];
        return fatherLastName;
    }

    private static String appendValue(String value, String ... otherValues) {
        int fieldSize = value.length();
        StringBuilder sb = new StringBuilder();
        sb.append(value.trim());
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (fieldSize > 0) {
                sb.append(", ");
            }
            sb.append(otherValue.trim());
            fieldSize += otherValue.length();
        }
        return sb.toString();
    }

    private static String appendLabelValue(String label, String ... otherValues) {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(otherValue.trim());
        }
        if (sb.length() > 0 && !label.trim().isEmpty()) {
            sb.insert(0, label.trim() + " ");
        }
        return sb.toString();
    }

    protected static String formatAgeToField(String ageString) {
        ageString = ageString.trim();
        Matcher m = agePattern.matcher(ageString = ageString.replace(" ", "").replace("ans", "y").replace("an", "y").replace("mois", "m").replace("jours", "d").replace("jour", "d"));
        String ageField = m.matches() ? ageString.concat("y") : ageString.replace('a', 'y').replace('j', 'd');
        return ageField;
    }

    protected static String formatDate(String strDay, String strMonth, String strYear) {
        try {
            int day = 0;
            int month = 0;
            int year = 0;
            if (!strDay.isEmpty()) {
                day = Integer.parseInt(strDay);
            }
            if (!strMonth.isEmpty()) {
                month = Integer.parseInt(strMonth);
            }
            if (!strYear.isEmpty()) {
                year = Integer.parseInt(strYear);
            }
            return String.format("%02d/%02d/%04d", day, month, year);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Error " + strDay + " " + strMonth + " " + strYear + " " + ex);
        }
    }

    private static FileManager.Line getHeader() {
        FileManager.Line line = new FileManager.Line(';');
        line.appendCsvFn("Type d'acte", new String[0]);
        line.appendCsvFn("Departement", new String[0]);
        line.appendCsvFn("Commune", new String[0]);
        line.appendCsvFn("Paroisse", new String[0]);
        line.appendCsvFn("Notaire", new String[0]);
        line.appendCsvFn("Cote", new String[0]);
        line.appendCsvFn("N\u00b0 Photo", new String[0]);
        line.appendCsvFn("Jour", new String[0]);
        line.appendCsvFn("Mois", new String[0]);
        line.appendCsvFn("Annee", new String[0]);
        line.appendCsvFn("Nom", new String[0]);
        line.appendCsvFn("Prenom", new String[0]);
        line.appendCsvFn("Sexe", new String[0]);
        line.appendCsvFn("Age", new String[0]);
        line.appendCsvFn("Lieu", new String[0]);
        line.appendCsvFn("Infos", new String[0]);
        line.appendCsvFn("Prenom pere", new String[0]);
        line.appendCsvFn("Pere decede", new String[0]);
        line.appendCsvFn("Info pere", new String[0]);
        line.appendCsvFn("Nom mere", new String[0]);
        line.appendCsvFn("Prenom mere", new String[0]);
        line.appendCsvFn("Mere decede", new String[0]);
        line.appendCsvFn("Info mere", new String[0]);
        line.appendCsvFn("Nom conjoint", new String[0]);
        line.appendCsvFn("Prenom conjoint", new String[0]);
        line.appendCsvFn("Deces conjoint", new String[0]);
        line.appendCsvFn("Age conjoint", new String[0]);
        line.appendCsvFn("Lieu conjoint", new String[0]);
        line.appendCsvFn("Info conjoint", new String[0]);
        line.appendCsvFn("Prenom pere conjoint", new String[0]);
        line.appendCsvFn("Deces pere conjoint", new String[0]);
        line.appendCsvFn("Info pere conjoint", new String[0]);
        line.appendCsvFn("Nom mere conjoint", new String[0]);
        line.appendCsvFn("Prenom mere conjoint", new String[0]);
        line.appendCsvFn("Deces mere conjoint", new String[0]);
        line.appendCsvFn("Info mere conjoint", new String[0]);
        line.appendCsvFn("Heritiers", new String[0]);
        line.appendCsvFn("Nom parrain", new String[0]);
        line.appendCsvFn("Prenom parrain", new String[0]);
        line.appendCsvFn("Commentaire parrain", new String[0]);
        line.appendCsvFn("Nom marrraine", new String[0]);
        line.appendCsvFn("Prenom marrraine", new String[0]);
        line.appendCsvFn("Infos marrraine", new String[0]);
        line.appendCsv("Infos diverses", new String[0]);
        line.appendCsv("\r\n", new String[0]);
        return line;
    }

    static enum EgmtField {
        typeActe,
        codeDepartement,
        nomCommune,
        paroisse,
        notaire,
        cote,
        folio,
        day,
        month,
        year,
        indiLastName,
        indiFirstName,
        indiSex,
        indiAge,
        indiPlace,
        indiComment,
        indiFatherFirstName,
        indiFatherDead,
        indiFatherComment,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherDead,
        indiMotherComment,
        wifeLastName,
        wifeFirstName,
        wifeDead,
        wifeAge,
        wifePlace,
        wifeComment,
        wifeFatherFirstName,
        wifeFatherDead,
        wifeFatherComment,
        wifeMotherLastName,
        wifeMotherFirstName,
        wifeMotherDead,
        wifeMotherComment,
        heirComment,
        witness1LastName,
        witness1FirstName,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Comment,
        generalComment;

    }
}

