/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.ChangeSupport;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.NestedBlockLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.event.ChangeListener;

public class BeanPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.edit");
    private static final Resources RES = Resources.get(BeanPanel.class);
    private static final Registry REGISTRY = Registry.get(BeanPanel.class);
    private static final Map<String, NestedBlockLayout> DESCRIPTORCACHE = new HashMap<String, NestedBlockLayout>();
    protected ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final List<PropertyBean> beans = new ArrayList<PropertyBean>(32);

    private static NestedBlockLayout getLayout(String key) {
        NestedBlockLayout result;
        block7: {
            result = DESCRIPTORCACHE.get(key);
            if (result != null) {
                return result.copy();
            }
            if (DESCRIPTORCACHE.containsKey(key)) {
                return null;
            }
            try {
                InputStream in = BeanPanel.class.getResourceAsStream(key);
                if (in == null) break block7;
                try {
                    result = new NestedBlockLayout(in);
                }
                finally {
                    in.close();
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "cannot read descriptor {0} ({1})", new Object[]{key, t.getMessage()});
            }
        }
        DESCRIPTORCACHE.put(key, result);
        return result != null ? result.copy() : null;
    }

    private static NestedBlockLayout getLayout(MetaProperty meta) {
        if (Entity.class.isAssignableFrom(meta.getType())) {
            return BeanPanel.getLayout("descriptors/entities/" + meta.getTag() + ".xml");
        }
        String key = "descriptors/properties/" + meta.getTag() + ".xml";
        NestedBlockLayout result = BeanPanel.getLayout(key);
        if (result != null) {
            return result;
        }
        for (Class type = meta.getType(); type != null; type = type.getSuperclass()) {
            result = BeanPanel.getLayout("descriptors/properties/" + type.getSimpleName() + ".xml");
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public BeanPanel() {
        this.setFocusTraversalPolicy(new FocusPolicy());
        this.setFocusCycleRoot(true);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public boolean isCommittable() {
        for (PropertyBean bean : this.getBeans()) {
            if (bean.isCommittable()) continue;
            return false;
        }
        return true;
    }

    public void commit() throws GedcomException {
        for (PropertyBean bean : this.beans) {
            if (!bean.hasChanged()) continue;
            bean.commit();
        }
        this.changeSupport.setChanged(false);
    }

    public List<PropertyBean> getBeans() {
        return this.beans;
    }

    public List<? extends Action> getActions() {
        ArrayList result = new ArrayList();
        for (PropertyBean bean : this.beans) {
            result.addAll(bean.getActions());
        }
        return result;
    }

    public void select(Property prop) {
        if (prop == null || this.beans.isEmpty()) {
            return;
        }
        for (PropertyBean bean : this.beans) {
            if (bean.getProperty() != prop || !bean.requestFocusInWindow()) continue;
            return;
        }
        for (PropertyBean bean : this.beans) {
            if (!bean.isDisplayable() || bean.getProperty() == null || !bean.getProperty().isContained(prop) || !bean.requestFocusInWindow()) continue;
            return;
        }
        this.beans.get(0).requestFocusInWindow();
    }

    public void setRoot(Property root) {
        ArrayList<PropertyBean> bs = new ArrayList<PropertyBean>(this.beans);
        this.beans.clear();
        for (PropertyBean bean : bs) {
            bean.removeChangeListener((ChangeListener)this.changeSupport);
            bean.getParent().remove((Component)bean);
            PropertyBean.recycle((PropertyBean)bean);
        }
        this.removeAll();
        if (root != null) {
            HashSet<String> beanifiedTags = new HashSet<String>();
            NestedBlockLayout descriptor = BeanPanel.getLayout(root.getMetaProperty());
            if (descriptor != null) {
                this.parse(root, root, descriptor, beanifiedTags);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void parse(Property root, Property property, NestedBlockLayout descriptor, Set<String> beanifiedTags) {
        this.setLayout((LayoutManager)descriptor);
        for (NestedBlockLayout.Cell cell : descriptor.getCells()) {
            JComponent comp = this.createComponent(root, property, cell, beanifiedTags);
            if (comp == null) continue;
            this.add((Component)comp, cell);
        }
    }

    protected JComponent createComponent(Property root, Property property, NestedBlockLayout.Cell cell, Set<String> beanifiedTags) {
        String element = cell.getElement();
        String version = cell.getAttribute("gedcom");
        if (version != null & !property.getGedcom().getGrammar().getVersion().equals(version)) {
            return null;
        }
        if ("text".equals(element)) {
            return new JLabel(cell.getAttribute("value"));
        }
        if ("fold".equals(element)) {
            String indent;
            String key = cell.getAttribute("key");
            if (key == null) {
                throw new IllegalArgumentException("fold without key");
            }
            String label = RES.getString(key, false);
            if (label == null) {
                label = Gedcom.getName((String)key);
            }
            NestedBlockLayout.Expander result = new NestedBlockLayout.Expander(label, (indent = cell.getAttribute("indent")) != null ? Integer.valueOf(indent) : 1);
            Registry r = new Registry(REGISTRY, root.getTag() + "." + key);
            result.setCollapsed(r.get("folded", "1".equals(cell.getAttribute("collapsed"))));
            result.addPropertyChangeListener("folded", (PropertyChangeListener)r);
            return result;
        }
        if ("label".equals(element)) {
            String key = cell.getAttribute("key");
            if (key != null) {
                return new JLabel(RES.getString(key));
            }
            String path = cell.getAttribute("path");
            if (path == null) {
                throw new IllegalArgumentException("label without key or path");
            }
            MetaProperty meta = property.getMetaProperty().getNestedRecursively(new TagPath(path), false);
            if (Entity.class.isAssignableFrom(meta.getType())) {
                return new JLabel(meta.getName() + " " + ((Entity)root).getId(), null, 2);
            }
            return new JLabel(meta.getName(cell.isAttribute("plural")), null, 2);
        }
        if ("bean".equals(element)) {
            TagPath path = new TagPath(cell.getAttribute("path"));
            PropertyBean bean = this.createBean(property, path, cell.getAttribute("type"));
            if (bean == null) {
                return null;
            }
            String dir = cell.getAttribute("dir");
            if (dir != null && dir.startsWith("h")) {
                bean.setPreferHorizontal(true);
            }
            if (beanifiedTags != null && property == root && path.length() > 1) {
                beanifiedTags.add(path.get(1));
            }
            return bean;
        }
        throw new IllegalArgumentException("Template element " + cell.getElement() + " is unkown");
    }

    private PropertyBean createBean(Property root, TagPath path, String beanOverride) {
        Property prop = root.getProperty(path, false);
        PropertyBean bean = beanOverride != null ? PropertyBean.getBean((String)beanOverride) : (prop != null ? PropertyBean.getBean(prop.getClass()) : PropertyBean.getBean((Class)root.getMetaProperty().getNestedRecursively(path, false).getType("")));
        bean.setContext(root, path, prop, this.beans);
        bean.addChangeListener((ChangeListener)this.changeSupport);
        this.beans.add(bean);
        return bean;
    }

    private class FocusPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private final Hack hack = new Hack();

        private FocusPolicy() {
        }

        @Override
        protected boolean accept(Component c) {
            return this.hack.accept(c);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return BeanPanel.this.beans.isEmpty() ? null : super.getComponentAfter(container, component);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            return BeanPanel.this.beans.isEmpty() ? null : super.getComponentBefore(container, component);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return BeanPanel.this.beans.isEmpty() ? null : super.getDefaultComponent(container);
        }

        private class Hack
        extends LayoutFocusTraversalPolicy {
            private Hack() {
            }

            @Override
            protected boolean accept(Component c) {
                return super.accept(c);
            }
        }
    }
}

