/*
* Copyright (c) 2017 Robert San <robertsanseries@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

namespace Ciano.Configs {

    /**
     * The {@code Constants} class is responsible for defining all 
     * the constants used in the application.
     *
     * @since 0.1.0
     */
    public class Constants {

        public abstract const string PROGRAME_NAME                          = "Ciano";
        public abstract const string ID                                     = "com.github.robertsanseries.ciano";
        public abstract const string VERSION                                = "0.1.0";
        public abstract const string APP_YEARS                              = "2017";
        public abstract const string APP_ICON                               = "com.github.robertsanseries.ciano";
        public abstract const string ABOUT_COMMENTS                         = "Multimedia converter for all the format you need.";
        public abstract const string TRANSLATOR_CREDITS                     = "Github Translators";
        public abstract const string MAIN_URL                               = "https://robertsanseries.github.io/ciano";
        public abstract const string BUG_URL                                = "https://github.com/robertsanseries/ciano/issues";
        public abstract const string HELP_URL                               = "https://github.com/robertsanseries/ciano/wiki";
        public abstract const string TRANSLATE_URL                          = "https://robertsanseries.github.io/ciano";
        public abstract const string TEXT_FOR_ABOUT_DIALOG_WEBSITE          = "Website";
        public abstract const string TEXT_FOR_ABOUT_DIALOG_WEBSITE_URL      = "https://robertsanseries.github.io/ciano";
        public abstract const string URL_CSS                                = "com/github/robertsanseries/ciano/css/style.css";
        public abstract const string DIRECTORY_CIANO                        = "/Ciano";
        public abstract const string WELCOME_VIEW                           = "welcome-view";
        public abstract const string LIST_BOX_VIEW                          = "list-box-view";
        public abstract const string TEXT_MP4                               = "MP4";
        public abstract const string TEXT_3GP                               = "3GP";
        public abstract const string TEXT_MPG                               = "MPG";
        public abstract const string TEXT_AVI                               = "AVI";
        public abstract const string TEXT_WMV                               = "WMV";
        public abstract const string TEXT_FLV                               = "FLV";
        public abstract const string TEXT_SWF                               = "SWF";
        public abstract const string TEXT_MOV                               = "MOV";
        public abstract const string TEXT_MKV                               = "MKV";
        public abstract const string TEXT_VOB                               = "VOB";
        public abstract const string TEXT_MP3                               = "MP3";
        public abstract const string TEXT_WMA                               = "WMA";
        public abstract const string TEXT_AMR                               = "AMR";
        public abstract const string TEXT_OGG                               = "OGG";
        public abstract const string TEXT_AAC                               = "AAC";
        public abstract const string TEXT_MMF                               = "MMF";
        public abstract const string TEXT_M4A                               = "M4A";
        public abstract const string TEXT_OPUS                              = "OPUS";
        public abstract const string TEXT_WAV                               = "WAV";
        public abstract const string TEXT_FLAC                              = "FLAC";
        public abstract const string TEXT_AIFF                              = "AIFF";
        public abstract const string TEXT_JPG                               = "JPG";
        public abstract const string TEXT_BMP                               = "BMP";
        public abstract const string TEXT_PNG                               = "PNG";
        public abstract const string TEXT_TIF                               = "TIF";
        public abstract const string TEXT_ICO                               = "ICO";
        public abstract const string TEXT_GIF                               = "GIF";
        public abstract const string TEXT_TGA                               = "TGA";
        public abstract const string TEXT_OGV                               = "OGV";
        public abstract const string TEXT_WEBM                              = "WEBM";
        public abstract const string TEXT_WEBP                              = "WEBP";
        public abstract const string TEXT_AT9                               = "AT9";
        public abstract const string [] ABOUT_AUTHORS                       = { "Robert San <robertsanseries@gmail.com>" };
        public abstract const Gtk.License ABOUT_LICENSE_TYPE                = Gtk.License.GPL_3_0;
    }
}
