/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.manager.DB2AbstractDropOnlyManager;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Nickname;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class DB2NicknameManager
extends DB2AbstractDropOnlyManager<DB2Nickname, DB2Schema> {
    private static final String SQL_DROP = "DROP NICKNAME %s";

    @Override
    public String buildDropStatement(DB2Nickname db2Nickname) {
        String fullyQualifiedName = db2Nickname.getFullyQualifiedName(DBPEvaluationContext.DDL);
        return String.format(SQL_DROP, fullyQualifiedName);
    }

    @Nullable
    public DBSObjectCache<DB2Schema, DB2Nickname> getObjectsCache(DB2Nickname db2Nickname) {
        return db2Nickname.getSchema().getNicknameCache();
    }
}

