/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.apache.commons.logging.Log;

public abstract class InterpreterBase
extends ParserVisitor {
    protected final Engine jexl;
    protected final Log logger;
    protected final JexlUberspect uberspect;
    protected final JexlArithmetic arithmetic;
    protected final JexlContext context;
    protected volatile boolean cancelled = false;
    protected static final Object[] EMPTY_PARAMS;
    protected static final Class<?> AUTOCLOSEABLE;

    protected InterpreterBase(Engine engine, JexlContext aContext) {
        this.jexl = engine;
        this.logger = this.jexl.logger;
        this.uberspect = this.jexl.uberspect;
        this.context = aContext != null ? aContext : Engine.EMPTY_CONTEXT;
        JexlArithmetic jexla = this.jexl.arithmetic;
        this.arithmetic = jexla.options(this.context);
        if (this.arithmetic != jexla && !this.arithmetic.getClass().equals(jexla.getClass())) {
            this.logger.warn((Object)("expected arithmetic to be " + jexla.getClass().getSimpleName() + ", got " + this.arithmetic.getClass().getSimpleName()));
        }
    }

    protected InterpreterBase(InterpreterBase ii, JexlArithmetic jexla) {
        this.jexl = ii.jexl;
        this.logger = ii.logger;
        this.uberspect = ii.uberspect;
        this.context = ii.context;
        this.arithmetic = ii.arithmetic;
    }

    protected void closeIfSupported(Object closeable) {
        JexlMethod mclose;
        if (closeable != null && (mclose = this.uberspect.getMethod(closeable, "close", EMPTY_PARAMS)) != null) {
            try {
                mclose.invoke(closeable, EMPTY_PARAMS);
            }
            catch (Exception xignore) {
                this.logger.warn((Object)xignore);
            }
        }
    }

    protected boolean isStrictEngine() {
        JexlEngine.Options opts;
        Boolean strict;
        if (this.context instanceof JexlEngine.Options && (strict = (opts = (JexlEngine.Options)((Object)this.context)).isStrict()) != null) {
            return strict;
        }
        return this.jexl.isStrict();
    }

    protected boolean isSilent() {
        JexlEngine.Options opts;
        Boolean silent;
        if (this.context instanceof JexlEngine.Options && (silent = (opts = (JexlEngine.Options)((Object)this.context)).isSilent()) != null) {
            return silent;
        }
        return this.jexl.isSilent();
    }

    protected boolean isCancellable() {
        JexlEngine.Options opts;
        Boolean ocancellable;
        if (this.context instanceof JexlEngine.Options && (ocancellable = (opts = (JexlEngine.Options)((Object)this.context)).isCancellable()) != null) {
            return ocancellable;
        }
        return this.jexl.isCancellable();
    }

    protected JexlNode findNullOperand(RuntimeException xrt, JexlNode node, Object left, Object right) {
        if (xrt instanceof JexlArithmetic.NullOperand) {
            if (left == null) {
                return node.jjtGetChild(0);
            }
            if (right == null) {
                return node.jjtGetChild(1);
            }
        }
        return node;
    }

    protected Object unsolvableVariable(JexlNode node, String var, boolean undef) {
        if (this.isStrictEngine() && (undef || this.arithmetic.isStrict())) {
            throw new JexlException.Variable(node, var, undef);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)JexlException.variableError(node, var, undef));
        }
        return null;
    }

    protected Object unsolvableMethod(JexlNode node, String method) {
        if (this.isStrictEngine()) {
            throw new JexlException.Method(node, method);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)JexlException.methodError(node, method));
        }
        return null;
    }

    protected Object unsolvableProperty(JexlNode node, String var, Throwable cause) {
        if (this.isStrictEngine()) {
            throw new JexlException.Property(node, var, cause);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)JexlException.propertyError(node, var), cause);
        }
        return null;
    }

    protected Object operatorError(JexlNode node, JexlOperator operator, Throwable cause) {
        if (this.isStrictEngine()) {
            throw new JexlException.Operator(node, operator.getOperatorSymbol(), cause);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)JexlException.operatorError(node, operator.getOperatorSymbol()), cause);
        }
        return null;
    }

    protected Object annotationError(JexlNode node, String annotation, Throwable cause) {
        if (this.isStrictEngine()) {
            throw new JexlException.Annotation(node, annotation, cause);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)JexlException.annotationError(node, annotation), cause);
        }
        return null;
    }

    protected JexlException invocationException(JexlNode node, String methodName, Exception xany) {
        Throwable cause = xany.getCause();
        if (cause instanceof JexlException) {
            return (JexlException)cause;
        }
        if (cause instanceof InterruptedException) {
            this.cancelled = true;
            return new JexlException.Cancel(node);
        }
        return new JexlException(node, methodName, (Throwable)xany);
    }

    protected synchronized boolean cancel() {
        if (this.cancelled) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    protected synchronized boolean isCancelled() {
        if (!this.cancelled) {
            this.cancelled = Thread.currentThread().isInterrupted();
        }
        return this.cancelled;
    }

    static {
        Class<?> c;
        EMPTY_PARAMS = new Object[0];
        try {
            c = Class.forName("java.lang.AutoCloseable");
        }
        catch (ClassNotFoundException xclass) {
            c = null;
        }
        AUTOCLOSEABLE = c;
    }
}

