/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.customize;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.widgets.MultiLineLabel;
import org.eclipse.gef.internal.ui.palette.ToolbarDropdownContributionItem;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPageContainer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizationAction;
import org.eclipse.gef.ui.palette.customize.PaletteEntryFactory;
import org.eclipse.gef.ui.palette.customize.PaletteLabelProvider;
import org.eclipse.gef.ui.palette.customize.PaletteTreeProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class PaletteCustomizerDialog
extends Dialog
implements EntryPageContainer {
    protected static final int APPLY_ID = 1025;
    protected static final int CLIENT_ID = 16;
    private HashMap widgets = new HashMap();
    private HashMap entriesToPages = new HashMap();
    private List actions;
    private String errorMessage;
    private Tree tree;
    private Composite titlePage;
    private Composite errorPage;
    private PageBook propertiesPanelContainer;
    private PageBook titleSwitcher;
    private PaletteCustomizer customizer;
    private EntryPage activePage;
    private EntryPage noSelectionPage;
    private CLabel title;
    private MultiLineLabel errorTitle;
    private Image titleImage;
    private TreeViewer treeviewer;
    private ILabelProvider treeViewerLabelProvider;
    private PaletteEntry activeEntry;
    private PaletteEntry initialSelection;
    private PaletteRoot root;
    private PropertyChangeListener titleUpdater = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (PaletteCustomizerDialog.this.title == null) {
                return;
            }
            PaletteCustomizerDialog.this.title.setText(((PaletteEntry)evt.getSource()).getLabel());
        }
    };
    private ISelectionChangedListener pageFlippingPreventer = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PaletteCustomizerDialog.this.treeviewer.removePostSelectionChangedListener((ISelectionChangedListener)this);
            PaletteCustomizerDialog.this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)PaletteCustomizerDialog.this.activeEntry));
        }
    };
    private boolean isSetup = true;
    static /* synthetic */ Class class$0;

    public PaletteCustomizerDialog(Shell shell, PaletteCustomizer customizer, PaletteRoot root) {
        super(shell);
        this.customizer = customizer;
        this.root = root;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        if (1025 == buttonId) {
            this.handleApplyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void clearProblem() {
        if (this.errorMessage != null) {
            this.titleSwitcher.showPage((Control)this.titlePage);
            this.getButton(0).setEnabled(true);
            this.getButton(1025).setEnabled(true);
            this.errorMessage = null;
        }
    }

    public boolean close() {
        if (this.activeEntry != null) {
            this.activeEntry.removePropertyChangeListener(this.titleUpdater);
        }
        if (this.getReturnCode() == 0) {
            this.save();
        } else {
            this.revertToSaved();
        }
        boolean returnVal = super.close();
        this.entriesToPages.clear();
        this.widgets.clear();
        this.actions = null;
        this.activePage = null;
        this.tree = null;
        this.propertiesPanelContainer = null;
        this.titleSwitcher = null;
        this.titlePage = null;
        this.errorPage = null;
        this.title = null;
        this.errorTitle = null;
        this.treeviewer = null;
        this.noSelectionPage = null;
        this.initialSelection = null;
        this.activeEntry = null;
        this.errorMessage = null;
        this.isSetup = true;
        return returnVal;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(PaletteMessages.CUSTOMIZE_DIALOG_TITLE);
        super.configureShell(newShell);
    }

    protected Button createButton(Composite parent, int id, String label, int stylebits, ImageDescriptor descriptor) {
        Button button = new Button(parent, stylebits);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData(256);
        button.setLayoutData((Object)data);
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PaletteCustomizerDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        this.widgets.put(new Integer(id), button);
        if (descriptor != null) {
            button.setImage(new Image((Device)parent.getDisplay(), descriptor.getImageData()));
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Image img = ((Button)e.getSource()).getImage();
                    if (img != null && !img.isDisposed()) {
                        img.dispose();
                    }
                }
            });
        }
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1025, PaletteMessages.APPLY_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        List children;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        Control child = this.createOutline(composite);
        GridData data = new GridData(16);
        data.verticalSpan = 2;
        child.setLayoutData((Object)data);
        child = this.createPropertiesPanel(composite);
        child.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        if (this.initialSelection == null && !(children = this.getPaletteRoot().getChildren()).isEmpty()) {
            this.initialSelection = (PaletteEntry)children.get(0);
        }
        if (this.initialSelection != null) {
            this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)this.initialSelection));
        } else {
            this.setActiveEntry(null);
        }
        this.isSetup = false;
        this.tree.setFocus();
        return composite;
    }

    protected Control createOutline(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setFont(container.getFont());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createOutlineToolBar(composite);
        this.treeviewer = this.createOutlineTreeViewer(composite);
        this.tree = this.treeviewer.getTree();
        this.tree.setMenu(this.createOutlineContextMenu());
        return composite;
    }

    protected List createOutlineActions() {
        ArrayList<PaletteCustomizationAction> actions = new ArrayList<PaletteCustomizationAction>();
        actions.add(new NewAction());
        actions.add(new DeleteAction());
        actions.add(new MoveDownAction());
        actions.add(new MoveUpAction());
        return actions;
    }

    protected Menu createOutlineContextMenu() {
        final MenuManager outlineMenu = new MenuManager();
        List actions = this.getOutlineActions();
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            IAction action = (IAction)iter.next();
            if (action instanceof IMenuCreator) {
                outlineMenu.add((IContributionItem)new ActionContributionItem(action){

                    public boolean isDynamic() {
                        return true;
                    }
                });
            } else {
                outlineMenu.add(action);
            }
            if (!(action instanceof NewAction) && !(action instanceof DeleteAction)) continue;
            outlineMenu.add((IContributionItem)new Separator());
        }
        outlineMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                outlineMenu.update(true);
            }
        });
        outlineMenu.createContextMenu((Control)this.tree);
        return outlineMenu.getMenu();
    }

    protected Control createOutlineToolBar(Composite parent) {
        final Composite composite = new Composite(parent, 0){

            public Rectangle getClientArea() {
                Rectangle area = super.getClientArea();
                area.x += 2;
                area.y += 2;
                area.height -= 2;
                area.width -= 4;
                return area;
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                size.x += 4;
                size.y += 2;
                return size;
            }
        };
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new FillLayout());
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle area = composite.getBounds();
                GC gc = e.gc;
                gc.setLineStyle(1);
                gc.setForeground(ColorConstants.buttonDarker);
                gc.drawLine(area.x, area.y, area.x + area.width - 2, area.y);
                gc.drawLine(area.x, area.y, area.x, area.y + area.height - 1);
                gc.drawLine(area.x + area.width - 2, area.y, area.x + area.width - 2, area.y + area.height - 1);
                gc.setForeground(ColorConstants.buttonLightest);
                gc.drawLine(area.x + 1, area.y + 1, area.x + area.width - 3, area.y + 1);
                gc.drawLine(area.x + area.width - 1, area.y + 1, area.x + area.width - 1, area.y + area.height - 1);
                gc.drawLine(area.x + 1, area.y + 1, area.x + 1, area.y + area.height - 1);
            }
        });
        ToolBarManager tbMgr = new ToolBarManager(0x800100);
        List actions = this.getOutlineActions();
        int i = 0;
        while (i < actions.size()) {
            tbMgr.add((IContributionItem)new ToolbarDropdownContributionItem((IAction)actions.get(i)));
            ++i;
        }
        tbMgr.createControl(composite);
        tbMgr.getControl().setFont(composite.getFont());
        ToolItem[] items = tbMgr.getControl().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            ToolItem item = items[i2];
            item.setText(((IAction)actions.get(i2)).getText());
            ++i2;
        }
        return tbMgr.getControl();
    }

    protected TreeViewer createOutlineTreeViewer(Composite composite) {
        Tree treeForViewer = new Tree(composite, 2048);
        treeForViewer.setFont(composite.getFont());
        GridData data = new GridData(1296);
        data.widthHint = 185;
        data.heightHint = 200;
        treeForViewer.setLayoutData((Object)data);
        TreeViewer viewer = new TreeViewer(treeForViewer){

            protected void preservingSelection(Runnable updateCode) {
                if ((this.getTree().getStyle() & 4) != 0) {
                    updateCode.run();
                } else {
                    super.preservingSelection(updateCode);
                }
            }
        };
        viewer.setContentProvider((IContentProvider)new PaletteTreeProvider(viewer));
        this.treeViewerLabelProvider = new PaletteLabelProvider(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)this.treeViewerLabelProvider);
        viewer.setInput((Object)this.getPaletteRoot());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PaletteCustomizerDialog.this.handleOutlineSelectionChanged();
            }
        });
        return viewer;
    }

    protected Control createPropertiesPanel(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setFont(container.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.titleSwitcher = this.createPropertiesPanelTitle(composite);
        this.propertiesPanelContainer = new PageBook(composite, 0);
        this.propertiesPanelContainer.setFont(composite.getFont());
        GridData data = new GridData(1296);
        data.horizontalSpan = 2;
        this.propertiesPanelContainer.setLayoutData((Object)data);
        this.propertiesPanelContainer.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (PaletteCustomizerDialog.this.activePage != null) {
                    PaletteCustomizerDialog.this.propertiesPanelContainer.layout();
                }
            }
        });
        return composite;
    }

    protected PageBook createPropertiesPanelTitle(Composite parent) {
        PageBook book = new PageBook(parent, 0);
        book.setFont(parent.getFont());
        book.setLayoutData((Object)new GridData(784));
        this.titlePage = new Composite((Composite)book, 0);
        this.titlePage.setFont(book.getFont());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.titlePage.setLayout((Layout)layout);
        this.title = this.createSectionTitle(this.titlePage, PaletteMessages.NO_SELECTION_TITLE);
        this.errorPage = new Composite((Composite)book, 0);
        this.errorPage.setFont(book.getFont());
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.errorPage.setLayout((Layout)layout);
        Composite intermediary = new Composite(this.errorPage, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle bounds = PaletteCustomizerDialog.this.title.getBounds();
                return new Point(bounds.width, bounds.height);
            }
        };
        intermediary.setLayoutData((Object)new GridData(784));
        StackLayout stackLayout = new StackLayout();
        intermediary.setLayout((Layout)stackLayout);
        this.errorTitle = new MultiLineLabel(intermediary);
        stackLayout.topControl = this.errorTitle;
        this.errorTitle.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.errorTitle.setFont(this.errorPage.getFont());
        Label separator = new Label(this.errorPage, 258);
        separator.setLayoutData((Object)new GridData(768));
        book.showPage((Control)this.titlePage);
        return book;
    }

    protected CLabel createSectionTitle(Composite composite, String text) {
        CLabel cTitle = new CLabel(composite, 16384);
        Color background = JFaceColors.getBannerBackground((Display)composite.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)composite.getDisplay());
        JFaceColors.setColors((Control)cTitle, (Color)foreground, (Color)background);
        cTitle.setFont(JFaceResources.getBannerFont());
        cTitle.setText(text);
        cTitle.setLayoutData((Object)new GridData(784));
        if (this.titleImage == null) {
            Display display = composite.getDisplay();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.titleImage = new Image((Device)display, ImageDescriptor.createFromFile((Class)clazz, (String)"icons/customizer_dialog_title.gif").getImageData());
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PaletteCustomizerDialog.this.titleImage.dispose();
                    PaletteCustomizerDialog.this.titleImage = null;
                }
            });
        }
        Label imageLabel = new Label(composite, 16384);
        imageLabel.setBackground(background);
        imageLabel.setImage(this.titleImage);
        imageLabel.setLayoutData((Object)new GridData(272));
        Label separator = new Label(composite, 258);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        return cTitle;
    }

    protected Button getButton(int id) {
        Button button = null;
        Widget widget = this.getWidget(id);
        if (widget instanceof Button) {
            button = (Button)widget;
        }
        return button;
    }

    protected PaletteCustomizer getCustomizer() {
        return this.customizer;
    }

    protected EntryPage getEntryPage(PaletteEntry entry) {
        if (entry == null) {
            return null;
        }
        if (this.entriesToPages.containsKey(entry)) {
            return (EntryPage)this.entriesToPages.get(entry);
        }
        EntryPage page = this.getCustomizer().getPropertiesPage(entry);
        if (page == null) {
            page = new DefaultEntryPage();
        }
        page.createControl((Composite)this.propertiesPanelContainer, entry);
        page.setPageContainer(this);
        this.entriesToPages.put(entry, page);
        return page;
    }

    protected final List getOutlineActions() {
        if (this.actions == null) {
            this.actions = this.createOutlineActions();
        }
        return this.actions;
    }

    protected PaletteRoot getPaletteRoot() {
        return this.root;
    }

    protected PaletteEntry getSelectedPaletteEntry() {
        TreeItem item = this.getSelectedTreeItem();
        if (item != null) {
            return (PaletteEntry)item.getData();
        }
        return null;
    }

    protected TreeItem getSelectedTreeItem() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length > 0) {
            return items[0];
        }
        return null;
    }

    protected Widget getWidget(int id) {
        Widget widget = (Widget)this.widgets.get(new Integer(id));
        if (widget == null) {
            widget = super.getButton(id);
        }
        return widget;
    }

    protected final void handleApplyPressed() {
        this.save();
    }

    protected void handleDelete() {
        this.getCustomizer().performDelete(this.getSelectedPaletteEntry());
        this.handleOutlineSelectionChanged();
    }

    protected void handleMoveDown() {
        PaletteEntry entry = this.getSelectedPaletteEntry();
        this.getCustomizer().performMoveDown(entry);
        this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)entry), true);
        this.updateActions();
    }

    protected void handleMoveUp() {
        PaletteEntry entry = this.getSelectedPaletteEntry();
        this.getCustomizer().performMoveUp(entry);
        this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)entry), true);
        this.updateActions();
    }

    protected void handleOutlineSelectionChanged() {
        PaletteEntry entry = this.getSelectedPaletteEntry();
        if (this.activeEntry == entry) {
            return;
        }
        if (this.errorMessage != null) {
            MessageDialog dialog = new MessageDialog(this.getShell(), PaletteMessages.ERROR, null, String.valueOf(PaletteMessages.ABORT_PAGE_FLIPPING_MESSAGE) + "\n" + this.errorMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            this.treeviewer.addPostSelectionChangedListener(this.pageFlippingPreventer);
        } else {
            this.setActiveEntry(entry);
        }
        this.updateActions();
    }

    protected void revertToSaved() {
        this.getCustomizer().revertToSaved();
    }

    protected void save() {
        if (this.activePage != null) {
            this.activePage.apply();
        }
        this.getCustomizer().save();
    }

    protected void setActiveEntry(PaletteEntry entry) {
        if (this.activeEntry != null) {
            this.activeEntry.removePropertyChangeListener(this.titleUpdater);
        }
        this.activeEntry = entry;
        if (entry != null) {
            this.title.setText(entry.getLabel());
            Image img = this.treeViewerLabelProvider.getImage((Object)entry);
            if (img == null) {
                img = this.getSelectedTreeItem().getImage();
            }
            this.title.setImage(img);
            entry.addPropertyChangeListener(this.titleUpdater);
            EntryPage panel = this.getEntryPage(entry);
            this.setActiveEntryPage(panel);
        } else {
            this.title.setImage(null);
            this.title.setText(PaletteMessages.NO_SELECTION_TITLE);
            if (this.noSelectionPage == null) {
                this.noSelectionPage = new EntryPage(){
                    private Text text;

                    public void apply() {
                    }

                    public void createControl(Composite parent, PaletteEntry entry) {
                        this.text = new Text(parent, 8);
                        this.text.setFont(parent.getFont());
                        this.text.setText(PaletteMessages.NO_SELECTION_MADE);
                    }

                    public Control getControl() {
                        return this.text;
                    }

                    public void setPageContainer(EntryPageContainer pageContainer) {
                    }
                };
                this.noSelectionPage.createControl((Composite)this.propertiesPanelContainer, null);
            }
            this.setActiveEntryPage(this.noSelectionPage);
        }
    }

    protected void setActiveEntryPage(EntryPage page) {
        if (this.activePage != null) {
            this.activePage.apply();
        }
        if (page == null) {
            this.propertiesPanelContainer.setVisible(false);
        } else {
            Point oldSize = this.getShell().getSize();
            this.propertiesPanelContainer.showPage(page.getControl());
            if (!this.isSetup) {
                Point newSize = this.getShell().computeSize(-1, -1, true);
                int x = newSize.x - oldSize.x;
                x = x < 0 ? 0 : x;
                int y = newSize.y - oldSize.y;
                int n = y = y < 0 ? 0 : y;
                if (x > 0 || y > 0) {
                    this.getShell().setSize(oldSize.x + x, oldSize.y + y);
                }
            }
            if (!this.propertiesPanelContainer.isVisible()) {
                this.propertiesPanelContainer.setVisible(true);
            }
        }
        this.activePage = page;
    }

    public void setDefaultSelection(PaletteEntry entry) {
        this.initialSelection = entry;
    }

    public void showProblem(String error) {
        Assert.isNotNull((Object)error);
        this.errorTitle.setText(error);
        this.titleSwitcher.showPage((Control)this.errorPage);
        this.getButton(0).setEnabled(false);
        this.getButton(1025).setEnabled(false);
        this.errorMessage = error;
    }

    protected void updateActions() {
        List actions = this.getOutlineActions();
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            PaletteCustomizationAction action = (PaletteCustomizationAction)((Object)iter.next());
            action.update();
        }
    }

    private class DeleteAction
    extends PaletteCustomizationAction {
        public DeleteAction() {
            this.setEnabled(false);
            this.setText(PaletteMessages.DELETE_LABEL);
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void run() {
            PaletteCustomizerDialog.this.handleDelete();
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = PaletteCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry != null) {
                enabled = PaletteCustomizerDialog.this.getCustomizer().canDelete(entry);
            }
            this.setEnabled(enabled);
        }
    }

    private class FactoryWrapperAction
    extends Action {
        private PaletteEntryFactory factory;

        public FactoryWrapperAction(PaletteEntryFactory factory) {
            this.factory = factory;
            this.setText(factory.getLabel());
            this.setImageDescriptor(factory.getImageDescriptor());
            this.setHoverImageDescriptor(factory.getImageDescriptor());
        }

        public boolean canCreate(PaletteEntry entry) {
            return this.factory.canCreate(entry);
        }

        public void run() {
            PaletteEntry selected = PaletteCustomizerDialog.this.getSelectedPaletteEntry();
            if (selected == null) {
                selected = PaletteCustomizerDialog.this.getPaletteRoot();
            }
            PaletteEntry newEntry = this.factory.createNewEntry(PaletteCustomizerDialog.this.getShell(), selected);
            PaletteCustomizerDialog.this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)newEntry), true);
            PaletteCustomizerDialog.this.updateActions();
        }
    }

    private class MoveDownAction
    extends PaletteCustomizationAction {
        public MoveDownAction() {
            this.setEnabled(false);
            this.setText(PaletteMessages.MOVE_DOWN_LABEL);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/next_nav.gif"));
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setDisabledImageDescriptor(ImageDescriptor.createFromFile((Class)clazz2, (String)"icons/move_down_disabled.gif"));
        }

        public void run() {
            PaletteCustomizerDialog.this.handleMoveDown();
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = PaletteCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry != null) {
                enabled = PaletteCustomizerDialog.this.getCustomizer().canMoveDown(entry);
            }
            this.setEnabled(enabled);
        }
    }

    private class MoveUpAction
    extends PaletteCustomizationAction {
        public MoveUpAction() {
            this.setEnabled(false);
            this.setText(PaletteMessages.MOVE_UP_LABEL);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/prev_nav.gif"));
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setDisabledImageDescriptor(ImageDescriptor.createFromFile((Class)clazz2, (String)"icons/move_up_disabled.gif"));
        }

        public void run() {
            PaletteCustomizerDialog.this.handleMoveUp();
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = PaletteCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry != null) {
                enabled = PaletteCustomizerDialog.this.getCustomizer().canMoveUp(entry);
            }
            this.setEnabled(enabled);
        }
    }

    private class NewAction
    extends PaletteCustomizationAction
    implements IMenuCreator {
        private List factories;
        private MenuManager menuMgr;

        public NewAction() {
            this.factories = this.wrap(PaletteCustomizerDialog.this.getCustomizer().getNewEntryFactories());
            if (this.factories.isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setMenuCreator(this);
            }
            this.setText(PaletteMessages.NEW_LABEL);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/add.gif"));
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.internal.Internal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setDisabledImageDescriptor(ImageDescriptor.createFromFile((Class)clazz2, (String)"icons/add-disabled.gif"));
        }

        private void addActionToMenu(Menu parent, IAction action) {
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(parent, -1);
        }

        public void dispose() {
            if (this.menuMgr != null) {
                this.menuMgr.dispose();
                this.menuMgr = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menuMgr == null) {
                this.menuMgr = new MenuManager();
                this.menuMgr.createContextMenu(parent);
            }
            this.updateMenuManager(this.menuMgr);
            return this.menuMgr.getMenu();
        }

        public Menu getMenu(Menu parent) {
            Menu menu = new Menu(parent);
            Iterator iter = this.factories.iterator();
            while (iter.hasNext()) {
                FactoryWrapperAction action = (FactoryWrapperAction)((Object)iter.next());
                if (!action.isEnabled()) continue;
                this.addActionToMenu(menu, (IAction)action);
            }
            return menu;
        }

        public void run() {
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = PaletteCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry == null) {
                entry = PaletteCustomizerDialog.this.getPaletteRoot();
            }
            Iterator iter = this.factories.iterator();
            while (iter.hasNext()) {
                FactoryWrapperAction action = (FactoryWrapperAction)((Object)iter.next());
                action.setEnabled(action.canCreate(entry));
                boolean bl = enabled = enabled || action.isEnabled();
            }
            this.setEnabled(enabled);
        }

        protected void updateMenuManager(MenuManager manager) {
            manager.removeAll();
            Iterator iter = this.factories.iterator();
            while (iter.hasNext()) {
                FactoryWrapperAction action = (FactoryWrapperAction)((Object)iter.next());
                if (!action.isEnabled()) continue;
                manager.add((IAction)action);
            }
        }

        private List wrap(List list) {
            ArrayList<FactoryWrapperAction> newList = new ArrayList<FactoryWrapperAction>();
            if (list != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    PaletteEntryFactory element = (PaletteEntryFactory)iter.next();
                    newList.add(new FactoryWrapperAction(element));
                }
            }
            return newList;
        }
    }
}

