/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class ERDExportFormatRegistry {
    private static final Log log = Log.getLog(ERDExportFormatRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.erd.ui.export.format";
    private static ERDExportFormatRegistry instance = null;
    private final List<FormatDescriptor> formats = new ArrayList<FormatDescriptor>();

    public static synchronized ERDExportFormatRegistry getInstance() {
        if (instance == null) {
            instance = new ERDExportFormatRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ERDExportFormatRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            FormatDescriptor formatDescriptor = new FormatDescriptor(ext);
            this.formats.add(formatDescriptor);
            ++n2;
        }
    }

    public List<FormatDescriptor> getFormats() {
        return this.formats;
    }

    public class FormatDescriptor
    extends AbstractDescriptor {
        private final String extension;
        private final String label;
        private final AbstractDescriptor.ObjectType type;

        protected FormatDescriptor(IConfigurationElement config) {
            super(config);
            this.extension = config.getAttribute("ext");
            this.label = config.getAttribute("label");
            this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        }

        public String getExtension() {
            return this.extension;
        }

        public String getLabel() {
            return this.label;
        }

        public ERDExportFormatHandler getInstance() throws DBException {
            return (ERDExportFormatHandler)this.type.createInstance(ERDExportFormatHandler.class);
        }
    }
}

