/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql;

import java.util.Properties;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.utils.CommonUtils;

public class SQLServerGSS {
    public static void initCredentials(DBPConnectionConfiguration connectionInfo, Properties properties) throws DBCException {
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            try {
                GSSManager gssManager = GSSManager.getInstance();
                GSSName name = gssManager.createName(connectionInfo.getUserName(), GSSName.NT_USER_NAME);
                GSSCredential impersonatedUserCredential = gssManager.createCredential(name, 0, (Oid)null, 2);
                properties.put("gsscredential", impersonatedUserCredential);
            }
            catch (GSSException e) {
                throw new DBCException("Error initializing GSS", (Throwable)e);
            }
        }
    }
}

