/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import org.jkiss.dbeaver.ext.greenplum.model.GreenplumTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;

public class GreenplumWithClauseBuilder {
    public static String generateWithClause(PostgreTable table, PostgreTableBase tableBase) {
        StringBuilder withClauseBuilder = new StringBuilder();
        if (GreenplumWithClauseBuilder.tableSupportsAndHasOids(table) && GreenplumWithClauseBuilder.tableIsGreenplumWithRelOptions(table, tableBase)) {
            withClauseBuilder.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
            String[] stringArray = tableBase.getRelOptions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                withClauseBuilder.append(String.format(",\n\t%s", option));
                ++n2;
            }
            withClauseBuilder.append("\n)");
        } else if (GreenplumWithClauseBuilder.tableSupportsAndHasOids(table)) {
            withClauseBuilder.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
            withClauseBuilder.append("\n)");
        } else if (GreenplumWithClauseBuilder.tableIsGreenplumWithRelOptions(table, tableBase)) {
            String[] options = tableBase.getRelOptions();
            withClauseBuilder.append(String.format("\nWITH (\n\t%s", options[0]));
            int i = 1;
            while (i < options.length) {
                String option = options[i];
                withClauseBuilder.append(String.format(",\n\t%s", option));
                ++i;
            }
            withClauseBuilder.append("\n)");
        }
        return withClauseBuilder.toString();
    }

    private static boolean tableSupportsAndHasOids(PostgreTable table) {
        return ((PostgreDataSource)table.getDataSource()).getServerType().supportsOids() && table.isHasOids();
    }

    private static boolean tableIsGreenplumWithRelOptions(PostgreTable table, PostgreTableBase tableBase) {
        return table instanceof GreenplumTable && tableBase.getRelOptions() != null;
    }
}

