/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class OracleTableColumnManager
extends SQLTableColumnManager<OracleTableColumn, OracleTableBase>
implements DBEObjectRenamer<OracleTableColumn> {
    protected final SQLTableColumnManager.ColumnModifier<OracleTableColumn> OracleDataTypeModifier = (monitor, column, sql, command) -> {
        OracleDataType dataType = column.getDataType();
        if (dataType != null) {
            String typeName = dataType.getTypeName();
            if (dataType.getDataKind() == DBPDataKind.STRING && column.isPersisted() && ("INTERVAL DAY TO SECOND".equals(typeName) || "INTERVAL YEAR TO MONTH".equals(typeName))) {
                Integer precision = column.getPrecision();
                if ("INTERVAL YEAR TO MONTH".equals(typeName) && precision != null) {
                    if (precision != 2) {
                        String patchedName = " INTERVAL YEAR(" + precision + ") TO MONTH";
                        sql.append(patchedName);
                        return;
                    }
                } else {
                    Integer scale = column.getScale();
                    if (scale != null) {
                        String patchedName = " INTERVAL DAY(" + precision + ") TO SECOND(" + scale + ")";
                        sql.append(patchedName);
                        return;
                    }
                }
            }
        }
        this.DataTypeModifier.appendModifier(monitor, column, sql, command);
    };

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableColumn> getObjectsCache(OracleTableColumn object) {
        return ((OracleSchema)((OracleTableBase)object.getParentObject()).getContainer()).tableCache.getChildrenCache((OracleTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(OracleTableColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[]{this.OracleDataTypeModifier, this.DefaultModifier, this.NullNotNullModifierConditional};
    }

    public boolean canEditObject(OracleTableColumn object) {
        return true;
    }

    protected OracleTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        OracleTableBase table = (OracleTableBase)container;
        DBSDataType columnType = OracleTableColumnManager.findBestDataType((DBSObject)table, (String[])new String[]{"varchar2"});
        OracleTableColumn column = new OracleTableColumn(table);
        column.setName(this.getNewColumnName(monitor, context, (DBSEntity)table));
        column.setDataType((OracleDataType)columnType);
        column.setTypeName(columnType == null ? "INTEGER" : columnType.getName());
        column.setMaxLength(columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0);
        column.setValueType(columnType == null ? 4 : columnType.getTypeID());
        column.setOrdinalPosition(-1);
        return column;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        if (command.getProperty((Object)"comment") != null) {
            OracleTableColumnManager.addColumnCommentAction((DBRProgressMonitor)new VoidProgressMonitor(), actions, (OracleTableColumn)command.getObject());
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        boolean hasComment;
        OracleTableColumn column = (OracleTableColumn)command.getObject();
        boolean bl = hasComment = command.getProperty((Object)"comment") != null;
        if (!hasComment || command.getProperties().size() > 1) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", "ALTER TABLE " + ((OracleTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY " + this.getNestedDeclaration(monitor, (DBSEntity)((OracleTableBase)column.getTable()), (DBECommandAbstract)command, options)));
        }
        if (hasComment) {
            OracleTableColumnManager.addColumnCommentAction((DBRProgressMonitor)new VoidProgressMonitor(), actionList, column);
        }
    }

    public static void addColumnCommentAction(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, OracleTableColumn column) {
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Comment column", "COMMENT ON COLUMN " + ((OracleTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBPDataSource)column.getDataSource(), (String)column.getComment(monitor))));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull OracleTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        OracleTableColumn column = (OracleTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((OracleTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }
}

