/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeMethod;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeModifier;
import org.jkiss.dbeaver.ext.oracle.model.OracleParameterMode;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSParameter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleDataTypeMethodParameter
implements DBSParameter {
    private final OracleDataTypeMethod method;
    private String name;
    private int number;
    private OracleParameterMode mode;
    private OracleDataType type;
    private OracleDataTypeModifier typeMod;

    public OracleDataTypeMethodParameter(DBRProgressMonitor monitor, OracleDataTypeMethod method, ResultSet dbResult) {
        this.method = method;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAM_NAME");
        this.number = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PARAM_NO");
        this.mode = OracleParameterMode.getMode(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAM_MODE"));
        this.type = OracleDataType.resolveDataType(monitor, method.getDataSource(), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAM_TYPE_OWNER"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAM_TYPE_NAME"));
        this.typeMod = OracleDataTypeModifier.resolveTypeModifier(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAM_TYPE_MOD"));
    }

    public DBSObject getParentObject() {
        return this.method;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.method.getDataSource();
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public int getNumber() {
        return this.number;
    }

    @Property(viewable=true, order=3)
    public OracleParameterMode getMode() {
        return this.mode;
    }

    @Property(id="dataType", viewable=true, order=4)
    public OracleDataType getType() {
        return this.type;
    }

    @Property(id="dataTypeMod", viewable=true, order=5)
    public OracleDataTypeModifier getTypeMod() {
        return this.typeMod;
    }

    @NotNull
    public DBSTypedObject getParameterType() {
        return this.type;
    }
}

