/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDependencyGroup;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedurePackaged;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class OraclePackage
extends OracleSchemaObject
implements OracleSourceObject,
DBPScriptObjectExt,
DBSObjectContainer,
DBSPackage,
DBPRefreshableObject,
DBSProcedureContainer {
    private static final Log log = Log.getLog(OraclePackage.class);
    private final ProceduresCache proceduresCache = new ProceduresCache();
    private boolean valid;
    private String sourceDeclaration;
    private String sourceDefinition;

    public OraclePackage(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME"), true);
        this.valid = "VALID".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
    }

    public OraclePackage(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    @Property(viewable=true, order=3)
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.PACKAGE;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBCException {
        if (this.sourceDeclaration == null && monitor != null) {
            this.sourceDeclaration = OracleUtils.getSource(monitor, this, false, true);
        }
        return this.sourceDeclaration;
    }

    public void setObjectDefinitionText(String sourceDeclaration) {
        this.sourceDeclaration = sourceDeclaration;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getExtendedDefinitionText(DBRProgressMonitor monitor) throws DBException {
        if (this.sourceDefinition == null && monitor != null) {
            this.sourceDefinition = OracleUtils.getSource(monitor, this, true, true);
        }
        return this.sourceDefinition;
    }

    public void setExtendedDefinitionText(String source) {
        this.sourceDefinition = source;
    }

    @Association
    public Collection<OracleDependencyGroup> getDependencies(DBRProgressMonitor monitor) {
        return OracleDependencyGroup.of(this);
    }

    @Association
    public Collection<OracleProcedurePackaged> getProceduresOnly(DBRProgressMonitor monitor) throws DBException {
        return this.getProcedures(monitor).stream().filter(proc -> proc.getProcedureType() == DBSProcedureType.PROCEDURE).collect(Collectors.toList());
    }

    @Association
    public Collection<OracleProcedurePackaged> getFunctionsOnly(DBRProgressMonitor monitor) throws DBException {
        return this.getProcedures(monitor).stream().filter(proc -> proc.getProcedureType() == DBSProcedureType.FUNCTION).collect(Collectors.toList());
    }

    @Association
    public Collection<OracleProcedurePackaged> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, this);
    }

    public OracleProcedurePackaged getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (OracleProcedurePackaged)this.proceduresCache.getObject(monitor, this, uniqueName);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, this);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.proceduresCache.getObject(monitor, this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return OracleProcedurePackaged.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.proceduresCache.getAllObjects(monitor, this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.proceduresCache.clearCache();
        this.sourceDeclaration = null;
        this.sourceDefinition = null;
        return this;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.PACKAGE) && OracleUtils.getObjectStatus(monitor, this, OracleObjectType.PACKAGE_BODY);
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        ArrayList<OracleObjectPersistAction> actions = new ArrayList<OracleObjectPersistAction>();
        actions.add(new OracleObjectPersistAction(OracleObjectType.PACKAGE, "Compile package", "ALTER PACKAGE " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE"));
        try {
            if (!CommonUtils.isEmpty((String)this.getExtendedDefinitionText(monitor))) {
                actions.add(new OracleObjectPersistAction(OracleObjectType.PACKAGE_BODY, "Compile package body", "ALTER PACKAGE " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE BODY"));
            }
        }
        catch (DBException e) {
            log.warn((Object)"Unable to retrieve package body, not compiling it", (Throwable)e);
        }
        return actions.toArray(new DBEPersistAction[0]);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    static class ProceduresCache
    extends JDBCObjectCache<OraclePackage, OracleProcedurePackaged> {
        ProceduresCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OraclePackage owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT P.*,CASE WHEN A.DATA_TYPE IS NULL THEN 'PROCEDURE' ELSE 'FUNCTION' END as PROCEDURE_TYPE FROM ALL_PROCEDURES P\nLEFT OUTER JOIN ALL_ARGUMENTS A ON A.OWNER=P.OWNER AND A.PACKAGE_NAME=P.OBJECT_NAME AND A.OBJECT_NAME=P.PROCEDURE_NAME AND A.ARGUMENT_NAME IS NULL AND A.DATA_LEVEL=0\nWHERE P.OWNER=? AND P.OBJECT_NAME=?\nORDER BY P.PROCEDURE_NAME");
            dbStat.setString(1, owner.getSchema().getName());
            dbStat.setString(2, owner.getName());
            return dbStat;
        }

        protected OracleProcedurePackaged fetchObject(@NotNull JDBCSession session, @NotNull OraclePackage owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleProcedurePackaged(owner, (ResultSet)dbResult);
        }

        protected void invalidateObjects(DBRProgressMonitor monitor, OraclePackage owner, Iterator<OracleProcedurePackaged> objectIter) {
            HashMap<String, OracleProcedurePackaged> overloads = new HashMap<String, OracleProcedurePackaged>();
            while (objectIter.hasNext()) {
                OracleProcedurePackaged proc = objectIter.next();
                if (CommonUtils.isEmpty((String)proc.getName())) {
                    objectIter.remove();
                    continue;
                }
                OracleProcedurePackaged overload = (OracleProcedurePackaged)overloads.get(proc.getName());
                if (overload == null) {
                    overloads.put(proc.getName(), proc);
                    continue;
                }
                if (overload.getOverloadNumber() == null) {
                    overload.setOverload(1);
                }
                proc.setOverload(overload.getOverloadNumber() + 1);
                overloads.put(proc.getName(), proc);
            }
        }
    }
}

