/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.dbeaver.model.runtime.BaseProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.IOUtils;

class DBeaverSettingsImporter {
    private static final String[] COPY_PLUGINS = new String[]{"org.eclipse.compare", "org.eclipse.core.resources", "org.eclipse.core.runtime", "org.eclipse.e4.ui.workbench.swt", "org.eclipse.equinox.p2.ui", "org.eclipse.equinox.security.ui", "org.eclipse.help.ui", "org.eclipse.search", "org.eclipse.ui.ide", "org.eclipse.ui.views.log", "org.eclipse.ui.workbench", "org.eclipse.ui.workbench.texteditor"};
    private final DBeaverApplication application;
    private final Display display;
    private Shell windowShell;
    private Label progressLabel;
    private ProgressBar progressBar;
    private File oldDriversFolder;
    private File driversFolder;
    private File oldWorkspacePath;
    private int shellResult = 0;

    public DBeaverSettingsImporter(DBeaverApplication application, Display display) {
        this.application = application;
        this.display = display;
    }

    boolean migrateFromPreviousVersion(final File oldDir, final File newDir) {
        String oldVersion;
        Properties workspaceProps = new Properties();
        File versionFile = new File(GeneralUtils.getMetadataFolder((File)oldDir), "dbeaver-workspace.properties");
        if (versionFile.exists()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream is = new FileInputStream(versionFile);){
                    workspaceProps.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        oldVersion = (oldVersion = workspaceProps.getProperty("product-version")) == null ? "3.x" : GeneralUtils.getPlainVersion((String)oldVersion);
        this.oldWorkspacePath = oldDir;
        this.oldDriversFolder = new File(System.getProperty("user.home"), ".dbeaver-drivers");
        this.driversFolder = new File(newDir.getParent(), "drivers");
        Image dbeaverIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.ui.app.standalone", (String)"icons/dbeaver32.png").createImage();
        Image dbeaverLogo = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.ui.app.standalone", (String)"icons/dbeaver64.png").createImage();
        WorkbenchPlugin.unsetSplashShell((Display)this.display);
        this.windowShell = new Shell(this.display);
        this.windowShell.setImage(dbeaverIcon);
        this.windowShell.setText("Import " + GeneralUtils.getProductName() + " configuration");
        this.windowShell.setLayout((Layout)new GridLayout(1, false));
        Group infoGroup = new Group((Composite)this.windowShell, 0);
        infoGroup.setText("Import workspace");
        infoGroup.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        infoGroup.setLayout((Layout)gl);
        Label iconLabel = new Label((Composite)infoGroup, 0);
        iconLabel.setImage(dbeaverLogo);
        iconLabel.setLayoutData((Object)new GridData(2));
        Label confirmLabel = new Label((Composite)infoGroup, 0);
        confirmLabel.setText("\n" + GeneralUtils.getProductTitle() + " uses a new configuration format.\n\n" + "Do you want to migrate existing settings (version " + oldVersion + ")?\n\n");
        confirmLabel.setLayoutData((Object)new GridData(1808));
        Composite buttonsPanel = new Composite((Composite)this.windowShell, 0);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        buttonsPanel.setLayout((Layout)new GridLayout(2, true));
        final Button migrateButton = new Button(buttonsPanel, 8);
        migrateButton.setText("Migrate (Recommended)");
        final Button skipButton = new Button(buttonsPanel, 8);
        skipButton.setText("Do not migrate");
        migrateButton.setLayoutData((Object)new GridData(768));
        migrateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                migrateButton.setEnabled(false);
                skipButton.setEnabled(false);
                DBeaverSettingsImporter.this.progressBar.setVisible(true);
                ((GridData)((DBeaverSettingsImporter)DBeaverSettingsImporter.this).progressBar.getLayoutData()).exclude = false;
                DBeaverSettingsImporter.this.windowShell.pack();
                DBeaverSettingsImporter.this.migrateWorkspace(oldDir, newDir);
            }
        });
        this.windowShell.setDefaultButton(migrateButton);
        skipButton.setLayoutData((Object)new GridData(768));
        skipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(DBeaverSettingsImporter.this.windowShell, 200);
                messageBox.setText("Skip workspace migration");
                messageBox.setMessage("You will lose all previous configurations and scripts.\n\nAre you sure?");
                int response = messageBox.open();
                if (response == 64) {
                    DBeaverSettingsImporter.this.shellResult = 2048;
                    DBeaverSettingsImporter.this.windowShell.dispose();
                }
            }
        });
        this.progressLabel = new Label((Composite)this.windowShell, 0);
        this.progressLabel.setLayoutData((Object)new GridData(1808));
        this.progressBar = new ProgressBar((Composite)this.windowShell, 65536);
        this.progressBar.setVisible(false);
        GridData gd = new GridData(1808);
        gd.heightHint = 30;
        gd.widthHint = 300;
        gd.exclude = true;
        this.progressBar.setLayoutData((Object)gd);
        this.windowShell.pack();
        Rectangle screenSize = this.display.getPrimaryMonitor().getBounds();
        this.windowShell.setLocation((screenSize.width - this.windowShell.getBounds().width) / 2, (screenSize.height - this.windowShell.getBounds().height) / 2);
        this.windowShell.open();
        while (!this.windowShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.shellResult != 0;
    }

    private void migrateWorkspace(File oldDir, File newDir) {
        this.progressLabel.setText("Counting workspace files...");
        long totalFiles = this.countWorkspaceFiles(oldDir);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum((int)((totalFiles += (long)this.countWorkspaceFiles(this.oldDriversFolder)) / 1000L));
        BaseProgressMonitor monitor = new BaseProgressMonitor(){
            long bytesProcessed = 0L;

            public void subTask(String name) {
                DBeaverSettingsImporter.this.display.syncExec(() -> DBeaverSettingsImporter.this.progressLabel.setText(name));
            }

            public void worked(int work) {
                DBeaverSettingsImporter.this.display.syncExec(() -> {
                    this.bytesProcessed += (long)work;
                    DBeaverSettingsImporter.this.progressBar.setSelection((int)(this.bytesProcessed / 1000L));
                });
            }
        };
        new Thread(() -> this.lambda$0(newDir, (DBRProgressMonitor)monitor, oldDir)).start();
    }

    private int countWorkspaceFiles(File dir) {
        int count = 1;
        File[] files = dir.listFiles();
        if (files == null) {
            return count;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            count = file.isDirectory() ? (count += this.countWorkspaceFiles(file)) : (int)((long)count + file.length());
            ++n2;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private void copyWorkspaceFiles(DBRProgressMonitor monitor, DIR_TYPE parentDirType, File fromDir, File toDir) {
        files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        skippedFiles = 0L;
        var11_7 = files;
        var10_8 = files.length;
        var9_9 = 0;
        while (var9_9 < var10_8) {
            block87: {
                block85: {
                    block88: {
                        block86: {
                            file = var11_7[var9_9];
                            dirType = DIR_TYPE.NORMAL;
                            var14_13 = fileName = file.getName();
                            tmp = -1;
                            switch (var14_13.hashCode()) {
                                case -1988530851: {
                                    if (var14_13.equals(".metadata")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case -1910732878: {
                                    if (var14_13.equals(".plugins")) {
                                        tmp = 2;
                                    }
                                    break;
                                }
                                case 2089097844: {
                                    if (var14_13.equals("org.jkiss.dbeaver.core")) {
                                        tmp = 3;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    if (parentDirType != DIR_TYPE.WORKSPACE) break;
                                    dirType = DIR_TYPE.METADATA;
                                    break;
                                }
                                case 2: {
                                    if (parentDirType != DIR_TYPE.METADATA) break;
                                    dirType = DIR_TYPE.PLUGINS;
                                    break;
                                }
                                case 3: {
                                    if (parentDirType != DIR_TYPE.PLUGINS) break;
                                    dirType = DIR_TYPE.CORE;
                                }
                            }
                            relPath = file.getAbsolutePath().substring(this.oldWorkspacePath.getAbsolutePath().length());
                            monitor.subTask(relPath);
                            if (!file.isDirectory()) break block85;
                            if (parentDirType != DIR_TYPE.METADATA || fileName.equals(".plugins") || fileName.equals("qmdb") || fileName.startsWith("dbeaver")) break block86;
                            skippedFiles += (long)this.countWorkspaceFiles(file);
                            break block87;
                        }
                        if (parentDirType != DIR_TYPE.PLUGINS || fileName.contains("dbeaver") || ArrayUtils.contains((Object[])DBeaverSettingsImporter.COPY_PLUGINS, (Object)fileName)) break block88;
                        skippedFiles += (long)this.countWorkspaceFiles(file);
                        break block87;
                    }
                    if (parentDirType != DIR_TYPE.CORE) ** GOTO lbl-1000
                    var16_15 = fileName;
                    tmp = -1;
                    switch (var16_15.hashCode()) {
                        case -934610874: {
                            if (var16_15.equals("remote")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 103670155: {
                            if (var16_15.equals("maven")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 1920363851: {
                            if (var16_15.equals("drivers")) {
                                tmp = 1;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            targetDir = new File(this.driversFolder, fileName);
                            if (!targetDir.exists() && !targetDir.mkdirs()) {
                                System.err.println("Can't create drivers folder " + targetDir.getAbsolutePath());
                                skippedFiles += (long)this.countWorkspaceFiles(file);
                            } else {
                                this.copyWorkspaceFiles(monitor, DIR_TYPE.NORMAL, file, targetDir);
                            }
                            break block87;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if ((newDir = new File(toDir, fileName)).exists() || newDir.mkdir()) {
                                this.copyWorkspaceFiles(monitor, dirType, file, newDir);
                                break;
                            }
                            System.err.println("Can't create folder " + newDir.getAbsolutePath());
                            break;
                        }
                    }
                    ** GOTO lbl197
                }
                if (parentDirType == DIR_TYPE.METADATA && fileName.startsWith(".")) {
                    ++skippedFiles;
                } else {
                    newFile = new File(toDir, fileName);
                    if (fileName.equals("org.jkiss.dbeaver.core.prefs")) {
                        coreProps = new Properties();
                        try {
                            var18_17 = null;
                            var19_24 = null;
                            try {
                                is = new FileInputStream(file);
                                try {
                                    coreProps.load(is);
                                }
                                finally {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                            }
                            catch (Throwable var19_25) {
                                if (var18_17 == null) {
                                    var18_17 = var19_25;
                                } else if (var18_17 != var19_25) {
                                    var18_17.addSuppressed(var19_25);
                                }
                                throw var18_17;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                        driversHomeProp = coreProps.getProperty("ui.drivers.home");
                        if (driversHomeProp != null && !driversHomeProp.isEmpty() && (oldDriversPath = new File((String)driversHomeProp)).equals(new File(this.oldWorkspacePath, ".metadata/.plugins/org.jkiss.dbeaver.core"))) {
                            coreProps.setProperty("ui.drivers.home", this.driversFolder.getAbsolutePath());
                        }
                        try {
                            oldDriversPath = null;
                            is = null;
                            try {
                                os = new FileOutputStream(newFile);
                                try {
                                    coreProps.store(os, null);
                                }
                                finally {
                                    if (os != null) {
                                        os.close();
                                    }
                                }
                            }
                            catch (Throwable is) {
                                if (oldDriversPath == null) {
                                    oldDriversPath = is;
                                } else if (oldDriversPath != is) {
                                    oldDriversPath.addSuppressed(is);
                                }
                                throw oldDriversPath;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    } else if (parentDirType == DIR_TYPE.CORE && fileName.equals("drivers.xml")) {
                        driversText = null;
                        try {
                            driversHomeProp = null;
                            var19_24 = null;
                            try {
                                r = new InputStreamReader((InputStream)new FileInputStream(file), GeneralUtils.UTF8_CHARSET);
                                try {
                                    driversText = IOUtils.readToString((Reader)r);
                                    driversText = driversText.replace("${workspace}\\.metadata\\.plugins\\org.jkiss.dbeaver.core", "${drivers_home}");
                                    driversText = driversText.replace("${workspace}/.metadata/.plugins/org.jkiss.dbeaver.core", "${drivers_home}");
                                }
                                finally {
                                    if (r != null) {
                                        r.close();
                                    }
                                }
                            }
                            catch (Throwable var19_28) {
                                if (driversHomeProp == null) {
                                    driversHomeProp = var19_28;
                                } else if (driversHomeProp != var19_28) {
                                    driversHomeProp.addSuppressed(var19_28);
                                }
                                throw driversHomeProp;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                        if (driversText != null) {
                            try {
                                e = null;
                                var19_24 = null;
                                try {
                                    w = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), GeneralUtils.UTF8_CHARSET);
                                    try {
                                        w.write(driversText);
                                    }
                                    finally {
                                        if (w != null) {
                                            w.close();
                                        }
                                    }
                                }
                                catch (Throwable var19_29) {
                                    if (e == null) {
                                        e = var19_29;
                                    } else if (e != var19_29) {
                                        e.addSuppressed(var19_29);
                                    }
                                    throw e;
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    } else {
                        this.copyFileContents(file, newFile);
                    }
                    monitor.worked((int)(file.length() + skippedFiles));
                }
            }
            ++var9_9;
        }
    }

    private void copyFolderFiles(DBRProgressMonitor monitor, File fromDir, File toDir) {
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            monitor.subTask(file.getName());
            if (file.isDirectory()) {
                File newDir = new File(toDir, file.getName());
                if (newDir.exists() || newDir.mkdirs()) {
                    this.copyFolderFiles(monitor, file, newDir);
                } else {
                    System.err.println("Can't create folder " + newDir.getAbsolutePath());
                }
            } else {
                this.copyFileContents(file, new File(toDir, file.getName()));
                monitor.worked((int)file.length());
            }
            ++n2;
        }
    }

    private void copyFileContents(File file, File newFile) {
        if (!newFile.exists() || newFile.length() != file.length()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (FileOutputStream os = new FileOutputStream(newFile);){
                        IOUtils.fastCopy((InputStream)is, (OutputStream)os, (int)100000);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private int showMessageBox(String title, String message, int style) {
        MessageBox messageBox = new MessageBox(this.windowShell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        return messageBox.open();
    }

    private /* synthetic */ void lambda$0(File file, DBRProgressMonitor dBRProgressMonitor, File file2) {
        block3: {
            try {
                if (file.exists() || file.mkdirs()) break block3;
                System.err.println("Can't create target workspace directory '" + file.getAbsolutePath() + "'");
                DBeaverApplication.WORKSPACE_MIGRATED = true;
            }
            catch (Throwable throwable) {
                DBeaverApplication.WORKSPACE_MIGRATED = true;
                this.display.syncExec(new Runnable(file){
                    private final /* synthetic */ File val$newDir;
                    {
                        this.val$newDir = file;
                    }

                    @Override
                    public void run() {
                        DBeaverSettingsImporter.this.showMessageBox("Import completed", "Configuration was imported to '" + this.val$newDir.getAbsolutePath() + "'", 34);
                        DBeaverSettingsImporter.this.shellResult = 32;
                        DBeaverSettingsImporter.this.windowShell.dispose();
                    }
                });
                throw throwable;
            }
            this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        this.copyWorkspaceFiles(dBRProgressMonitor, DIR_TYPE.WORKSPACE, file2, file);
        this.copyFolderFiles(dBRProgressMonitor, this.oldDriversFolder, this.driversFolder);
        DBeaverApplication.WORKSPACE_MIGRATED = true;
        this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
    }

    static enum DIR_TYPE {
        WORKSPACE,
        NORMAL,
        METADATA,
        PLUGINS,
        CORE;

    }
}

