/*
 * Decompiled with CFR 0.152.
 */
package org.cts.datum;

import java.util.HashMap;
import java.util.Map;
import org.cts.Identifier;
import org.cts.cs.GeographicExtent;
import org.cts.datum.AbstractDatum;
import org.cts.datum.Ellipsoid;
import org.cts.datum.GeodeticDatum;
import org.cts.datum.PrimeMeridian;
import org.cts.op.CoordinateOperation;
import org.cts.op.Identity;
import org.cts.op.transformation.Altitude2EllipsoidalHeight;
import org.slf4j.LoggerFactory;

public class VerticalDatum
extends AbstractDatum {
    public static final Map<String, VerticalDatum> datumFromName = new HashMap<String, VerticalDatum>();
    public static final VerticalDatum WGS84VD = new VerticalDatum(new Identifier("EPSG", "5030", "WGS84 Ellipsoid Surface", "WGS84VD"), "Surface of the reference Ellipsoid for WGS 1984", "1984", Ellipsoid.WGS84);
    public static final VerticalDatum SPHEREVD = new VerticalDatum(new Identifier("EPSG", "5035", "SPHERE Ellipsoid Surface", "SPHEREVD"), "Surface of the reference Ellipsoid for SPHERE", "", Ellipsoid.SPHERE);
    public static final VerticalDatum GRS80VD = new VerticalDatum(new Identifier("EPSG", "5019", "GRS80 Ellipsoid Surface", "GRS80VD"), "Surface of the reference Ellipsoid for GRS80", "", Ellipsoid.GRS80);
    public static final VerticalDatum INTERNATIONAL1924VD = new VerticalDatum(new Identifier("EPSG", "5022", "INTERNATIONAL1924 Ellipsoid Surface", "INTERNATIONAL1924VD"), "Surface of the reference Ellipsoid for INTERNATIONAL1924", "", Ellipsoid.INTERNATIONAL1924);
    public static final VerticalDatum BESSEL1841VD = new VerticalDatum(new Identifier("EPSG", "5004", "BESSEL1841 Ellipsoid Surface", "BESSEL1841VD"), "Surface of the reference Ellipsoid for BESSEL1841", "", Ellipsoid.BESSEL1841);
    public static final VerticalDatum CLARKE1866VD = new VerticalDatum(new Identifier("EPSG", "5008", "CLARKE1866 Ellipsoid Surface", "CLARKE1866VD"), "Surface of the reference Ellipsoid for CLARKE1866", "", Ellipsoid.CLARKE1866);
    public static final VerticalDatum CLARKE1880IGNVD = new VerticalDatum(new Identifier("EPSG", "5011", "CLARKE1880IGN Ellipsoid Surface", "CLARKE1880IGNVD"), "Surface of the reference Ellipsoid for CLARKE1880IGN", "", Ellipsoid.CLARKE1880IGN);
    public static final VerticalDatum CLARKE1880RGSVD = new VerticalDatum(new Identifier("EPSG", "5012", "CLARKE1880RGS Ellipsoid Surface", "CLARKE1880RGSVD"), "Surface of the reference Ellipsoid for CLARKE1880RGS", "", Ellipsoid.CLARKE1880RGS);
    public static final VerticalDatum CLARKE1880ARCVD = new VerticalDatum(new Identifier("EPSG", "5013", "CLARKE1880ARC Ellipsoid Surface", "CLARKE1880ARCVD"), "Surface of the reference Ellipsoid for CLARKE1880ARC", "", Ellipsoid.CLARKE1880ARC);
    public static final VerticalDatum KRASSOWSKIVD = new VerticalDatum(new Identifier("EPSG", "5024", "KRASSOWSKI Ellipsoid Surface", "KRASSOWSKIVD"), "Surface of the reference Ellipsoid for KRASSOWSKI", "", Ellipsoid.KRASSOWSKI);
    public static final VerticalDatum EVERESTSSVD = new VerticalDatum(new Identifier("EPSG", "5016", "SPHERE Ellipsoid Surface", "EVERESTSSVD"), "Surface of the reference Ellipsoid for EVERESTSS", "", Ellipsoid.EVERESTSS);
    public static final VerticalDatum GRS67VD = new VerticalDatum(new Identifier("EPSG", "5036", "GRS67 Ellipsoid Surface", "GRS67VD"), "Surface of the reference Ellipsoid for GRS67", "", Ellipsoid.GRS67);
    public static final VerticalDatum AustSAVD = new VerticalDatum(new Identifier("EPSG", "5050", "AustSA Ellipsoid Surface", "AustSAVD"), "Surface of the reference Ellipsoid for AustSA", "", Ellipsoid.AustSA);
    public static final VerticalDatum AIRYVD = new VerticalDatum(new Identifier("EPSG", "5001", "AIRY Ellipsoid Surface", "AIRYVD"), "Surface of the reference Ellipsoid for AIRY", "", Ellipsoid.AIRY);
    public static final VerticalDatum BESSNAMVD = new VerticalDatum(new Identifier("EPSG", "5046", "BESSNAM Ellipsoid Surface", "BESSNAMVD"), "Surface of the reference Ellipsoid for BESSNAM", "", Ellipsoid.BESSNAM);
    public static final VerticalDatum HELMERTVD = new VerticalDatum(new Identifier("EPSG", "5020", "HELMERT Ellipsoid Surface", "HELMERTVD"), "Surface of the reference Ellipsoid for HELMERT", "", Ellipsoid.HELMERT);
    public static final VerticalDatum AIRYMODVD = new VerticalDatum(new Identifier("EPSG", "5002", "AIRYMOD Ellipsoid Surface", "AIRYMODVD"), "Surface of the reference Ellipsoid for AIRYMOD", "", Ellipsoid.AIRYMOD);
    public static final VerticalDatum WGS66VD = new VerticalDatum(new Identifier("EPSG", "5025", "WGS66 Ellipsoid Surface", "WGS66VD"), "Surface of the reference Ellipsoid for WGS66", "", Ellipsoid.WGS66);
    public static final VerticalDatum WGS72VD = new VerticalDatum(new Identifier("EPSG", "5043", "WGS72 Ellipsoid Surface", "WGS72VD"), "Surface of the reference Ellipsoid for WGS72", "", Ellipsoid.WGS72);
    public static final VerticalDatum EGM2008 = new VerticalDatum(new Identifier("EPSG", "????", "EGM2008", "EGM2008"), new GeographicExtent("France", 42.0, 51.5, -5.5, 8.5), "", "2008", Type.GEOIDAL, "egm08fr.mnt", GeodeticDatum.WGS84);
    public static final VerticalDatum IGN69 = new VerticalDatum(new Identifier("EPSG", "5119", "Nivellement general de la France - IGN69", "IGN69"), new GeographicExtent("France", 42.0, 51.5, -5.5, 8.5), "Mean sea level at Marseille.", "1969", Type.GEOIDAL, "RAF09.txt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN78 = new VerticalDatum(new Identifier("EPSG", "5120", "Nivellement general de la France - IGN78", "IGN78"), new GeographicExtent("Corse (France)", 41.2, 43.2, 8.41666666666666, 9.71666666666666), "", "", Type.GEOIDAL, "RAC09.txt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN88GTBT = new VerticalDatum(new Identifier("EPSG", "5155", "Geoide g\u00e9om\u00e9trique pour Grande-Terre & Basse-Terre (EGM2008 + points GPS nivel\u00e9s)", "IGN88GTBT"), new GeographicExtent("Guadeloupe", 15.875, 16.625, -61.9, -61.075), "", "", Type.GEOIDAL, "gg10_gtbt.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN92LD = new VerticalDatum(new Identifier("EPSG", "5212", "Geoide g\u00e9om\u00e9trique pour La D\u00e9sirade (EGM2008 + points GPS nivel\u00e9s)", "IGN92LD"), new GeographicExtent("La D\u00e9sirade", 16.25, 16.4, -61.2, -60.75), "", "", Type.GEOIDAL, "gg10_ld.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN88LS = new VerticalDatum(new Identifier("EPSG", "5210", "Geoide g\u00e9om\u00e9trique pour Les Saintes (EGM2008 + points GPS nivel\u00e9s)", "IGN88LS"), new GeographicExtent("Les Saintes", 15.8, 15.925, -61.7, -61.475), "", "", Type.GEOIDAL, "gg10_ls.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN87MART = new VerticalDatum(new Identifier("EPSG", "5154", "Martinique 1987", "IGN87MART"), new GeographicExtent("Martinique", 14.3, 15.0, -61.3, -60.725), "", "", Type.GEOIDAL, "gg10_mart.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN88MG = new VerticalDatum(new Identifier("EPSG", "5211", "Geoide g\u00e9om\u00e9trique pour Marie-Galante (EGM2008 + points GPS nivel\u00e9s)", "IGN88MG"), new GeographicExtent("Marie-Galante", 15.8, 16.125, -61.4, -61.075), "", "", Type.GEOIDAL, "gg10_mg.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN88SB = new VerticalDatum(new Identifier("EPSG", "5213", "Geoide g\u00e9om\u00e9trique pour Saint-Barth\u00e9l\u00e9my (EGM2008 + points GPS nivel\u00e9s)", "IGN88SB"), new GeographicExtent("Saint-Barth\u00e9l\u00e9my", 17.8, 18.025, -63.0, -62.725), "", "", Type.GEOIDAL, "gg10_sb.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN88SM = new VerticalDatum(new Identifier("EPSG", "5214", "Geoide g\u00e9om\u00e9trique pour Saint-Martin (EGM2008 + points GPS nivel\u00e9s)", "IGN88SM"), new GeographicExtent("Saint-Martin", 18.0, 18.2, -63.2, -62.9), "", "", Type.GEOIDAL, "gg10_sm.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum NGG77GUY = new VerticalDatum(new Identifier("EPSG", "5153", "Nivellement General Guyanais 1977", "NGG77GUY"), new GeographicExtent("Guyane", 2.0, 6.0, -55.0, -51.0), "", "", Type.GEOIDAL, "ggguy00.txt", GeodeticDatum.RGF93);
    public static final VerticalDatum SHOM53 = new VerticalDatum(new Identifier(VerticalDatum.class, "Mayotte SHOM 1953 dans RGM04", "SHOM53"), new GeographicExtent("Mayotte", -13.095, -12.42, 44.91, 45.405), "", "", Type.GEOIDAL, "ggm04v1.txt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN62KER = new VerticalDatum(new Identifier(VerticalDatum.class, "G\u00e9o\u00efde g\u00e9om\u00e9trique Kerguelen (EGM2008 + Points GPS nivel\u00e9s)", "IGN62KER"), new GeographicExtent("Kerguelen", 67.0, 71.0, -50.5, -48.0), "", "", Type.GEOIDAL, "ggker08v2.txt", GeodeticDatum.RGF93);
    public static final VerticalDatum DANGER50 = new VerticalDatum(new Identifier("EPSG", "5190", "G\u00e9o\u00efde g\u00e9om\u00e9trique Saint Pierre et Miquelon (EGM96 + Points GPS nivel\u00e9s)", "DANGER50"), new GeographicExtent("Saint Pierre et Miquelon", -56.52, -55.935, 46.485, 47.295), "", "", Type.GEOIDAL, "ggspm06v1.txt", GeodeticDatum.RGF93);
    public static final VerticalDatum BORASAU01 = new VerticalDatum(new Identifier("EPSG", "5202", "Bora Bora SAU 2001", "BORASAU01"), new GeographicExtent("Bora", -152.0, -151.5, -16.75, -16.25), "", "", Type.GEOIDAL, "ggpf02-Bora.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum FAKARAVA = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Fakarava dans RGPF", "FAKARAVA"), new GeographicExtent("Fakarava", -145.9, -145.3, -16.65, -15.95), "", "", Type.GEOIDAL, "ggpf08-Fakarava.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum GAMBIER = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Gambier vers RGPF", "GAMBIER"), new GeographicExtent("Gambier", -135.25, -134.75, -23.4, -22.9), "", "", Type.GEOIDAL, "ggpf08-Gambier.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum HAO = new VerticalDatum(new Identifier(VerticalDatum.class, "Polynesie : Hao vers RGPF", "HAO"), new GeographicExtent("Hao", -141.2, -140.55, -18.55, -17.95), "", "", Type.GEOIDAL, "ggpf08-Hao.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum HIVAOA = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : HIVA OA dans RGPF", "HAO"), new GeographicExtent("Hao", -139.25, -138.675, -9.9, -9.6), "", "", Type.GEOIDAL, "ggpf05-HivaOa.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum HUAHINESAU01 = new VerticalDatum(new Identifier("EPSG", "5200", "Huahine SAU 2001", "HUAHINESAU01"), new GeographicExtent("Huahine", -151.5, -150.75, -17.0, -16.5), "", "", Type.GEOIDAL, "ggpf02-Huahine.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGNTAHITI66 = new VerticalDatum(new Identifier("EPSG", "5196", "Polyn\u00e9sie : IGN TAHITI 1966 dans RGPF", "IGNTAHITI66"), new GeographicExtent("Tahiti", -149.69, -149.0, -18.0, -17.0), "", "", Type.GEOIDAL, "ggpf10-Tahiti.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum MAIAO01 = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : MAIAO 2001 dans RGPF", "MAIAO01"), new GeographicExtent("Maiao", -150.75, -150.5, -17.75, -17.5), "", "", Type.GEOIDAL, "ggpf02-Maiao.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum MATAIVA = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Mataiva vers RGPF", "MATAIVA"), new GeographicExtent("Mataiva", -148.8, -148.55, -14.95, -14.8), "", "", Type.GEOIDAL, "ggpf08-Mataiva.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum MAUPITISAU01 = new VerticalDatum(new Identifier("EPSG", "5199", "Maupiti SAU 2001", "MAUPITISAU01"), new GeographicExtent("Maupiti", -152.5, -152.0, -16.75, -16.25), "", "", Type.GEOIDAL, "ggpf02-Maupiti.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum MOOREASAU81 = new VerticalDatum(new Identifier("EPSG", "5197", "Moorea SAU 1981", "MOOREASAU81"), new GeographicExtent("Moorea", -150.05, -149.65, -17.7, -17.35), "", "", Type.GEOIDAL, "ggpf10-Moorea.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum NUKUHIVA = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : NUKU HIVA ALTI dans RGPF", "NUKUHIVA"), new GeographicExtent("Nuku Hiva", -140.3, -139.9, -9.0, -8.675), "", "", Type.GEOIDAL, "ggpf05-Nuku.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum RAIATEASAU01 = new VerticalDatum(new Identifier("EPSG", "5198", "Raiatea SAU 2001", "RAIATEASAU01"), new GeographicExtent("Raiatea", -151.75, -151.25, -17.0, -16.5), "", "", Type.GEOIDAL, "ggpf02-Raiatea.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum RAIVAVAE = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Raivavae vers RGPF", "RAIVAVAE"), new GeographicExtent("Raicvavae", -147.8, -147.5, -24.0, -23.75), "", "", Type.GEOIDAL, "ggpf08-Raivavae.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum REAO = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Reao vers RGPF", "REAO"), new GeographicExtent("Reao", -136.55, -136.2, -18.65, -18.4), "", "", Type.GEOIDAL, "ggpf08-Reao.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum RURUTU = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Rurutu vers RGPF", "RURUTU"), new GeographicExtent("Rurutu", -151.45, -151.25, -22.6, -22.35), "", "", Type.GEOIDAL, "ggpf08-Rurutu.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum TAHAASAU01 = new VerticalDatum(new Identifier("EPSG", "5201", "Tahaa SAU 2001", "TAHAASAU01"), new GeographicExtent("Tahaa", -151.75, -151.25, -16.75, -16.5), "", "", Type.GEOIDAL, "ggpf02-Tahaa.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum TIKEHAU = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Tikehau vers RGPF", "TIKEHAU"), new GeographicExtent("Tikehau", -148.35, -147.95, -15.2, -14.85), "", "", Type.GEOIDAL, "ggpf08-Tikehau.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum TUBUAI = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Tubuai vers RGPF", "TUBUAI"), new GeographicExtent("Tubuai", -149.65, -149.3, -23.5, -23.25), "", "", Type.GEOIDAL, "ggpf08-Tubuai.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum TUPAI01 = new VerticalDatum(new Identifier(VerticalDatum.class, "Polyn\u00e9sie : Tubuai vers RGPF", "TUPAI01"), new GeographicExtent("Tupai", -152.0, -151.75, -16.5, -16.0), "", "", Type.GEOIDAL, "ggpf02-Tupai.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum RAR07 = new VerticalDatum(new Identifier(VerticalDatum.class, "R\u00e9f\u00e9rence des Altitudes R\u00e9unionnaises 2007", "RAR07"), new GeographicExtent("Reunion", 55.14, 55.94, -21.5, -20.75), "", "", Type.GEOIDAL, "RAR07.mnt", GeodeticDatum.RGF93);
    public static final VerticalDatum IGN88GTBTold = new VerticalDatum(new Identifier(VerticalDatum.class, "Geoide g\u00e9om\u00e9trique pour la Guadeloupe : Grande-Terre et Basse-Terre (EGM96 + points GPS nivel\u00e9s)", "IGN88GTBTold"), new GeographicExtent("Guadeloupe", 15.875, 16.625, -61.85, -61.075), "", "", Type.GEOIDAL, "ggg00.txt", GeodeticDatum.WGS84GUAD);
    public static final VerticalDatum IGN92LDold = new VerticalDatum(new Identifier(VerticalDatum.class, "Geoide g\u00e9om\u00e9trique pour La D\u00e9sirade (EGM96 + points GPS nivel\u00e9s)", "IGN92LDold"), new GeographicExtent("La D\u00e9sirade", 16.25, 16.4, -61.2, -60.75), "", "", Type.GEOIDAL, "ggg00_ld.txt", GeodeticDatum.WGS84GUAD);
    public static final VerticalDatum IGN88LSold = new VerticalDatum(new Identifier(VerticalDatum.class, "Geoide g\u00e9om\u00e9trique pour Les Saintes (EGM96 + points GPS nivel\u00e9s)", "IGN88LSold"), new GeographicExtent("Les Saintes", 15.8, 15.925, -61.7, -61.475), "", "", Type.GEOIDAL, "ggg00_ls.txt", GeodeticDatum.WGS84GUAD);
    public static final VerticalDatum IGN87MARTold = new VerticalDatum(new Identifier(VerticalDatum.class, "Geoide g\u00e9om\u00e9trique pour la Martinique (EGM96 + points GPS nivel\u00e9s)", "IGN87MARTold"), new GeographicExtent("Martinique", 14.25, 15.025, -61.25, -60.725), "", "", Type.GEOIDAL, "ggm00.txt", GeodeticDatum.WGS84MART);
    public static final VerticalDatum IGN88MGold = new VerticalDatum(new Identifier(VerticalDatum.class, "Geoide g\u00e9om\u00e9trique pour Marie-Galante (EGM96 + points GPS nivel\u00e9s)", "IGN88MGold"), new GeographicExtent("Marie-Galante", 15.8, 16.125, -61.4, -61.075), "", "", Type.GEOIDAL, "ggg00_mg.txt", GeodeticDatum.WGS84GUAD);
    public static final VerticalDatum IGN88SBold = new VerticalDatum(new Identifier(VerticalDatum.class, "Geoide g\u00e9om\u00e9trique pour Saint-Barth\u00e9l\u00e9my (EGM96 + points GPS nivel\u00e9s)", "IGN88SBold"), new GeographicExtent("Saint-Barth\u00e9l\u00e9my", 17.8, 18.025, -63.0, -62.725), "", "", Type.GEOIDAL, "ggg00_sb.txt", GeodeticDatum.WGS84SBSM);
    public static final VerticalDatum IGN88SMold = new VerticalDatum(new Identifier(VerticalDatum.class, "Geoide g\u00e9om\u00e9trique pour Saint-Martin (EGM96 + points GPS nivel\u00e9s)", "IGN88SMold"), new GeographicExtent("Saint-Martin", 18.0, 18.2, -63.2, -62.5), "", "", Type.GEOIDAL, "ggg00_sm.txt", GeodeticDatum.WGS84SBSM);
    private final Type type;
    private CoordinateOperation alti2ellpsHeight;
    private final Ellipsoid ellps;

    public VerticalDatum(Identifier identifier, GeographicExtent extent, String origin, String epoch, Type type, String altitudeGrid, GeodeticDatum gd) {
        super(identifier, extent, origin, epoch);
        this.type = type;
        if (gd != null && altitudeGrid != null) {
            try {
                this.alti2ellpsHeight = new Altitude2EllipsoidalHeight(altitudeGrid, gd);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(VerticalDatum.class).error(ex.getMessage());
            }
            this.ellps = gd.getEllipsoid();
        } else if (gd != null && type == Type.ELLIPSOIDAL) {
            this.alti2ellpsHeight = Identity.IDENTITY;
            this.ellps = gd.getEllipsoid();
        } else {
            this.alti2ellpsHeight = null;
            this.ellps = null;
        }
    }

    public VerticalDatum(Identifier identifier, String origin, String epoch, Ellipsoid ellps) {
        super(identifier, GeographicExtent.WORLD, origin, epoch);
        this.type = Type.ELLIPSOIDAL;
        this.alti2ellpsHeight = Identity.IDENTITY;
        this.ellps = ellps;
    }

    public Type getType() {
        return this.type;
    }

    public static Type getType(int numero) {
        switch (numero) {
            case 2000: {
                return Type.OTHER_SURFACE;
            }
            case 2001: {
                return Type.ORTHOMETRIC;
            }
            case 2002: {
                return Type.ELLIPSOIDAL;
            }
            case 2003: {
                return Type.BAROMETRIC;
            }
            case 2005: {
                return Type.GEOIDAL;
            }
            case 2006: {
                return Type.DEPTH;
            }
        }
        return null;
    }

    public static int getTypeNumber(Type type) {
        switch (type) {
            case OTHER_SURFACE: {
                return 2000;
            }
            case ORTHOMETRIC: {
                return 2001;
            }
            case ELLIPSOIDAL: {
                return 2002;
            }
            case BAROMETRIC: {
                return 2003;
            }
            case GEOIDAL: {
                return 2005;
            }
            case DEPTH: {
                return 2006;
            }
        }
        return 0;
    }

    public CoordinateOperation getAltiToEllpsHeight() {
        return this.alti2ellpsHeight;
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellps;
    }

    @Override
    public CoordinateOperation getToWGS84() {
        if (this.alti2ellpsHeight instanceof Altitude2EllipsoidalHeight) {
            Altitude2EllipsoidalHeight eH2A = (Altitude2EllipsoidalHeight)this.alti2ellpsHeight;
            return eH2A.getAssociatedDatum().getToWGS84();
        }
        return null;
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        if (this.alti2ellpsHeight instanceof Altitude2EllipsoidalHeight) {
            Altitude2EllipsoidalHeight eH2A = (Altitude2EllipsoidalHeight)this.alti2ellpsHeight;
            return eH2A.getAssociatedDatum().getPrimeMeridian();
        }
        return null;
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("VERT_DATUM[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(VerticalDatum.getTypeNumber(this.getType()));
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    static {
        datumFromName.put("ign69", IGN69);
        datumFromName.put("ign78", IGN78);
        datumFromName.put("egm2008", EGM2008);
        datumFromName.put("bora", BORASAU01);
        datumFromName.put("danger50", DANGER50);
        datumFromName.put("fakarava", FAKARAVA);
        datumFromName.put("gambier", GAMBIER);
        datumFromName.put("hao", HAO);
        datumFromName.put("hivaoa", HIVAOA);
        datumFromName.put("huahine", HUAHINESAU01);
        datumFromName.put("ign62ker", IGN62KER);
        datumFromName.put("ign87mart", IGN87MART);
        datumFromName.put("ign88gtbt", IGN88GTBT);
        datumFromName.put("ign88ls", IGN88LS);
        datumFromName.put("ifn88mg", IGN88MG);
        datumFromName.put("ign88sb", IGN88SB);
        datumFromName.put("ign88sm", IGN88SM);
        datumFromName.put("ign92ld", IGN92LD);
        datumFromName.put("ign66tahiti", IGNTAHITI66);
        datumFromName.put("maiao", MAIAO01);
        datumFromName.put("mataiva", MATAIVA);
        datumFromName.put("maupiti", MAUPITISAU01);
        datumFromName.put("moorea", MOOREASAU81);
        datumFromName.put("ngg77guy", NGG77GUY);
        datumFromName.put("nukuhiva", NUKUHIVA);
        datumFromName.put("raiatea", RAIATEASAU01);
        datumFromName.put("raivavae", RAIVAVAE);
        datumFromName.put("rar07", RAR07);
        datumFromName.put("reao", REAO);
        datumFromName.put("rurutu", RURUTU);
        datumFromName.put("shom53", SHOM53);
        datumFromName.put("tahaa", TAHAASAU01);
        datumFromName.put("tikehau", TIKEHAU);
        datumFromName.put("tubuai", TUBUAI);
        datumFromName.put("tupai", TUPAI01);
        datumFromName.put("airyvd", AIRYVD);
        datumFromName.put("austsavd", AustSAVD);
        datumFromName.put("besselvd", BESSEL1841VD);
        datumFromName.put("bessnamvd", BESSNAMVD);
        datumFromName.put("clrk66vd", CLARKE1866VD);
        datumFromName.put("clrk80vd", CLARKE1880RGSVD);
        datumFromName.put("clrk80ignvd", CLARKE1880IGNVD);
        datumFromName.put("clrk80arcvd", CLARKE1880ARCVD);
        datumFromName.put("evrstssvd", EVERESTSSVD);
        datumFromName.put("grs67vd", GRS67VD);
        datumFromName.put("grs80vd", GRS80VD);
        datumFromName.put("helmertvd", HELMERTVD);
        datumFromName.put("intlvd", INTERNATIONAL1924VD);
        datumFromName.put("airymodvd", AIRYMODVD);
        datumFromName.put("krassvd", KRASSOWSKIVD);
        datumFromName.put("wgs66vd", WGS66VD);
        datumFromName.put("wgs72vd", WGS72VD);
        datumFromName.put("wgs84vd", WGS84VD);
    }

    public static enum Type {
        GEOIDAL,
        ELLIPSOIDAL,
        DEPTH,
        BAROMETRIC,
        ORTHOMETRIC,
        OTHER_SURFACE;

    }
}

