/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class DeleteDeParser
extends AbstractDeParser<Delete> {
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public DeleteDeParser() {
        super(new StringBuilder());
    }

    public DeleteDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Delete delete) {
        this.buffer.append("DELETE");
        if (delete.getTables() != null && !delete.getTables().isEmpty()) {
            this.buffer.append(delete.getTables().stream().map(Table::getFullyQualifiedName).collect(Collectors.joining(", ", " ", "")));
        }
        this.buffer.append(" FROM ").append(delete.getTable().toString());
        if (delete.getJoins() != null) {
            for (Join join : delete.getJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        if (delete.getWhere() != null) {
            this.buffer.append(" WHERE ");
            delete.getWhere().accept(this.expressionVisitor);
        }
        if (delete.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(delete.getOrderByElements());
        }
        if (delete.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(delete.getLimit());
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

