/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.exec;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ExecutionQueueErrorJob
extends AbstractUIJob {
    private String errorName;
    private Throwable error;
    private boolean queue;
    private DBPPlatformUI.UserResponse response = DBPPlatformUI.UserResponse.STOP;

    public ExecutionQueueErrorJob(String errorName, Throwable error, boolean queue) {
        super("Execution Error Job");
        this.errorName = errorName;
        this.error = error;
        this.queue = queue;
    }

    @Override
    public IStatus runInUIThread(DBRProgressMonitor monitor) {
        ExecutionQueueErrorDialog dialog = new ExecutionQueueErrorDialog(UIUtils.getActiveWorkbenchShell(), "Execution Error", "Error occurred during " + this.errorName, GeneralUtils.makeExceptionStatus((Throwable)this.error), 7, this.queue);
        int result = dialog.open();
        switch (result) {
            case 1: 
            case 6: {
                this.response = DBPPlatformUI.UserResponse.STOP;
                break;
            }
            case 5: {
                this.response = DBPPlatformUI.UserResponse.IGNORE;
                break;
            }
            case 8: {
                this.response = DBPPlatformUI.UserResponse.RETRY;
                break;
            }
            case 9: {
                this.response = DBPPlatformUI.UserResponse.IGNORE_ALL;
                break;
            }
            default: {
                this.response = DBPPlatformUI.UserResponse.STOP;
            }
        }
        return Status.OK_STATUS;
    }

    public DBPPlatformUI.UserResponse getResponse() {
        return this.response;
    }

    public static DBPPlatformUI.UserResponse showError(String task, Throwable error, boolean queue) {
        ExecutionQueueErrorJob errorJob = new ExecutionQueueErrorJob(task, error, queue);
        errorJob.schedule();
        try {
            errorJob.join();
        }
        catch (InterruptedException e1) {
            log.error((Object)e1);
        }
        return errorJob.getResponse();
    }
}

