/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.convert.impl;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.ui.editors.sql.convert.ISQLTextConverter;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;

public class HTMLSQLConverter
implements ISQLTextConverter {
    private static final Log log = Log.getLog(HTMLSQLConverter.class);

    @Override
    @NotNull
    public String convertText(@NotNull SQLDialect dialect, @NotNull SQLSyntaxManager syntaxManager, @NotNull SQLRuleScanner ruleManager, @NotNull IDocument document, int startPos, int length, @NotNull Map<String, Object> options) {
        StringBuilder result = new StringBuilder();
        ruleManager.setRange(document, startPos, length);
        try {
            IToken token;
            result.append("<pre>");
            while (!(token = ruleManager.nextToken()).isEOF()) {
                int tokenOffset = ruleManager.getTokenOffset();
                int tokenLength = ruleManager.getTokenLength();
                boolean hasSpan = false;
                Object data = token.getData();
                if (data instanceof TextAttribute) {
                    result.append("<span style='");
                    TextAttribute ta = (TextAttribute)data;
                    if (ta.getBackground() != null) {
                        result.append("background-color:").append(HTMLSQLConverter.toHex(ta.getBackground())).append(";");
                    }
                    if (ta.getForeground() != null) {
                        result.append("color:").append(HTMLSQLConverter.toHex(ta.getForeground())).append(";");
                    }
                    if ((ta.getStyle() & 1) == 1) {
                        result.append("font-weight:bold;");
                    }
                    if ((ta.getStyle() & 2) == 2) {
                        result.append("font-style: italic;");
                    }
                    result.append("'>");
                    hasSpan = true;
                }
                result.append(document.get(tokenOffset, tokenLength));
                if (!hasSpan) continue;
                result.append("</span>");
            }
            result.append("</pre>");
        }
        catch (BadLocationException e) {
            log.error((Object)"Error converting SQL to HTML", (Throwable)e);
        }
        return result.toString().trim();
    }

    private static String toHex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

