/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.utils.CommonUtils;

public class SQLReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final Log log = Log.getLog(SQLReconcilingStrategy.class);
    private static final QualifiedName COLLAPSED_ANNOTATIONS = new QualifiedName("org.jkiss.dbeaver.ui.editors.sql", String.valueOf(SQLReconcilingStrategy.class.getName()) + ".collapsedFoldingAnnotations");
    private final NavigableSet<SQLScriptElementImpl> cache = new TreeSet<SQLScriptElementImpl>();
    private final SQLEditorBase editor;
    private IDocument document;

    public SQLReconcilingStrategy(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if ("__insert".equals(dirtyRegion.getType())) {
            this.reconcile(subRegion.getOffset(), subRegion.getLength(), false);
        } else {
            this.reconcile(subRegion.getOffset(), 0, false);
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile(0, this.document.getLength(), false);
    }

    public void initialReconcile() {
        this.reconcile(0, this.document.getLength(), true);
    }

    private Set<Integer> getSavedCollapsedAnnotationsOffsets() {
        String[] offsets;
        String data;
        IResource resource = this.getResource();
        if (resource == null) {
            return Collections.emptySet();
        }
        try {
            data = resource.getPersistentProperty(COLLAPSED_ANNOTATIONS);
        }
        catch (CoreException e) {
            log.warn((Object)"Core Exception caught while reading saved collapsed folding positions", (Throwable)e);
            return Collections.emptySet();
        }
        if (data == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> collapsedPositionsOffsets = new HashSet<Integer>();
        String[] stringArray = offsets = data.split(";");
        int n = offsets.length;
        int n2 = 0;
        while (n2 < n) {
            String offset = stringArray[n2];
            int offsetValue = CommonUtils.toInt((Object)offset, (int)-1);
            if (offsetValue == -1) {
                log.warn((Object)("Illegal offset parsed while reading saved collapsed annotation offsets. offset=" + offset));
            } else {
                collapsedPositionsOffsets.add(offsetValue);
            }
            ++n2;
        }
        return collapsedPositionsOffsets;
    }

    public void saveState() {
        IResource resource = this.getResource();
        ProjectionAnnotationModel annotationModel = this.editor.getAnnotationModel();
        if (resource == null || annotationModel == null) {
            return;
        }
        StringJoiner stringJoiner = new StringJoiner(";");
        for (SQLScriptElementImpl position : this.cache) {
            ProjectionAnnotation annotation = position.getAnnotation();
            if (annotation == null || !annotation.isCollapsed()) continue;
            stringJoiner.add(Integer.toString(position.getOffset()));
        }
        String value = stringJoiner.length() == 0 ? null : stringJoiner.toString();
        try {
            resource.setPersistentProperty(COLLAPSED_ANNOTATIONS, value);
        }
        catch (CoreException e) {
            log.warn((Object)"Core Exception caught while persisting saved collapsed folding positions", (Throwable)e);
        }
    }

    @Nullable
    private IResource getResource() {
        return EditorUtils.getFileFromInput((IEditorInput)this.editor.getEditorInput());
    }

    public void onDataSourceChange() {
        if (this.document == null) {
            return;
        }
        this.reconcile(0, this.document.getLength(), true);
    }

    private void reconcile(int damagedRegionOffset, int damagedRegionLength, boolean restoreCollapsedAnnotations) {
        SQLScriptElement rightmostParsedQuery;
        SQLScriptElementImpl rightBound;
        List<SQLScriptElement> parsedQueries;
        if (!this.editor.isFoldingEnabled()) {
            return;
        }
        ProjectionAnnotationModel model = this.editor.getAnnotationModel();
        if (model == null) {
            return;
        }
        SQLScriptElementImpl leftBound = this.cache.lower(new SQLScriptElementImpl(damagedRegionOffset, damagedRegionLength));
        if (leftBound != null) {
            leftBound = this.cache.lower(leftBound);
        }
        if ((parsedQueries = this.extractQueries(damagedRegionOffset = leftBound == null ? 0 : leftBound.getOffset() + leftBound.getLength(), damagedRegionLength = (rightBound = this.cache.ceiling(new SQLScriptElementImpl(damagedRegionOffset + damagedRegionLength, 0))) == null ? this.document.getLength() : rightBound.getOffset() + rightBound.getLength() - damagedRegionOffset)) == null) {
            return;
        }
        if (rightBound != null && !parsedQueries.isEmpty() && !rightBound.equals(this.getExpandedScriptElement(rightmostParsedQuery = parsedQueries.get(parsedQueries.size() - 1)))) {
            parsedQueries = this.extractQueries(damagedRegionOffset, this.document.getLength());
            if (parsedQueries == null) {
                return;
            }
            rightBound = null;
        }
        NavigableSet<SQLScriptElementImpl> cachedQueries = leftBound == null && rightBound == null ? Collections.unmodifiableNavigableSet(this.cache) : (leftBound == null ? Collections.unmodifiableNavigableSet(this.cache.headSet(rightBound, true)) : (rightBound == null ? Collections.unmodifiableNavigableSet(this.cache.tailSet(leftBound, false)) : Collections.unmodifiableNavigableSet(this.cache.subSet(leftBound, false, rightBound, true))));
        Collection parsedElements = parsedQueries.stream().filter(this::deservesFolding).map(this::getExpandedScriptElement).collect(Collectors.toSet());
        HashMap<ProjectionAnnotation, SQLScriptElementImpl> additions = new HashMap<ProjectionAnnotation, SQLScriptElementImpl>();
        Set<Object> savedCollapsedAnnotationsOffsets = restoreCollapsedAnnotations ? this.getSavedCollapsedAnnotationsOffsets() : Collections.emptySet();
        for (SQLScriptElementImpl element2 : parsedElements) {
            if (cachedQueries.contains(element2)) continue;
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            element2.setAnnotation(annotation);
            additions.put(annotation, element2);
            if (!savedCollapsedAnnotationsOffsets.contains(element2.getOffset())) continue;
            annotation.markCollapsed();
        }
        Collection deletedPositions = cachedQueries.stream().filter(element -> !parsedElements.contains(element)).collect(Collectors.toList());
        Annotation[] deletions = (Annotation[])deletedPositions.stream().map(SQLScriptElementImpl::getAnnotation).toArray(Annotation[]::new);
        model.modifyAnnotations(deletions, additions, null);
        this.cache.removeAll(deletedPositions);
        this.cache.addAll(additions.values());
    }

    @Nullable
    private List<SQLScriptElement> extractQueries(int offset, int length) {
        return this.editor.extractScriptQueries(offset, length, false, true, false);
    }

    private boolean deservesFolding(SQLScriptElement element) {
        int numberOfLines = this.getNumberOfLines(element);
        if (numberOfLines == 1) {
            return false;
        }
        if (element.getOffset() + element.getLength() != this.document.getLength() && this.expandQueryLength(element) == element.getLength()) {
            return numberOfLines > 2;
        }
        return true;
    }

    private int getNumberOfLines(SQLScriptElement element) {
        try {
            return this.document.getLineOfOffset(element.getOffset() + element.getLength()) - this.document.getLineOfOffset(element.getOffset()) + 1;
        }
        catch (BadLocationException e) {
            throw new SQLReconcilingStrategyException(e);
        }
    }

    private int expandQueryLength(SQLScriptElement element) {
        int position;
        for (position = element.getOffset() + element.getLength(); position < this.document.getLength(); ++position) {
            char c = this.unsafeGetChar(position);
            if (c == '\n' && position + 1 < this.document.getLength()) {
                ++position;
                break;
            }
            if (Character.isWhitespace(c)) {
                continue;
            }
            return element.getLength();
        }
        return position - element.getOffset();
    }

    @NotNull
    private SQLScriptElementImpl getExpandedScriptElement(@NotNull SQLScriptElement element) {
        return new SQLScriptElementImpl(element.getOffset(), this.expandQueryLength(element));
    }

    private char unsafeGetChar(int index) {
        try {
            return this.document.getChar(index);
        }
        catch (BadLocationException e) {
            throw new SQLReconcilingStrategyException(e);
        }
    }

    private static class SQLReconcilingStrategyException
    extends RuntimeException {
        private SQLReconcilingStrategyException(Throwable cause) {
            super(cause);
        }
    }

    private static class SQLScriptElementImpl
    extends Position
    implements SQLScriptElement,
    Comparable<SQLScriptElementImpl> {
        @Nullable
        private ProjectionAnnotation annotation;

        SQLScriptElementImpl(int offset, int length) {
            super(offset, length);
        }

        @Nullable
        public ProjectionAnnotation getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(@Nullable ProjectionAnnotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public int compareTo(@NotNull SQLScriptElementImpl o) {
            int diff = this.getOffset() - o.getOffset();
            if (diff != 0) {
                return diff;
            }
            return this.getLength() - o.getLength();
        }

        public boolean equals(Object o) {
            if (o instanceof Position) {
                Position p = (Position)o;
                return this.equals(p.getOffset(), p.getLength());
            }
            if (o instanceof SQLScriptElement) {
                SQLScriptElement e = (SQLScriptElement)o;
                return this.equals(e.getOffset(), e.getLength());
            }
            return false;
        }

        private boolean equals(int offset, int length) {
            return this.getOffset() == offset && this.getLength() == length;
        }

        public int hashCode() {
            return Objects.hash(this.getOffset(), this.getLength());
        }

        @NotNull
        public String getOriginalText() {
            return "";
        }

        @NotNull
        public String getText() {
            return "";
        }

        public Object getData() {
            return "";
        }

        public void setData(Object data) {
        }

        public void reset() {
        }
    }
}

