/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.local;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class LocalResultSetColumn
implements DBCAttributeMetaData {
    protected final DBCResultSet resultSet;
    private final int index;
    private final String label;
    private final DBPDataKind dataKind;
    private final DBSTypedObject typedObject;

    public LocalResultSetColumn(DBCResultSet resultSet, int index, String label, DBPDataKind dataKind) {
        this.resultSet = resultSet;
        this.index = index;
        this.label = label;
        this.dataKind = dataKind;
        this.typedObject = null;
    }

    public LocalResultSetColumn(DBCResultSet resultSet, int index, String label, DBSTypedObject typedObject) {
        this.resultSet = resultSet;
        this.index = index;
        this.label = label;
        this.dataKind = typedObject.getDataKind();
        this.typedObject = typedObject;
    }

    @Override
    @Property(viewable=true, order=1)
    public int getOrdinalPosition() {
        return this.index;
    }

    @Override
    @Nullable
    public Object getSource() {
        return null;
    }

    @Override
    @Property(viewable=true, order=2)
    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Override
    @Property(viewable=true, order=3)
    @Nullable
    public String getEntityName() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    @Nullable
    public DBCEntityMetaData getEntityMetaData() {
        return null;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    @Property(viewable=true, order=4)
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return this.label;
    }

    @Override
    @Property(viewable=true, order=5)
    public String getTypeName() {
        return this.typedObject == null ? DBUtils.getDefaultDataTypeName(this.resultSet.getSession().getDataSource(), this.dataKind) : this.typedObject.getTypeName();
    }

    @Override
    public String getFullTypeName() {
        return this.typedObject == null ? DBUtils.getFullTypeName(this) : this.typedObject.getFullTypeName();
    }

    @Override
    public int getTypeID() {
        return this.typedObject == null ? 0 : this.typedObject.getTypeID();
    }

    @Override
    public DBPDataKind getDataKind() {
        return this.dataKind;
    }

    @Override
    public Integer getScale() {
        return this.typedObject == null ? null : this.typedObject.getScale();
    }

    @Override
    public Integer getPrecision() {
        return this.typedObject == null ? null : this.typedObject.getPrecision();
    }

    @Override
    public long getMaxLength() {
        return this.typedObject == null ? 0L : this.typedObject.getMaxLength();
    }

    @Override
    public long getTypeModifiers() {
        return this.typedObject == null ? 0L : this.typedObject.getTypeModifiers();
    }

    public String toString() {
        return this.getName();
    }
}

