/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.team.core.mapping.IStorageMerger;

public final class RefactoringHistoryMerger
implements IStorageMerger {
    public boolean canMergeWithoutAncestor() {
        return true;
    }

    public IStatus merge(OutputStream output, String encoding, IStorage ancestor, IStorage target, IStorage other, IProgressMonitor monitor) throws CoreException {
        InputStream targetStream = null;
        InputStream sourceStream = null;
        try {
            try {
                targetStream = target.getContents();
                sourceStream = target.getContents();
                this.performMerge(output, targetStream, sourceStream);
            }
            catch (CoreException exception) {
                Status status = new Status(4, RefactoringUIPlugin.getPluginId(), 1, RefactoringUIMessages.RefactoringHistoryMerger_error_auto_merge, (Throwable)exception);
                if (targetStream != null) {
                    try {
                        targetStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (sourceStream != null) {
                    try {
                        sourceStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return status;
            }
        }
        catch (Throwable throwable) {
            if (targetStream != null) {
                try {
                    targetStream.close();
                }
                catch (IOException iOException) {}
            }
            if (sourceStream != null) {
                try {
                    sourceStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (targetStream != null) {
            try {
                targetStream.close();
            }
            catch (IOException iOException) {}
        }
        if (sourceStream != null) {
            try {
                sourceStream.close();
            }
            catch (IOException iOException) {}
        }
        return Status.OK_STATUS;
    }

    private void performMerge(OutputStream output, InputStream target, InputStream source) throws CoreException {
        DefaultRefactoringDescriptor[] sourceDescriptors = RefactoringHistoryManager.readRefactoringDescriptors((InputStream)source);
        DefaultRefactoringDescriptor[] targetDescriptors = RefactoringHistoryManager.readRefactoringDescriptors((InputStream)target);
        HashSet<DefaultRefactoringDescriptor> set = new HashSet<DefaultRefactoringDescriptor>(Arrays.asList(sourceDescriptors));
        set.addAll(Arrays.asList(targetDescriptors));
        RefactoringDescriptor[] outputDescriptors = new RefactoringDescriptor[set.size()];
        set.toArray(outputDescriptors);
        RefactoringHistoryManager.sortRefactoringDescriptorsAscending((RefactoringDescriptor[])outputDescriptors);
        RefactoringHistoryManager.writeRefactoringSession((OutputStream)output, (RefactoringSessionDescriptor)new RefactoringSessionDescriptor(outputDescriptors, "1.0", null), (boolean)true);
    }
}

