/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLInformation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;

public class MySQLCharset
extends MySQLInformation {
    private String name;
    private String description;
    private int maxLength;
    private List<MySQLCollation> collations = new ArrayList<MySQLCollation>();

    public MySQLCharset(MySQLDataSource dataSource, ResultSet dbResult) throws SQLException {
        super(dataSource);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHARSET");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DESCRIPTION");
        this.maxLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAXLEN");
    }

    void addCollation(MySQLCollation collation) {
        this.collations.add(collation);
        Collections.sort(this.collations, DBUtils.nameComparator());
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public List<MySQLCollation> getCollations() {
        return this.collations;
    }

    @Property(viewable=true, order=2)
    public MySQLCollation getDefaultCollation() {
        for (MySQLCollation collation : this.collations) {
            if (!collation.isDefault()) continue;
            return collation;
        }
        return null;
    }

    public MySQLCollation getCollation(String name) {
        for (MySQLCollation collation : this.collations) {
            if (!collation.getName().equals(name)) continue;
            return collation;
        }
        return null;
    }

    @Property(viewable=true, order=3)
    public int getMaxLength() {
        return this.maxLength;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }
}

