/**************************************************************************
   fotoxx-maps      general wildcard file and string search

   Copyright 2007-2021 Michael Cornelison
   source code URL: https://kornelix.net
   contact: mkornelix@gmail.com

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version. See https://www.gnu.org/licenses

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
   See the GNU General Public License for more details.

***************************************************************************/

#include "zfuncs.h"

#define contact  "mkornelix@gmail.com"

namespace zfuncs {
   extern char       *appimagexe;                                                //  appimage executable path name
   extern char       *progexe;                                                   //  executable path name
   extern cchar      *build_date_time;                                           //  build date and time
}


int main(int argc, char *argv[])
{
   using namespace zfuncs;
   
   #define release "fotoxx-maps-1.7"
   
   cchar    *message1 = "Already installed at /usr/share/fotoxx-maps";
   cchar    *message2 = "Copy Fotoxx map files to \n"
                        " %s/.local/share/fotoxx-maps ?";
   cchar    *message3 = "Remove Fotoxx map files ?";
   cchar    *labtip = "Install or remove Fotoxx local map files";

   zdialog  *zd;
   int      zstat, yn, err;
   char     command[200], sharedir[100];
   STATB    statb;
   
   snprintf(sharedir,100,"%s/usr/share/",getenv("HERE"));
   err = stat(sharedir,&statb);
   if (err) {                                                                    //  not appimage package
      Plog(1,"use command: 'sudo make install' or 'sudo make uninstall' \n"
             "to install or uninstall fotoxx-map files from this package \n");
      exit(0);
   }
   
   zinitapp(release,0,argc,argv);                                                //  set up app directories                1.5
   
   choose:
   
   zd = zdialog_new("fotoxx-map",0,"install","uninstall","help","about","quit",0);
   zdialog_add_widget(zd,"label","labtip","dialog",labtip);
   zdialog_run(zd,0,"desktop");
   zstat = zdialog_wait(zd);

   if (zstat == 1)                                                               //  install
   {
      err = stat("/usr/share/fotoxx-maps/data",&statb);
      if (! err) {
         zmessageACK(0,message1);                                                //  debian package is installed
         exit(0);                                                                //  notify and do nothing
      }

      yn = zmessageYN(null,message2,getenv("HOME"));                             //  ask to install map files
      if (! yn) exit(0);
      snprintf(command,200,"cp -R %s $HOME/.local/",sharedir);
      zshell("log ack",command);
   }

   if (zstat == 2)                                                               //  uninstall
   {
      yn = zmessageYN(null,message3);                                            //  ask to uninstall map files
      if (! yn) exit(0);
      snprintf(command,200,"rm -f -R $HOME/.local/share/fotoxx-maps");
      zshell("log ack",command);
      snprintf(command,200,"rm -f -R $HOME/.local/share/doc/fotoxx-maps");       //  1.7
      zshell("log ack",command);
      snprintf(command,200,"rm -f $HOME/.local/bin/fotoxx-maps*");               //  1.7 
      zshell("log ack",command);
   }
   
   if (zstat == 3) {
      showz_docfile(null,"userguide",null);                                      //  1.5
      zdialog_free(zd);
      goto choose;
   }
   
   if (zstat == 4) {
      zabout();
      zdialog_free(zd);
      goto choose;
   }
   
   exit(0);
}


//  supply unused zdialog callback function

void KBevent(GdkEventKey *event)
{ return; }


