//
// Copyright 2019 Juan Palacios <jpalaciosdev@gmail.com>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
// Distributed under the GPL version 3 or any later version.
//
#pragma once

#include <QByteArray>

class ICryptoLayer
{
 public:
  /// Initialization.
  virtual void init() = 0;

  /// @return subject public key.
  virtual QByteArray publicKey() = 0;

  /// Set the key that will be used in public key operations (as verify).
  /// This key is generated by other subject.
  virtual void usePublicKey(QByteArray const &publicKey) = 0;

  /// Compute and validates the data signature against the provided signature.
  virtual bool verify(QByteArray const &data, QByteArray const &signature) = 0;

  /// Generates the signature of the data.
  virtual QByteArray signature(QByteArray const &data) = 0;

  virtual ~ICryptoLayer() = default;
};
