/*
 * Decompiled with CFR 0.152.
 */
package ru.serce.jnrfuse.examples;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.types.mode_t;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Statvfs;

public class MemoryFS
extends FuseStubFS {
    private MemoryDirectory rootDirectory = new MemoryDirectory("");

    public static void main(String[] args) {
        MemoryFS memfs = new MemoryFS();
        try {
            String path;
            switch (Platform.getNativePlatform().getOS()) {
                case WINDOWS: {
                    path = "J:\\";
                    break;
                }
                default: {
                    path = "/tmp/mntm";
                }
            }
            memfs.mount(Paths.get(path, new String[0]), true, true);
        }
        finally {
            memfs.umount();
        }
    }

    public MemoryFS() {
        this.rootDirectory.add(new MemoryFile("Sample file.txt", "Hello there, feel free to look around.\n"));
        this.rootDirectory.add(new MemoryDirectory("Sample directory"));
        MemoryDirectory dirWithFiles = new MemoryDirectory("Directory with files");
        this.rootDirectory.add(dirWithFiles);
        dirWithFiles.add(new MemoryFile("hello.txt", "This is some sample text.\n"));
        dirWithFiles.add(new MemoryFile("hello again.txt", "This another file with text in it! Oh my!\n"));
        MemoryDirectory nestedDirectory = new MemoryDirectory("Sample nested directory");
        dirWithFiles.add(nestedDirectory);
        nestedDirectory.add(new MemoryFile("So deep.txt", "Man, I'm like, so deep in this here file structure.\n"));
    }

    @Override
    public int create(String path, @mode_t long mode, FuseFileInfo fi) {
        if (this.getPath(path) != null) {
            return -ErrorCodes.EEXIST();
        }
        MemoryPath parent = this.getParentPath(path);
        if (parent instanceof MemoryDirectory) {
            ((MemoryDirectory)parent).mkfile(this.getLastComponent(path));
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    @Override
    public int getattr(String path, FileStat stat) {
        MemoryPath p = this.getPath(path);
        if (p != null) {
            p.getattr(stat);
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    private String getLastComponent(String path) {
        while (path.substring(path.length() - 1).equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return "";
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private MemoryPath getParentPath(String path) {
        return this.rootDirectory.find(path.substring(0, path.lastIndexOf("/")));
    }

    private MemoryPath getPath(String path) {
        return this.rootDirectory.find(path);
    }

    @Override
    public int mkdir(String path, @mode_t long mode) {
        if (this.getPath(path) != null) {
            return -ErrorCodes.EEXIST();
        }
        MemoryPath parent = this.getParentPath(path);
        if (parent instanceof MemoryDirectory) {
            ((MemoryDirectory)parent).mkdir(this.getLastComponent(path));
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    @Override
    public int read(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryFile)) {
            return -ErrorCodes.EISDIR();
        }
        return ((MemoryFile)p).read(buf, size, offset);
    }

    @Override
    public int readdir(String path, Pointer buf, FuseFillDir filter, @off_t long offset, FuseFileInfo fi) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryDirectory)) {
            return -ErrorCodes.ENOTDIR();
        }
        filter.apply(buf, ".", null, 0L);
        filter.apply(buf, "..", null, 0L);
        ((MemoryDirectory)p).read(buf, filter);
        return 0;
    }

    @Override
    public int statfs(String path, Statvfs stbuf) {
        if (Platform.getNativePlatform().getOS() == Platform.OS.WINDOWS && "/".equals(path)) {
            stbuf.f_blocks.set(0x100000);
            stbuf.f_frsize.set((Number)1024);
            stbuf.f_bfree.set(0x100000);
        }
        return super.statfs(path, stbuf);
    }

    @Override
    public int rename(String path, String newName) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        MemoryPath newParent = this.getParentPath(newName);
        if (newParent == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(newParent instanceof MemoryDirectory)) {
            return -ErrorCodes.ENOTDIR();
        }
        p.delete();
        p.rename(newName.substring(newName.lastIndexOf("/")));
        ((MemoryDirectory)newParent).add(p);
        return 0;
    }

    @Override
    public int rmdir(String path) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryDirectory)) {
            return -ErrorCodes.ENOTDIR();
        }
        p.delete();
        return 0;
    }

    @Override
    public int truncate(String path, long offset) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryFile)) {
            return -ErrorCodes.EISDIR();
        }
        ((MemoryFile)p).truncate(offset);
        return 0;
    }

    @Override
    public int unlink(String path) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        p.delete();
        return 0;
    }

    @Override
    public int open(String path, FuseFileInfo fi) {
        return 0;
    }

    @Override
    public int write(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryFile)) {
            return -ErrorCodes.EISDIR();
        }
        return ((MemoryFile)p).write(buf, size, offset);
    }

    private abstract class MemoryPath {
        private String name;
        private MemoryDirectory parent;

        private MemoryPath(String name) {
            this(name, (MemoryDirectory)null);
        }

        private MemoryPath(String name, MemoryDirectory parent) {
            this.name = name;
            this.parent = parent;
        }

        private synchronized void delete() {
            if (this.parent != null) {
                this.parent.deleteChild(this);
                this.parent = null;
            }
        }

        protected MemoryPath find(String path) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.equals(this.name) || path.isEmpty()) {
                return this;
            }
            return null;
        }

        protected abstract void getattr(FileStat var1);

        private void rename(String newName) {
            while (newName.startsWith("/")) {
                newName = newName.substring(1);
            }
            this.name = newName;
        }
    }

    private class MemoryFile
    extends MemoryPath {
        private ByteBuffer contents;

        private MemoryFile(String name) {
            super(name);
            this.contents = ByteBuffer.allocate(0);
        }

        private MemoryFile(String name, MemoryDirectory parent) {
            super(name, parent);
            this.contents = ByteBuffer.allocate(0);
        }

        public MemoryFile(String name, String text) {
            super(name);
            this.contents = ByteBuffer.allocate(0);
            try {
                byte[] contentBytes = text.getBytes("UTF-8");
                this.contents = ByteBuffer.wrap(contentBytes);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        @Override
        protected void getattr(FileStat stat) {
            stat.st_mode.set((Number)33279);
            stat.st_size.set((Number)this.contents.capacity());
            stat.st_uid.set(MemoryFS.this.getContext().uid.get());
            stat.st_gid.set(MemoryFS.this.getContext().gid.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int read(Pointer buffer, long size, long offset) {
            int bytesToRead = (int)Math.min((long)this.contents.capacity() - offset, size);
            byte[] bytesRead = new byte[bytesToRead];
            MemoryFile memoryFile = this;
            synchronized (memoryFile) {
                this.contents.position((int)offset);
                this.contents.get(bytesRead, 0, bytesToRead);
                buffer.put(0L, bytesRead, 0, bytesToRead);
                this.contents.position(0);
            }
            return bytesToRead;
        }

        private synchronized void truncate(long size) {
            if (size < (long)this.contents.capacity()) {
                ByteBuffer newContents = ByteBuffer.allocate((int)size);
                byte[] bytesRead = new byte[(int)size];
                this.contents.get(bytesRead);
                newContents.put(bytesRead);
                this.contents = newContents;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int write(Pointer buffer, long bufSize, long writeOffset) {
            int maxWriteIndex = (int)(writeOffset + bufSize);
            byte[] bytesToWrite = new byte[(int)bufSize];
            MemoryFile memoryFile = this;
            synchronized (memoryFile) {
                if (maxWriteIndex > this.contents.capacity()) {
                    ByteBuffer newContents = ByteBuffer.allocate(maxWriteIndex);
                    newContents.put(this.contents);
                    this.contents = newContents;
                }
                buffer.get(0L, bytesToWrite, 0, (int)bufSize);
                this.contents.position((int)writeOffset);
                this.contents.put(bytesToWrite);
                this.contents.position(0);
            }
            return (int)bufSize;
        }
    }

    private class MemoryDirectory
    extends MemoryPath {
        private List<MemoryPath> contents;

        private MemoryDirectory(String name) {
            super(name);
            this.contents = new ArrayList<MemoryPath>();
        }

        private MemoryDirectory(String name, MemoryDirectory parent) {
            super(name, parent);
            this.contents = new ArrayList<MemoryPath>();
        }

        public synchronized void add(MemoryPath p) {
            this.contents.add(p);
            p.parent = this;
        }

        private synchronized void deleteChild(MemoryPath child) {
            this.contents.remove(child);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected MemoryPath find(String path) {
            if (super.find(path) != null) {
                return super.find(path);
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            MemoryDirectory memoryDirectory = this;
            synchronized (memoryDirectory) {
                if (!path.contains("/")) {
                    for (MemoryPath p : this.contents) {
                        if (!p.name.equals(path)) continue;
                        return p;
                    }
                    return null;
                }
                String nextName = path.substring(0, path.indexOf("/"));
                String rest = path.substring(path.indexOf("/"));
                for (MemoryPath p : this.contents) {
                    if (!p.name.equals(nextName)) continue;
                    return p.find(rest);
                }
            }
            return null;
        }

        @Override
        protected void getattr(FileStat stat) {
            stat.st_mode.set((Number)16895);
            stat.st_uid.set(MemoryFS.this.getContext().uid.get());
            stat.st_gid.set(MemoryFS.this.getContext().gid.get());
        }

        private synchronized void mkdir(String lastComponent) {
            this.contents.add(new MemoryDirectory(lastComponent, this));
        }

        public synchronized void mkfile(String lastComponent) {
            this.contents.add(new MemoryFile(lastComponent, this));
        }

        public synchronized void read(Pointer buf, FuseFillDir filler) {
            for (MemoryPath p : this.contents) {
                filler.apply(buf, p.name, null, 0L);
            }
        }
    }
}

