/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.common.ArrayUtils;

@Singleton
class MoveOperation {
    private final CopyOperation copyOperation;

    @Inject
    public MoveOperation(CopyOperation copyOperation) {
        this.copyOperation = copyOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(CryptoPath source, CryptoPath target, CopyOption ... options) throws IOException {
        if (source.equals(target)) {
            return;
        }
        if (source.getFileSystem() == target.getFileSystem()) {
            source.getFileSystem().move(source, target, options);
        } else {
            if (ArrayUtils.contains(options, StandardCopyOption.ATOMIC_MOVE)) {
                throw new AtomicMoveNotSupportedException(source.toUri().toString(), target.toUri().toString(), "Move of encrypted file to different FileSystem");
            }
            if (this.isNonEmptyDirectory(source)) {
                throw new IOException("Can not move non empty directory to different FileSystem");
            }
            boolean success = false;
            boolean cleanup = true;
            try {
                this.copyOperation.copy(source, target, this.addCopyAttributesTo(options));
                success = true;
                cleanup = false;
            }
            catch (FileAlreadyExistsException | NoSuchFileException e) {
                cleanup = false;
            }
            finally {
                if (cleanup) {
                    try {
                        target.getFileSystem().delete(target);
                    }
                    catch (IOException iOException) {}
                }
                if (success) {
                    source.getFileSystem().delete(source);
                }
            }
        }
    }

    private CopyOption[] addCopyAttributesTo(CopyOption[] options) {
        CopyOption[] result = Arrays.copyOf(options, options.length + 1);
        result[result.length - 1] = StandardCopyOption.COPY_ATTRIBUTES;
        return result;
    }

    private boolean isNonEmptyDirectory(CryptoPath source) throws IOException {
        Optional<BasicFileAttributes> sourceAttrs = this.attributes(source, new LinkOption[0]);
        if (!sourceAttrs.map(BasicFileAttributes::isDirectory).orElse(false).booleanValue()) {
            return false;
        }
        try (DirectoryStream<Path> contents = source.getFileSystem().newDirectoryStream(source, ignored -> true);){
            boolean bl = contents.iterator().hasNext();
            return bl;
        }
    }

    private Optional<BasicFileAttributes> attributes(CryptoPath path, LinkOption ... linkOptions) {
        try {
            return Optional.of(path.getFileSystem().readAttributes(path, BasicFileAttributes.class, linkOptions));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

