/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.file.PathMatcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.cryptofs.GlobToRegexConverter;
import org.cryptomator.cryptofs.PatternPathMatcher;

@Singleton
class PathMatcherFactory {
    private final GlobToRegexConverter globToRegexConverter;

    @Inject
    public PathMatcherFactory(GlobToRegexConverter globToRegexConverter) {
        this.globToRegexConverter = globToRegexConverter;
    }

    public PathMatcher pathMatcherFrom(String syntaxAndPattern) {
        return new PatternPathMatcher(this.pattern(syntaxAndPattern));
    }

    private Pattern pattern(String syntaxAndPattern) {
        String lowercaseSyntaxAndPattern = syntaxAndPattern.toLowerCase();
        if (lowercaseSyntaxAndPattern.startsWith("glob:")) {
            return Pattern.compile(this.globToRegexConverter.convert(syntaxAndPattern.substring(5)));
        }
        if (lowercaseSyntaxAndPattern.startsWith("regex:")) {
            return Pattern.compile(syntaxAndPattern.substring(6));
        }
        throw new UnsupportedOperationException();
    }
}

