/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.filters;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.webdav.util.EncodeUtil;
import org.cryptomator.webdav.core.filters.HttpFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicodeResourcePathNormalizationFilter
implements HttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(UnicodeResourcePathNormalizationFilter.class);
    private static final String PROPFIND_METHOD = "PROPFIND";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final Set<String> USER_AGENTS_EXPECTING_NFD = ImmutableSet.of((Object)"WebDAVFS");

    @Override
    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object filteredResponse = PROPFIND_METHOD.equalsIgnoreCase(request.getMethod()) && this.isUserAgentExpectingNfdResponses(request) ? new NormalizedMultiStatusResponse(response, Normalizer.Form.NFD) : response;
        chain.doFilter((ServletRequest)new NormalizedRequest(request), (ServletResponse)filteredResponse);
    }

    private boolean isUserAgentExpectingNfdResponses(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT_HEADER);
        return USER_AGENTS_EXPECTING_NFD.contains(userAgent);
    }

    static class MultistatusHrefNormalizer
    implements AutoCloseable {
        private final XMLStreamReader reader;
        private final XMLStreamWriter writer;
        private boolean isParsingHref = false;
        private final Normalizer.Form normalizationForm;

        public MultistatusHrefNormalizer(InputStream in, OutputStream out, Normalizer.Form normalizationForm) {
            try {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
                this.reader = inputFactory.createXMLStreamReader(in);
                XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
                this.writer = outputFactory.createXMLStreamWriter(out, StandardCharsets.UTF_8.name());
            }
            catch (FactoryConfigurationError | XMLStreamException e) {
                throw new IllegalStateException("Failed to set up XML reader/writer", e);
            }
            this.normalizationForm = normalizationForm;
        }

        public void transform() throws XMLStreamException {
            this.writer.writeStartDocument();
            while (this.reader.hasNext()) {
                int xmlEvent = this.reader.next();
                switch (xmlEvent) {
                    case 1: {
                        QName qname = this.reader.getName();
                        this.writer.writeStartElement(qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI());
                        for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
                            this.writer.writeNamespace(this.reader.getNamespacePrefix(i), this.reader.getNamespaceURI(i));
                        }
                        this.isParsingHref = qname.getLocalPart().equalsIgnoreCase("href");
                        break;
                    }
                    case 4: {
                        if (this.isParsingHref) {
                            this.writer.writeCharacters(this.transformHref(this.reader.getText()));
                            break;
                        }
                        this.writer.writeCharacters(this.reader.getText());
                        break;
                    }
                    case 2: {
                        this.writer.writeEndElement();
                        this.isParsingHref = false;
                        break;
                    }
                }
            }
            this.writer.writeEndDocument();
            this.writer.flush();
        }

        private String transformHref(String originalHref) {
            URI uri = URI.create(originalHref);
            String normalizedPath = Normalizer.normalize(uri.getPath(), this.normalizationForm);
            String escapedPath = EncodeUtil.escapePath((String)normalizedPath);
            return uri.getScheme() + "://" + uri.getRawAuthority() + escapedPath;
        }

        @Override
        public void close() throws XMLStreamException {
            this.reader.close();
            this.writer.close();
        }
    }

    private static class NormalizedServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final ServletOutputStream delegate;
        private final int contentLength;
        private final Normalizer.Form normalizationForm;

        public NormalizedServletOutputStream(ServletOutputStream delegate, int contentLength, Normalizer.Form normalizationForm) {
            if (contentLength < 0) {
                throw new IllegalArgumentException("contentLength must be a positive integer");
            }
            this.delegate = delegate;
            this.contentLength = contentLength;
            this.normalizationForm = normalizationForm;
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.buffer.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.write(b, off, len);
            if (this.buffer.size() >= this.contentLength) {
                this.normalize();
            }
        }

        private void normalize() throws IOException {
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.buffer.toByteArray(), 0, this.contentLength);
                 MultistatusHrefNormalizer transformer = new MultistatusHrefNormalizer(in, (OutputStream)this.delegate, this.normalizationForm);){
                transformer.transform();
            }
            catch (XMLStreamException e) {
                LOG.error("Error processing XML.", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    private static class NormalizedMultiStatusResponse
    extends HttpServletResponseWrapper {
        private boolean isMultiStatus = true;
        private int contentLength = -1;
        private final Normalizer.Form normalizationForm;

        public NormalizedMultiStatusResponse(HttpServletResponse response, Normalizer.Form normalizationForm) {
            super(response);
            this.normalizationForm = normalizationForm;
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.isMultiStatus = sc == 207;
        }

        public void setContentLength(int len) {
            this.contentLength = len;
        }

        public void setContentLengthLong(long len) {
            this.contentLength = len <= Integer.MAX_VALUE ? (int)len : -1;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.isMultiStatus && this.contentLength != -1) {
                return new NormalizedServletOutputStream(super.getOutputStream(), this.contentLength, this.normalizationForm);
            }
            LOG.warn("Response not a Multi Status response, thus output encoding will not be normalized.");
            return super.getOutputStream();
        }
    }

    private static class NormalizedRequest
    extends HttpServletRequestWrapper {
        private static final String DESTINATION_HEADER = "Destination";

        public NormalizedRequest(HttpServletRequest request) {
            super(request);
        }

        public String getPathInfo() {
            int lengthContextPath = this.getContextPath().length();
            String path = this.getNormalizedRequestURI().getPath();
            assert (path.length() >= lengthContextPath);
            return path.substring(lengthContextPath);
        }

        public String getRequestURI() {
            return this.getNormalizedRequestURI().toString();
        }

        private URI getNormalizedRequestURI() {
            try {
                URI uri = URI.create(super.getRequestURI());
                if (!uri.getPath().startsWith(this.getContextPath())) {
                    throw new IllegalStateException("URI does not match to Context Path.");
                }
                String normedUri = Normalizer.normalize(uri.getPath(), Normalizer.Form.NFC);
                return new URI(null, null, normedUri, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        public String getHeader(String name) {
            if (DESTINATION_HEADER.equalsIgnoreCase(name)) {
                String origDestHeader = super.getHeader(DESTINATION_HEADER);
                if (origDestHeader == null) {
                    return null;
                }
                try {
                    URI orig = URI.create(origDestHeader);
                    String normalizedPath = Normalizer.normalize(orig.getPath(), Normalizer.Form.NFC);
                    return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), normalizedPath, orig.getQuery(), orig.getFragment()).toString();
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("URI constructed from valid URI can not be invalid.", e);
                }
            }
            return super.getHeader(name);
        }

        public StringBuffer getRequestURL() {
            StringBuffer url = new StringBuffer();
            url.append(this.getScheme()).append("://");
            url.append(this.getServerName());
            if (this.getScheme().equals("http") && this.getServerPort() != 80 || this.getScheme().equals("https") && this.getServerPort() != 443) {
                url.append(':').append(this.getServerPort());
            }
            url.append(this.getRequestURI());
            return url;
        }
    }
}

