/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.cryptomator.webdav.core.servlet.DavFolder;
import org.cryptomator.webdav.core.servlet.DavLocatorImpl;
import org.cryptomator.webdav.core.servlet.DavNode;
import org.cryptomator.webdav.core.servlet.DavResourceFactoryImpl;
import org.cryptomator.webdav.core.servlet.NullInputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DavFile
extends DavNode {
    public static final Logger LOG = LoggerFactory.getLogger(DavFile.class);
    protected static final String CONTENT_TYPE_VALUE = "application/octet-stream";
    protected static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    protected static final String CONTENT_DISPOSITION_VALUE = "attachment";
    protected static final String X_CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    protected static final String X_CONTENT_TYPE_OPTIONS_VALUE = "nosniff";

    public DavFile(DavResourceFactoryImpl factory, LockManager lockManager, DavLocatorImpl locator, Path path, Optional<BasicFileAttributes> attr, DavSession session) {
        super(factory, lockManager, locator, path, attr, session);
    }

    public boolean isCollection() {
        return false;
    }

    public void spool(OutputContext outputContext) throws IOException {
        assert (this.exists());
        outputContext.setModificationTime(((BasicFileAttributes)this.attr.get()).lastModifiedTime().toMillis());
        if (!outputContext.hasStream()) {
            return;
        }
        outputContext.setContentType(CONTENT_TYPE_VALUE);
        outputContext.setProperty(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE);
        outputContext.setProperty(X_CONTENT_TYPE_OPTIONS_HEADER, X_CONTENT_TYPE_OPTIONS_VALUE);
        outputContext.setContentLength(((BasicFileAttributes)this.attr.get()).size());
        Files.copy(this.path, outputContext.getOutputStream());
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        throw new UnsupportedOperationException();
    }

    public DavResourceIterator getMembers() {
        throw new UnsupportedOperationException();
    }

    public void removeMember(DavResource member) throws DavException {
        throw new UnsupportedOperationException();
    }

    public void move(DavResource destination) throws DavException {
        if (destination instanceof DavNode) {
            DavFile dst = (DavFile)destination;
            if (!Files.isDirectory(dst.path.getParent(), new LinkOption[0])) {
                throw new DavException(409, "Destination's parent doesn't exist.");
            }
            try {
                Files.move(this.path, dst.path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileSystemException e) {
                String reason = Strings.nullToEmpty((String)e.getReason());
                if (reason.contains("too long")) {
                    throw new DavException(400);
                }
                throw new DavException(500, (Throwable)e);
            }
            catch (IOException e) {
                throw new DavException(500, (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Destination not a DavNode: " + destination.getClass().getName());
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (destination instanceof DavNode) {
            DavFile dst = (DavFile)destination;
            if (!Files.isDirectory(dst.path.getParent(), new LinkOption[0])) {
                throw new DavException(409, "Destination's parent doesn't exist.");
            }
            try {
                Files.copy(this.path, dst.path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileSystemException e) {
                String reason = Strings.nullToEmpty((String)e.getReason());
                if (reason.contains("path too long")) {
                    throw new DavException(400);
                }
                throw new DavException(500, (Throwable)e);
            }
            catch (IOException e) {
                throw new DavException(500, (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Destination not a DavFile: " + destination.getClass().getName());
        }
    }

    @Override
    public DavProperty<?> getProperty(DavPropertyName name) {
        if (DavPropertyName.GETCONTENTLENGTH.equals((Object)name)) {
            return this.sizeProperty().orElse(null);
        }
        return super.getProperty(name);
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet result = super.getProperties();
        if (!result.contains(DavPropertyName.GETCONTENTLENGTH)) {
            this.sizeProperty().ifPresent(arg_0 -> ((DavPropertySet)result).add(arg_0));
        }
        return result;
    }

    private Optional<DavProperty<?>> sizeProperty() {
        return this.attr.map(a -> new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)a.size()));
    }

    @Override
    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        ActiveLock lock = super.lock(reqLockInfo);
        if (!this.exists()) {
            DavFolder parentFolder = this.getCollection();
            assert (parentFolder != null) : "File always has a folder.";
            parentFolder.addMember(this, new NullInputContext());
        }
        return lock;
    }
}

