/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure.filesecurity;

import com.dokany.java.structure.filesecurity.AccessControlEntry;
import com.dokany.java.structure.filesecurity.AccessControlEntryType;
import com.dokany.java.structure.filesecurity.Byteable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AccessControlList
implements Byteable {
    private final ACLType aclType;
    private static final AccessControlEntryType[] allowedACEsForDaclRev2 = new AccessControlEntryType[]{AccessControlEntryType.ACCESS_ALLOWED_ACE_TYPE, AccessControlEntryType.ACCESS_DENIED_ACE_TYPE};
    private static final AccessControlEntryType[] allowedACEsForDaclRev4 = new AccessControlEntryType[]{AccessControlEntryType.ACCESS_ALLOWED_COMPOUND_ACE_TYPE, AccessControlEntryType.ACCESS_ALLOWED_OBJECT_ACE_TYPE, AccessControlEntryType.ACCESS_DENIED_OBJECT_ACE_TYPE};
    private static final AccessControlEntryType[] allowedACEsForSaclRev2 = new AccessControlEntryType[]{AccessControlEntryType.SYSTEM_AUDIT_ACE_TYPE, AccessControlEntryType.SYSTEM_ALARM_ACE_TYPE, AccessControlEntryType.SYSTEM_MANDATORY_LABEL_ACE_TYPE, AccessControlEntryType.SYSTEM_RESOURCE_ATTRIBUTE_ACE_TYPE, AccessControlEntryType.SYSTEM_SCOPED_POLICY_ID_ACE_TYPE};
    private static final AccessControlEntryType[] allowedACEsForSaclRev4 = new AccessControlEntryType[]{AccessControlEntryType.SYSTEM_AUDIT_OBJECT_ACE_TYPE, AccessControlEntryType.SYSTEM_ALARM_OBJECT_ACE_TYPE, AccessControlEntryType.SYSTEM_MANDATORY_LABEL_ACE_TYPE};
    private final byte aclRevision;
    private final byte sbz1 = 0;
    private final short sbz2 = 0;
    private List<AccessControlEntry> aces;

    private AccessControlList(ACLType aclType, byte aclRevision, List<? extends AccessControlEntry> aces) {
        this.aclType = aclType;
        this.aclRevision = aclRevision;
        this.aces = new ArrayList<AccessControlEntry>(15);
        this.aces.addAll(aces);
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(this.sizeOfByteArray());
        buf.put(this.aclRevision);
        buf.put((byte)0);
        buf.putShort(Short.reverseBytes((short)this.sizeOfByteArray()));
        buf.putShort(Short.reverseBytes((short)this.aces.size()));
        buf.putShort(Short.reverseBytes((short)0));
        for (AccessControlEntry ace : this.aces) {
            buf.put(ace.toByteArray());
        }
        return buf.array();
    }

    @Override
    public int sizeOfByteArray() {
        return 8 + this.aces.stream().reduce(0, (sum, ace) -> sum + ace.sizeOfByteArray(), (x, y) -> x + y);
    }

    public static AccessControlList createDaclRevision2(List<? extends AccessControlEntry> aces) {
        for (AccessControlEntry accessControlEntry : aces) {
            if (AccessControlList.isValidAce(accessControlEntry.type, allowedACEsForDaclRev2)) continue;
            return null;
        }
        return new AccessControlList(ACLType.DACL, 2, aces);
    }

    public static AccessControlList createDaclRevision4(List<? extends AccessControlEntry> aces) {
        for (AccessControlEntry accessControlEntry : aces) {
            if (AccessControlList.isValidAce(accessControlEntry.type, allowedACEsForDaclRev4)) continue;
            return null;
        }
        return new AccessControlList(ACLType.DACL, 4, aces);
    }

    public static AccessControlList createSaclRevision2(List<? extends AccessControlEntry> aces) {
        for (AccessControlEntry accessControlEntry : aces) {
            if (AccessControlList.isValidAce(accessControlEntry.type, allowedACEsForSaclRev2)) continue;
            return null;
        }
        return new AccessControlList(ACLType.SACL, 2, aces);
    }

    public static AccessControlList createSaclRevision4(List<? extends AccessControlEntry> aces) {
        for (AccessControlEntry accessControlEntry : aces) {
            if (AccessControlList.isValidAce(accessControlEntry.type, allowedACEsForSaclRev4)) continue;
            return null;
        }
        return new AccessControlList(ACLType.SACL, 4, aces);
    }

    private static boolean isValidAce(AccessControlEntryType aceType, AccessControlEntryType[] validACEs) {
        for (AccessControlEntryType validAceType : validACEs) {
            if (aceType.ordinal() != validAceType.ordinal()) continue;
            return true;
        }
        return false;
    }

    private static enum ACLType {
        DACL,
        SACL;

    }
}

