/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.cryptomator.frontend.dokany.OpenDirectory;
import org.cryptomator.frontend.dokany.OpenFile;
import org.cryptomator.frontend.dokany.OpenHandle;
import org.cryptomator.frontend.dokany.OpenRestrictedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHandleFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenHandleFactory.class);
    private final ConcurrentMap<Long, OpenHandle> openHandles = new ConcurrentHashMap<Long, OpenHandle>();
    private final HandleGenerator handleGen = new HandleGenerator();

    public long openDir(Path path) throws IOException {
        long dirHandle = this.handleGen.getAndIncrement();
        this.openHandles.putIfAbsent(dirHandle, new OpenDirectory(path));
        return dirHandle;
    }

    public long openFile(Path path, OpenOption ... options) throws IOException {
        return this.openFile(path, Sets.newHashSet((Object[])options), new FileAttribute[0]);
    }

    public long openFile(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        long fileHandle = this.handleGen.getAndIncrement();
        this.openHandles.put(fileHandle, OpenFile.open(path, options, attrs));
        return fileHandle;
    }

    public long openRestrictedFile(Path path) {
        long fileHandle = this.handleGen.getAndIncrement();
        this.openHandles.put(fileHandle, OpenRestrictedFile.open(path));
        return fileHandle;
    }

    public OpenHandle get(Long fileHandle) {
        return (OpenHandle)this.openHandles.get(fileHandle);
    }

    public boolean exists(Long handle) {
        return this.openHandles.containsKey(handle);
    }

    public void close(long handle) throws ClosedChannelException, IOException {
        OpenHandle object = (OpenHandle)this.openHandles.remove(handle);
        if (object == null) {
            throw new ClosedChannelException();
        }
        object.close();
    }

    @Override
    public synchronized void close() throws IOException {
        IOException exception = new IOException("At least one open handle could not be closed.");
        Iterator it = this.openHandles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            OpenHandle openHandle = (OpenHandle)entry.getValue();
            LOG.warn("Closing unclosed handle to {}", (Object)openHandle.path);
            try {
                openHandle.close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
            it.remove();
        }
        if (exception.getSuppressed().length > 0) {
            throw exception;
        }
    }

    public boolean areNoHandlesOpen() {
        return this.openHandles.isEmpty();
    }

    private class HandleGenerator {
        private final AtomicLong handleGen = new AtomicLong(1L);

        private HandleGenerator() {
        }

        public long getAndIncrement() {
            long handle = this.handleGen.getAndIncrement();
            if (handle == 0L) {
                handle = this.handleGen.getAndIncrement();
            }
            return handle;
        }
    }
}

