/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.locks;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import org.cryptomator.frontend.dokany.locks.PathLock;
import org.cryptomator.frontend.dokany.locks.PathLockBuilder;
import org.cryptomator.frontend.dokany.locks.PathRLockImpl;
import org.cryptomator.frontend.dokany.locks.PathWLockImpl;

class PathLockBuilderImpl
implements PathLockBuilder {
    private final List<String> pathComponents;
    private final Optional<PathLockBuilder> parent;
    private final ReadWriteLock lock;
    private final Function<List<String>, ReadWriteLock> dataLockSupplier;

    PathLockBuilderImpl(List<String> pathComponents, Optional<PathLockBuilder> parent, ReadWriteLock lock, Function<List<String>, ReadWriteLock> dataLockSupplier) {
        this.pathComponents = pathComponents;
        this.parent = parent;
        this.lock = lock;
        this.dataLockSupplier = dataLockSupplier;
    }

    @Override
    public PathLock forReading() {
        Optional<PathLock> parentLock = this.parent.map(PathLockBuilder::forReading);
        return PathRLockImpl.create(this.pathComponents, parentLock, this.lock, this.dataLockSupplier);
    }

    @Override
    public PathLock forWriting() {
        Optional<PathLock> parentLock = this.parent.map(PathLockBuilder::forReading);
        return PathWLockImpl.create(this.pathComponents, parentLock, this.lock, this.dataLockSupplier);
    }
}

