/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind.optional;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyBinding;
import com.tobiasdiez.easybind.EasyObservableValue;
import com.tobiasdiez.easybind.PropertyBinding;
import com.tobiasdiez.easybind.SimpleChangeListener;
import com.tobiasdiez.easybind.Subscription;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import com.tobiasdiez.easybind.optional.OptionalWrapper;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;

public interface ObservableOptionalValue<T>
extends ObservableObjectValue<Optional<T>> {
    default public boolean isValuePresent() {
        return ((Optional)this.getValue()).isPresent();
    }

    default public boolean isValueEmpty() {
        return !this.isValuePresent();
    }

    default public void ifValuePresent(Consumer<? super T> action) {
        ((Optional)this.getValue()).ifPresent(action);
    }

    default public T getValueOrElseThrow() {
        return ((Optional)this.getValue()).orElseThrow(() -> new NoSuchElementException("No value present"));
    }

    default public T getValueOrElse(T other) {
        return ((Optional)this.getValue()).orElse(other);
    }

    default public EasyObservableValue<T> asOrdinary() {
        return this.orElse((T)null);
    }

    public EasyBinding<T> orElse(T var1);

    public OptionalBinding<T> orElse(ObservableValue<T> var1);

    public OptionalBinding<T> filter(Predicate<? super T> var1);

    public <U> OptionalBinding<U> map(Function<? super T, ? extends U> var1);

    public <U> OptionalBinding<U> flatMap(Function<T, Optional<U>> var1);

    default public <U, O extends ObservableValue<U>> OptionalBinding<U> mapObservable(Function<? super T, O> mapper) {
        Function<Optional, ObservableValue> mapperOpt = optionalVal -> {
            Optional newObservable = optionalVal.map(mapper);
            if (newObservable.isPresent()) {
                return (ObservableValue)newObservable.get();
            }
            return new ReadOnlyObjectWrapper(null);
        };
        EasyBinding binding = EasyBind.mapObservable(this, mapperOpt);
        return new OptionalWrapper(binding);
    }

    default public <U, O extends Property<U>> PropertyBinding<U> selectProperty(Function<? super T, O> mapper) {
        Function<Optional, Property> mapperOpt = optionalVal -> {
            Optional newObs = optionalVal.map(mapper);
            if (newObs.isPresent()) {
                return (Property)newObs.get();
            }
            return new ReadOnlyObjectWrapper(null);
        };
        return EasyBind.selectProperty(this, mapperOpt);
    }

    public BooleanBinding isPresent();

    public BooleanBinding isEmpty();

    default public Subscription listenToValues(SimpleChangeListener<? super T> listener) {
        ChangeListener listenerOpt = (observable, oldValue, newValue) -> newValue.ifPresent(newVal -> listener.changed(oldValue.orElse(null), newVal));
        return this.listen(listenerOpt);
    }

    default public Subscription subscribeToValues(Consumer<? super T> subscriber) {
        Consumer<Optional> subscriberOpt = newValue -> newValue.ifPresent(subscriber);
        return EasyBind.subscribe(this, subscriberOpt);
    }

    default public Subscription subscribe(Consumer<? super Optional<T>> listener) {
        return EasyBind.subscribe(this, listener);
    }

    default public Subscription listen(ChangeListener<? super Optional<T>> listener) {
        return EasyBind.listen(this, listener);
    }
}

