/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind.optional;

import com.tobiasdiez.easybind.EasyBinding;
import com.tobiasdiez.easybind.EasyPreboundBinding;
import com.tobiasdiez.easybind.PreboundBinding;
import com.tobiasdiez.easybind.optional.FirstNonNullBinding;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;

public abstract class PreboundOptionalBinding<T>
extends PreboundBinding<Optional<T>>
implements OptionalBinding<T> {
    public PreboundOptionalBinding(Observable ... dependencies) {
        super(dependencies);
    }

    @Override
    public <U> OptionalBinding<U> map(final Function<? super T, ? extends U> mapper) {
        return new PreboundOptionalBinding<U>(this.dependencies){

            protected Optional<U> computeValue() {
                return ((Optional)PreboundOptionalBinding.this.getValue()).map(mapper);
            }
        };
    }

    @Override
    public <U> OptionalBinding<U> flatMap(final Function<T, Optional<U>> mapper) {
        return new PreboundOptionalBinding<U>(this.dependencies){

            protected Optional<U> computeValue() {
                return ((Optional)PreboundOptionalBinding.this.getValue()).flatMap(mapper);
            }
        };
    }

    @Override
    public EasyBinding<T> orElse(final T other) {
        return new EasyPreboundBinding<T>(this.dependencies){

            protected T computeValue() {
                return ((Optional)PreboundOptionalBinding.this.getValue()).orElse(other);
            }
        };
    }

    @Override
    public OptionalBinding<T> orElse(ObservableValue<T> other) {
        return new FirstNonNullBinding(new ObservableValue[]{this.asOrdinary(), other});
    }

    @Override
    public OptionalBinding<T> filter(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new PreboundOptionalBinding<T>(this.dependencies){

            protected Optional<T> computeValue() {
                return ((Optional)PreboundOptionalBinding.this.getValue()).filter(predicate);
            }
        };
    }

    @Override
    public BooleanBinding isPresent() {
        return Bindings.createBooleanBinding(() -> ((Optional)this.getValue()).isPresent(), (Observable[])this.dependencies);
    }

    @Override
    public BooleanBinding isEmpty() {
        return Bindings.createBooleanBinding(() -> !((Optional)this.getValue()).isPresent(), (Observable[])this.dependencies);
    }
}

